/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.context;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.teamapps.universaldb.context.UserContextImpl;

public interface UserContext {
    public static Comparator<String> createDefaultComparator(boolean ascending) {
        Collator collator = Collator.getInstance();
        collator.setDecomposition(1);
        collator.setStrength(0);
        return ascending ? Comparator.nullsFirst(collator) : Comparator.nullsLast(collator.reversed());
    }

    public static Comparator<String> getOrCreateComparator(UserContext userContext, boolean ascending) {
        return userContext != null ? userContext.getComparator(ascending) : UserContext.createDefaultComparator(ascending);
    }

    public static UserContext create(Locale locale) {
        return new UserContextImpl(locale);
    }

    public static UserContext create(String ... rankedLanguages) {
        return new UserContextImpl(rankedLanguages);
    }

    public static UserContext create(List<String> rankedLanguages) {
        return new UserContextImpl(rankedLanguages);
    }

    default public String getLanguage() {
        return this.getRankedLanguages().getFirst();
    }

    public Locale getLocale();

    default public Comparator<String> getComparator(boolean ascending) {
        Collator collator = Collator.getInstance(this.getLocale());
        collator.setDecomposition(1);
        collator.setStrength(0);
        return ascending ? Comparator.nullsFirst(collator) : Comparator.nullsLast(collator.reversed());
    }

    public List<String> getRankedLanguages();
}

