/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.util.HashSet;
import java.util.Set;
import org.teamapps.universaldb.index.IndexType;

public enum ColumnType {
    BOOLEAN,
    BITSET_BOOLEAN,
    SHORT,
    INT,
    LONG,
    FLOAT,
    DOUBLE,
    TEXT,
    TRANSLATABLE_TEXT,
    FILE,
    SINGLE_REFERENCE,
    MULTI_REFERENCE,
    TIMESTAMP,
    DATE,
    TIME,
    DATE_TIME,
    LOCAL_DATE,
    ENUM,
    BINARY,
    CURRENCY,
    DYNAMIC_CURRENCY;


    public boolean isReference() {
        return this == SINGLE_REFERENCE || this == MULTI_REFERENCE;
    }

    public boolean isDateBased() {
        return this == DATE || this == DATE_TIME || this == TIMESTAMP || this == LOCAL_DATE;
    }

    public IndexType getIndexType() {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return IndexType.BOOLEAN;
            }
            case 2: 
            case 17: {
                return IndexType.SHORT;
            }
            case 3: 
            case 12: 
            case 14: {
                return IndexType.INT;
            }
            case 4: 
            case 13: 
            case 15: 
            case 16: {
                return IndexType.LONG;
            }
            case 5: {
                return IndexType.FLOAT;
            }
            case 6: {
                return IndexType.DOUBLE;
            }
            case 7: {
                return IndexType.TEXT;
            }
            case 8: {
                return IndexType.TRANSLATABLE_TEXT;
            }
            case 9: {
                return IndexType.FILE;
            }
            case 18: {
                return IndexType.BINARY;
            }
            case 10: {
                return IndexType.REFERENCE;
            }
            case 11: {
                return IndexType.MULTI_REFERENCE;
            }
        }
        return null;
    }

    public static Set<String> getNames() {
        HashSet<String> nameSet = new HashSet<String>();
        for (ColumnType value : ColumnType.values()) {
            nameSet.add(value.name());
        }
        return nameSet;
    }
}

