/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.common;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.agrona.concurrent.AtomicBuffer;
import org.teamapps.universaldb.index.buffer.common.AbstractResizingAtomicStore;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;

public class AbstractBlockEntryAtomicStore
extends AbstractResizingAtomicStore {
    private final PrimitiveEntryAtomicStore positionBuffer;
    private long freeSpacePosition;
    private int maxDeletionLengthEntries = 1000;
    private int maxDeletionListSize = 100000;
    private Map<Integer, Deque<Long>> deletedEntriesMap = this.createDeletionEntriesMap();

    public AbstractBlockEntryAtomicStore(File path, String name) {
        super(path, name);
        this.positionBuffer = new PrimitiveEntryAtomicStore(path, name + "-pos");
        this.init();
        this.findAllDeletedBlocks();
    }

    private LinkedHashMap<Integer, Deque<Long>> createDeletionEntriesMap() {
        return new LinkedHashMap<Integer, Deque<Long>>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, Deque<Long>> eldest) {
                return this.size() > AbstractBlockEntryAtomicStore.this.maxDeletionLengthEntries;
            }
        };
    }

    private void init() {
        this.freeSpacePosition = this.positionBuffer.getFirstBuffer().getLong(0, byteOrder);
        if (this.freeSpacePosition == 0L) {
            this.freeSpacePosition = 8L;
        }
    }

    private void findAllDeletedBlocks() {
        LinkedHashMap<Integer, Deque<Long>> deletedEntriesMap = this.createDeletionEntriesMap();
        AtomicBuffer[] buffers = this.getBuffers();
        block0: for (int i = 0; i < buffers.length; ++i) {
            AtomicBuffer buffer = buffers[i];
            int offset = i == 0 ? 8 : 0;
            int capacity = buffer.capacity();
            while (offset + 4 < capacity) {
                int value = buffer.getInt(offset);
                if (value < 0) {
                    long deletedPosition = (long)i * 1966080000L + (long)offset;
                    Deque positions = deletedEntriesMap.computeIfAbsent(Math.abs(value), len -> new ArrayDeque());
                    if (positions.size() < this.maxDeletionListSize) {
                        positions.add(deletedPosition);
                    }
                }
                if (value == 0) continue block0;
                offset += 4 + Math.abs(value);
            }
        }
        this.deletedEntriesMap = deletedEntriesMap;
    }

    protected Long getFreeSlot(int length) {
        Deque<Long> positions = this.deletedEntriesMap.get(length);
        return positions != null ? positions.pollFirst() : null;
    }

    protected void setFreeSpacePosition(long position) {
        this.freeSpacePosition = position;
        this.positionBuffer.setLong(0, position);
    }

    public long getFreeSpacePosition() {
        return this.freeSpacePosition;
    }

    public int getBlockLength(int id) {
        long position = this.positionBuffer.getLong(id);
        if (position > 0L) {
            int bufferIndex = this.getBufferIndex(position);
            int offset = this.getOffset(position, bufferIndex);
            AtomicBuffer atomicBuffer = this.getBuffer(bufferIndex);
            return atomicBuffer.getInt(offset);
        }
        return 0;
    }

    public boolean isEmpty(int id) {
        return this.positionBuffer.getLong(id) == 0L;
    }

    public int getLastNonEmptyId() {
        int maximumId;
        for (int i = maximumId = this.positionBuffer.getMaximumId(8); i > 0; --i) {
            if (this.positionBuffer.getLong(i) <= 0L) continue;
            return i;
        }
        return -1;
    }

    protected void removeEntry(long position) {
        if (position > 0L) {
            int bufferIndex = this.getBufferIndex(position);
            int offset = this.getOffset(position, bufferIndex);
            AtomicBuffer atomicBuffer = this.getBuffer(bufferIndex);
            int length = atomicBuffer.getInt(offset);
            atomicBuffer.putInt(offset, -1 * length, byteOrder);
            Deque positions = this.deletedEntriesMap.computeIfAbsent(length, len -> new ArrayDeque());
            if (positions.size() < this.maxDeletionListSize) {
                positions.add(position);
            }
        }
    }

    protected long getBlockPosition(int id) {
        return this.positionBuffer.getLong(id);
    }

    protected void setBlockPosition(int id, long position) {
        this.positionBuffer.setLong(id, position);
    }

    @Override
    public void drop() {
        this.positionBuffer.drop();
        super.drop();
    }
}

