/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.model;

import java.io.IOException;
import java.util.HashMap;
import org.teamapps.message.protocol.message.AttributeType;
import org.teamapps.message.protocol.message.MessageDefinition;
import org.teamapps.message.protocol.message.MessageModelCollection;
import org.teamapps.message.protocol.model.EnumDefinition;
import org.teamapps.universaldb.model.DatabaseModel;
import org.teamapps.universaldb.model.EnumFieldModel;
import org.teamapps.universaldb.model.EnumModel;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.model.NamingUtils;
import org.teamapps.universaldb.model.ReferenceFieldModel;
import org.teamapps.universaldb.model.TableModel;

public class MessageModelConverter {
    public static MessageModelCollection createMessageModel(DatabaseModel dbModel) {
        return MessageModelConverter.createMessageModel(dbModel, "Data");
    }

    public static MessageModelCollection createMessageModel(DatabaseModel dbModel, String dtoSuffix) {
        MessageDefinition def;
        MessageModelCollection model = new MessageModelCollection(dbModel.getName(), dbModel.getNamespace(), dbModel.getVersion());
        HashMap<String, EnumDefinition> enumMap = new HashMap<String, EnumDefinition>();
        for (EnumModel dbModelEnum : dbModel.getEnums()) {
            EnumDefinition enumDefinition = model.createEnum(dbModelEnum.getName(), dbModelEnum.getEnumNames());
            enumMap.put(dbModelEnum.getName(), enumDefinition);
        }
        HashMap<String, MessageDefinition> modelMap = new HashMap<String, MessageDefinition>();
        for (TableModel table : dbModel.getLocalTables()) {
            def = model.createModel(table.getName() + dtoSuffix);
            modelMap.put(table.getName(), def);
        }
        for (TableModel table : dbModel.getLocalTables()) {
            def = (MessageDefinition)modelMap.get(table.getName());
            int counter = 1;
            for (FieldModel field : table.getFields()) {
                if (field.isMetaField()) continue;
                if (field.getFieldType() == FieldType.MULTI_REFERENCE) {
                    def.addMultiReference(field.getName(), counter++, (MessageDefinition)modelMap.get(((ReferenceFieldModel)field).getReferencedTable().getName()));
                    continue;
                }
                if (field.getFieldType() == FieldType.SINGLE_REFERENCE) {
                    def.addSingleReference(field.getName(), counter++, (MessageDefinition)modelMap.get(((ReferenceFieldModel)field).getReferencedTable().getName()));
                    continue;
                }
                if (field.getFieldType() == FieldType.ENUM) {
                    def.addEnum(field.getName(), (EnumDefinition)enumMap.get(((EnumFieldModel)field).getEnumModel().getName()), counter++);
                    continue;
                }
                def.addAttribute(field.getName(), counter++, MessageModelConverter.getType(field.getFieldType()));
            }
        }
        return model;
    }

    public static String createImportCode(DatabaseModel dbModel, String dtoSuffix) throws IOException {
        String start = "public static void importData(LogIterator logIterator) throws Exception {while (logIterator.hasNext()) {\n\tbyte[] bytes = logIterator.next();\n\tString messageUuid = Message.readMessageUuid(bytes);\n";
        String end = "\t}\n}\nlogIterator.close();\n}\n";
        StringBuilder sb = new StringBuilder();
        for (TableModel table : dbModel.getLocalTables()) {
            String tableName = table.getName();
            boolean first = sb.isEmpty();
            if (first) {
                sb.append("\tif ");
            } else {
                sb.append("\t} else if ");
            }
            String name = tableName + dtoSuffix;
            sb.append("(data.OBJECT_UUID.equals(messageUuid)) {\n".replace("data", NamingUtils.firstUpperCase(name)));
            sb.append("\t\t").append(NamingUtils.firstUpperCase(tableName)).append(" ").append(tableName).append(" = ").append(NamingUtils.firstUpperCase(tableName)).append(".create();").append("\n");
            sb.append("\t\t").append(NamingUtils.firstUpperCase(name)).append(" ").append(name).append(" = new ").append(NamingUtils.firstUpperCase(name)).append("(bytes);\n");
            for (FieldModel field : table.getFields()) {
                String fieldUpper = NamingUtils.firstUpperCase(field.getName());
                if (field.isMetaField()) continue;
                if (field.getFieldType() == FieldType.FILE) {
                    sb.append("\t\tif (").append(name).append(".get").append(fieldUpper).append("() != null) ").append(tableName).append(".set").append(fieldUpper).append("(").append(name).append(".get").append(fieldUpper).append("().getAsFile(), ").append(name).append(".get").append(fieldUpper).append("().getFileName());").append("\n");
                    continue;
                }
                if (field.getFieldType() == FieldType.BOOLEAN) {
                    sb.append("\t\t").append(tableName).append(".set").append(fieldUpper).append("(").append(name).append(".is").append(fieldUpper).append("());").append("\n");
                    continue;
                }
                sb.append("\t\t").append(tableName).append(".set").append(fieldUpper).append("(").append(name).append(".get").append(fieldUpper).append("());").append("\n");
            }
            sb.append("\t\t").append("if (").append(name).append(".getRecordCreatedBy() > 0) ").append(tableName).append(".setMetaCreatedBy(").append(name).append(".getRecordCreatedBy());").append("\n");
            sb.append("\t\t").append("if (").append(name).append(".getRecordModifiedBy() > 0) ").append(tableName).append(".setMetaModifiedBy(").append(name).append(".getRecordModifiedBy());").append("\n");
            sb.append("\t\t").append("if (").append(name).append(".getRecordCreationDate() != null) ").append(tableName).append(".setMetaCreationDate(").append(name).append(".getRecordCreationDate());").append("\n");
            sb.append("\t\t").append("if (").append(name).append(".getRecordModificationDate() != null) ").append(tableName).append(".setMetaModificationDate(").append(name).append(".getRecordModificationDate());").append("\n");
            sb.append("\t\t").append(tableName).append(".save();\n");
        }
        return start + sb.toString() + end;
    }

    private static AttributeType getType(FieldType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case FieldType.BOOLEAN -> AttributeType.BOOLEAN;
            case FieldType.SHORT -> AttributeType.INT;
            case FieldType.INT -> AttributeType.INT;
            case FieldType.LONG -> AttributeType.LONG;
            case FieldType.FLOAT -> AttributeType.FLOAT;
            case FieldType.DOUBLE -> AttributeType.DOUBLE;
            case FieldType.TEXT -> AttributeType.STRING;
            case FieldType.TRANSLATABLE_TEXT -> AttributeType.STRING;
            case FieldType.FILE -> AttributeType.FILE;
            case FieldType.SINGLE_REFERENCE -> AttributeType.OBJECT_SINGLE_REFERENCE;
            case FieldType.MULTI_REFERENCE -> AttributeType.OBJECT_MULTI_REFERENCE;
            case FieldType.TIMESTAMP -> AttributeType.TIMESTAMP_32;
            case FieldType.DATE -> AttributeType.TIMESTAMP_64;
            case FieldType.TIME -> AttributeType.TIMESTAMP_64;
            case FieldType.DATE_TIME -> AttributeType.TIMESTAMP_64;
            case FieldType.LOCAL_DATE -> AttributeType.DATE;
            case FieldType.ENUM -> AttributeType.ENUM;
            case FieldType.BINARY -> AttributeType.BYTE_ARRAY;
            case FieldType.CURRENCY -> null;
            case FieldType.DYNAMIC_CURRENCY -> null;
        };
    }
}

