/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.universaldb.model.DatabaseModel;
import org.teamapps.universaldb.model.EnumFieldModel;
import org.teamapps.universaldb.model.EnumModel;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.model.FileFieldModel;
import org.teamapps.universaldb.model.NamingUtils;
import org.teamapps.universaldb.model.ReferenceFieldModel;

public class TableModel {
    private static final int TABLE_MODEL_VERSION = 1;
    public static final String FIELD_CREATION_DATE = "metaCreationDate";
    public static final String FIELD_CREATED_BY = "metaCreatedBy";
    public static final String FIELD_MODIFICATION_DATE = "metaModificationDate";
    public static final String FIELD_MODIFIED_BY = "metaModifiedBy";
    public static final String FIELD_DELETION_DATE = "metaDeletionDate";
    public static final String FIELD_DELETED_BY = "metaDeletedBy";
    public static final String FIELD_RESTORE_DATE = "metaRestoreDate";
    public static final String FIELD_RESTORED_BY = "metaRestoredBy";
    public static final String FIELD_ID = "id";
    public static final String[] FORBIDDEN_COLUMN_NAMES = new String[]{"metaCreationDate", "metaCreatedBy", "metaModificationDate", "metaModifiedBy", "metaDeletionDate", "metaDeletedBy", "metaRestoreDate", "metaRestoredBy", "id", "coll-recs", "coll-del-recs", "versioning-pos", "matches"};
    private final DatabaseModel databaseModel;
    private final String name;
    private final String title;
    private final boolean remoteTable;
    private final String remoteTableName;
    private final String remoteDatabase;
    private final String remoteDatabaseNamespace;
    private final boolean trackModifications;
    private final boolean versioning;
    private final boolean recoverableRecords;
    private final List<FieldModel> fields = new ArrayList<FieldModel>();
    private int tableId;
    private boolean deprecated;
    private boolean deleted;
    private int dateCreated;
    private int dateModified;
    private int versionCreated;
    private int versionModified;

    protected TableModel(DatabaseModel databaseModel, String name, String title, boolean remoteTable, String remoteDatabase, String remoteDatabaseNamespace, boolean trackModifications, boolean versioning, boolean recoverableRecords) {
        this(databaseModel, name, title, remoteTable, null, remoteDatabase, remoteDatabaseNamespace, trackModifications, versioning, recoverableRecords);
    }

    protected TableModel(DatabaseModel databaseModel, String name, String title, boolean remoteTable, String remoteTableName, String remoteDatabase, String remoteDatabaseNamespace, boolean trackModifications, boolean versioning, boolean recoverableRecords) {
        NamingUtils.checkName(name, title);
        this.databaseModel = databaseModel;
        this.name = NamingUtils.createName(name);
        this.title = NamingUtils.createTitle(title);
        this.remoteTable = remoteTable;
        this.remoteTableName = remoteTableName != null ? remoteTableName : name;
        this.remoteDatabase = remoteDatabase;
        this.remoteDatabaseNamespace = remoteDatabaseNamespace;
        this.trackModifications = trackModifications;
        this.versioning = versioning;
        this.recoverableRecords = recoverableRecords;
        if (trackModifications) {
            this.addTimestamp(FIELD_CREATION_DATE);
            this.addInteger(FIELD_CREATED_BY);
            this.addTimestamp(FIELD_MODIFICATION_DATE);
            this.addInteger(FIELD_MODIFIED_BY);
        }
        if (recoverableRecords) {
            this.addTimestamp(FIELD_DELETION_DATE);
            this.addInteger(FIELD_DELETED_BY);
            this.addTimestamp(FIELD_RESTORE_DATE);
            this.addInteger(FIELD_RESTORED_BY);
        }
    }

    protected TableModel(DataInputStream dis, List<Function<DatabaseModel, Boolean>> resolveFunctions, DatabaseModel databaseModel) throws IOException {
        this.databaseModel = databaseModel;
        int modelVersion = dis.readInt();
        this.name = MessageUtils.readString((DataInputStream)dis);
        this.title = MessageUtils.readString((DataInputStream)dis);
        this.remoteTable = dis.readBoolean();
        this.remoteTableName = this.remoteTable ? MessageUtils.readString((DataInputStream)dis) : null;
        this.remoteDatabase = this.remoteTable ? MessageUtils.readString((DataInputStream)dis) : null;
        this.remoteDatabaseNamespace = this.remoteTable ? MessageUtils.readString((DataInputStream)dis) : null;
        this.trackModifications = dis.readBoolean();
        this.versioning = dis.readBoolean();
        this.recoverableRecords = dis.readBoolean();
        this.tableId = dis.readInt();
        this.deprecated = dis.readBoolean();
        this.deleted = dis.readBoolean();
        this.dateCreated = dis.readInt();
        this.dateModified = dis.readInt();
        this.versionCreated = dis.readInt();
        this.versionModified = dis.readInt();
        int fieldCount = dis.readInt();
        for (int i = 0; i < fieldCount; ++i) {
            FieldType fieldType = FieldType.getTypeById(dis.readInt());
            if (fieldType == FieldType.ENUM) {
                this.addFieldModel(new EnumFieldModel(dis, this, databaseModel));
                continue;
            }
            if (fieldType == FieldType.SINGLE_REFERENCE || fieldType == FieldType.MULTI_REFERENCE) {
                this.addFieldModel(new ReferenceFieldModel(dis, this, resolveFunctions));
                continue;
            }
            if (fieldType == FieldType.FILE) {
                this.addFieldModel(new FileFieldModel(dis, this));
                continue;
            }
            this.addFieldModel(new FieldModel(dis, this));
        }
    }

    public static boolean isReservedMetaName(String name) {
        for (String columnName : FORBIDDEN_COLUMN_NAMES) {
            if (!name.equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(1);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.name);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.title);
        dos.writeBoolean(this.remoteTable);
        if (this.remoteTable) {
            MessageUtils.writeString((DataOutputStream)dos, (String)this.remoteTableName);
            MessageUtils.writeString((DataOutputStream)dos, (String)this.remoteDatabase);
            MessageUtils.writeString((DataOutputStream)dos, (String)this.remoteDatabaseNamespace);
        }
        dos.writeBoolean(this.trackModifications);
        dos.writeBoolean(this.versioning);
        dos.writeBoolean(this.recoverableRecords);
        dos.writeInt(this.tableId);
        dos.writeBoolean(this.deprecated);
        dos.writeBoolean(this.deleted);
        dos.writeInt(this.dateCreated);
        dos.writeInt(this.dateModified);
        dos.writeInt(this.versionCreated);
        dos.writeInt(this.versionModified);
        dos.writeInt(this.fields.size());
        for (FieldModel field : this.fields) {
            dos.writeInt(field.getFieldType().getId());
            field.write(dos);
        }
    }

    public FieldModel getField(String fieldName) {
        return this.fields.stream().filter(f -> f.getName().equals(fieldName)).findAny().orElse(null);
    }

    public ReferenceFieldModel getReferenceField(String fieldName) {
        FieldModel fieldModel = this.fields.stream().filter(f -> f.getName().equals(fieldName)).findAny().orElse(null);
        return fieldModel != null && fieldModel.getFieldType().isReference() ? (ReferenceFieldModel)fieldModel : null;
    }

    public ReferenceFieldModel addReference(String name, TableModel referencedTable) {
        return this.addReference(name, referencedTable, false);
    }

    public ReferenceFieldModel addReference(String name, TableModel referencedTable, boolean cascadeDelete) {
        return this.addReference(name, name, referencedTable, cascadeDelete);
    }

    public ReferenceFieldModel addReference(String name, String title, String referencedTable, boolean cascadeDelete) {
        TableModel tableModel = this.databaseModel.getTable(referencedTable);
        return this.addReference(name, title, tableModel, cascadeDelete);
    }

    public ReferenceFieldModel addReference(String name, String title, TableModel referencedTable, boolean cascadeDelete) {
        ReferenceFieldModel referenceFieldModel = new ReferenceFieldModel(name, title, this, referencedTable, false, cascadeDelete, null);
        this.addFieldModel(referenceFieldModel);
        return referenceFieldModel;
    }

    public ReferenceFieldModel addReference(String name, ReferenceFieldModel reverseReference) {
        return this.addReference(name, reverseReference, false);
    }

    public ReferenceFieldModel addReference(String name, ReferenceFieldModel reverseReference, boolean cascadeDelete) {
        return this.addReference(name, name, reverseReference, cascadeDelete);
    }

    public ReferenceFieldModel addReference(String name, String title, ReferenceFieldModel reverseReference, boolean cascadeDelete) {
        ReferenceFieldModel referenceFieldModel = new ReferenceFieldModel(name, title, this, reverseReference.getTableModel(), false, cascadeDelete, reverseReference);
        this.addFieldModel(referenceFieldModel);
        return referenceFieldModel;
    }

    public ReferenceFieldModel addMultiReference(String name, TableModel referencedTable) {
        return this.addMultiReference(name, referencedTable, false);
    }

    public ReferenceFieldModel addMultiReference(String name, TableModel referencedTable, boolean cascadeDelete) {
        return this.addMultiReference(name, name, referencedTable, cascadeDelete);
    }

    public ReferenceFieldModel addMultiReference(String name, String title, String referencedTable, boolean cascadeDelete) {
        TableModel tableModel = this.databaseModel.getTable(referencedTable);
        return this.addMultiReference(name, title, tableModel, cascadeDelete);
    }

    public ReferenceFieldModel addMultiReference(String name, String title, TableModel referencedTable, boolean cascadeDelete) {
        ReferenceFieldModel referenceFieldModel = new ReferenceFieldModel(name, title, this, referencedTable, true, cascadeDelete, null);
        this.addFieldModel(referenceFieldModel);
        return referenceFieldModel;
    }

    public ReferenceFieldModel addMultiReference(String name, ReferenceFieldModel reverseReference) {
        return this.addMultiReference(name, reverseReference, false);
    }

    public ReferenceFieldModel addMultiReference(String name, ReferenceFieldModel reverseReference, boolean cascadeDelete) {
        return this.addMultiReference(name, name, reverseReference, cascadeDelete);
    }

    public ReferenceFieldModel addMultiReference(String name, String title, ReferenceFieldModel reverseReference, boolean cascadeDelete) {
        ReferenceFieldModel referenceFieldModel = new ReferenceFieldModel(name, title, this, reverseReference.getTableModel(), true, cascadeDelete, reverseReference);
        this.addFieldModel(referenceFieldModel);
        return referenceFieldModel;
    }

    public EnumFieldModel addEnum(EnumModel enumModel) {
        return this.addEnum(enumModel.getName(), enumModel.getTitle(), enumModel);
    }

    public EnumFieldModel addEnum(String name, EnumModel enumModel) {
        return this.addEnum(name, name, enumModel);
    }

    public EnumFieldModel addEnum(String name, String title, String enumName) {
        EnumModel enumModel = this.databaseModel.getEnumModel(enumName);
        return this.addEnum(name, title, enumModel);
    }

    public EnumFieldModel addEnum(String name, String title, EnumModel enumModel) {
        if (enumModel == null) {
            throw new RuntimeException("Error: missing enum model for field:" + name);
        }
        EnumFieldModel enumFieldModel = new EnumFieldModel(name, title, this, enumModel);
        this.addFieldModel(enumFieldModel);
        return enumFieldModel;
    }

    public FileFieldModel addFile(String name) {
        return this.addFile(name, name, true, true);
    }

    public FileFieldModel addFile(String name, boolean index) {
        return this.addFile(name, name, index, index);
    }

    public FileFieldModel addFile(String name, String title) {
        return this.addFile(name, title, true, true);
    }

    public FileFieldModel addFile(String name, String title, boolean indexContent, boolean detectLanguage) {
        return this.addFile(name, title, indexContent, 100000, detectLanguage);
    }

    public FileFieldModel addFile(String name, String title, boolean indexContent, int maxIndexContentLength, boolean detectLanguage) {
        FileFieldModel fileFieldModel = new FileFieldModel(name, title, this, indexContent, maxIndexContentLength, detectLanguage);
        this.addFieldModel(fileFieldModel);
        return fileFieldModel;
    }

    public FieldModel addBoolean(String name) {
        return this.addFieldModel(name, FieldType.BOOLEAN);
    }

    public FieldModel addShort(String name) {
        return this.addFieldModel(name, FieldType.SHORT);
    }

    public FieldModel addInteger(String name) {
        return this.addFieldModel(name, FieldType.INT);
    }

    public FieldModel addLong(String name) {
        return this.addFieldModel(name, FieldType.LONG);
    }

    public FieldModel addFloat(String name) {
        return this.addFieldModel(name, FieldType.FLOAT);
    }

    public FieldModel addDouble(String name) {
        return this.addFieldModel(name, FieldType.DOUBLE);
    }

    public FieldModel addText(String name) {
        return this.addFieldModel(name, FieldType.TEXT);
    }

    public FieldModel addTranslatableText(String name) {
        return this.addFieldModel(name, FieldType.TRANSLATABLE_TEXT);
    }

    public FieldModel addByteArray(String name) {
        return this.addFieldModel(name, FieldType.BINARY);
    }

    public FieldModel addTimestamp(String name) {
        return this.addFieldModel(name, FieldType.TIMESTAMP);
    }

    public FieldModel addLocalDate(String name) {
        return this.addFieldModel(name, FieldType.LOCAL_DATE);
    }

    public FieldModel addDateTime(String name) {
        return this.addFieldModel(name, FieldType.DATE_TIME);
    }

    public FieldModel addDate(String name) {
        return this.addFieldModel(name, FieldType.DATE);
    }

    public FieldModel addTime(String name) {
        return this.addFieldModel(name, FieldType.TIME);
    }

    public FieldModel addBoolean(String name, String title) {
        return this.addFieldModel(name, title, FieldType.BOOLEAN);
    }

    public FieldModel addShort(String name, String title) {
        return this.addFieldModel(name, title, FieldType.SHORT);
    }

    public FieldModel addInteger(String name, String title) {
        return this.addFieldModel(name, title, FieldType.INT);
    }

    public FieldModel addLong(String name, String title) {
        return this.addFieldModel(name, title, FieldType.LONG);
    }

    public FieldModel addFloat(String name, String title) {
        return this.addFieldModel(name, title, FieldType.FLOAT);
    }

    public FieldModel addDouble(String name, String title) {
        return this.addFieldModel(name, title, FieldType.DOUBLE);
    }

    public FieldModel addText(String name, String title) {
        return this.addFieldModel(name, title, FieldType.TEXT);
    }

    public FieldModel addTranslatableText(String name, String title) {
        return this.addFieldModel(name, title, FieldType.TRANSLATABLE_TEXT);
    }

    public FieldModel addByteArray(String name, String title) {
        return this.addFieldModel(name, title, FieldType.BINARY);
    }

    public FieldModel addTimestamp(String name, String title) {
        return this.addFieldModel(name, title, FieldType.TIMESTAMP);
    }

    public FieldModel addLocalDate(String name, String title) {
        return this.addFieldModel(name, title, FieldType.LOCAL_DATE);
    }

    public FieldModel addDateTime(String name, String title) {
        return this.addFieldModel(name, title, FieldType.DATE_TIME);
    }

    public FieldModel addDate(String name, String title) {
        return this.addFieldModel(name, title, FieldType.DATE);
    }

    public FieldModel addTime(String name, String title) {
        return this.addFieldModel(name, title, FieldType.TIME);
    }

    private FieldModel addFieldModel(String title, FieldType fieldType) {
        return this.addFieldModel(title, title, fieldType);
    }

    private FieldModel addFieldModel(String name, String title, FieldType fieldType) {
        FieldModel fieldModel = new FieldModel(name, title, this, fieldType);
        this.addFieldModel(fieldModel);
        return fieldModel;
    }

    protected FieldModel addFieldModel(FieldModel fieldModel) {
        if (this.fields.stream().anyMatch(f -> f.getName().equals(fieldModel.getName()))) {
            throw new RuntimeException("Adding duplicate field names not allowed, table:" + this.getName() + ", field-name:" + fieldModel.getName());
        }
        this.fields.add(fieldModel);
        return fieldModel;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getRemoteTableName() {
        return this.remoteTableName;
    }

    public boolean isRemoteTable() {
        return this.remoteTable;
    }

    public String getRemoteDatabase() {
        return this.remoteDatabase;
    }

    public String getRemoteDatabaseNamespace() {
        return this.remoteDatabaseNamespace;
    }

    public boolean isTrackModifications() {
        return this.trackModifications;
    }

    public boolean isVersioning() {
        return this.versioning;
    }

    public boolean isRecoverableRecords() {
        return this.recoverableRecords;
    }

    public List<FieldModel> getFields() {
        return new ArrayList<FieldModel>(this.fields);
    }

    public List<ReferenceFieldModel> getReferenceFields() {
        return this.fields.stream().filter(f -> f.getFieldType().isReference()).map(f -> (ReferenceFieldModel)f).collect(Collectors.toList());
    }

    public List<EnumFieldModel> getEnumFields() {
        return this.fields.stream().filter(f -> f.getFieldType() == FieldType.ENUM).map(f -> (EnumFieldModel)f).collect(Collectors.toList());
    }

    public List<FileFieldModel> getFileFields() {
        return this.fields.stream().filter(f -> f.getFieldType() == FieldType.FILE).map(f -> (FileFieldModel)f).collect(Collectors.toList());
    }

    public int getTableId() {
        return this.tableId;
    }

    protected void setTableId(int tableId) {
        if (this.tableId != 0) {
            throw new RuntimeException("Error: table id already set:" + this.tableId + ", new:" + tableId);
        }
        this.tableId = tableId;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    protected void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public int getDateCreated() {
        return this.dateCreated;
    }

    protected void setDateCreated(int dateCreated) {
        this.dateCreated = dateCreated;
    }

    public int getDateModified() {
        return this.dateModified;
    }

    protected void setDateModified(int dateModified) {
        this.dateModified = dateModified;
    }

    public int getVersionCreated() {
        return this.versionCreated;
    }

    protected void setVersionCreated(int versionCreated) {
        this.versionCreated = versionCreated;
    }

    public int getVersionModified() {
        return this.versionModified;
    }

    protected void setVersionModified(int versionModified) {
        this.versionModified = versionModified;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String type = this.remoteTable ? "remote table (" + this.remoteDatabase + ")" : "table";
        sb.append(type).append(": ").append(this.name).append(" (").append(this.title).append(")").append(" [").append(this.tableId).append("]\n");
        for (FieldModel field : this.fields) {
            sb.append("\t").append(field.toString()).append("\n");
        }
        return sb.toString();
    }
}

