/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.query;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.text.TextFieldFilter;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.universaldb.query.IndexFilter;
import org.teamapps.universaldb.query.IndexPath;

public class AndFilter
implements Filter {
    private List<Filter> filters = new ArrayList<Filter>();

    public AndFilter() {
    }

    public AndFilter(Filter filterA, Filter filterB) {
        this.filters.add(filterA);
        this.filters.add(filterB);
    }

    @Override
    public Filter and(Filter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    @Override
    public void prependPath(IndexPath path) {
        this.filters.forEach(filter -> filter.prependPath(path));
    }

    @Override
    public BitSet filter(BitSet input) {
        List<List<Filter>> mappedFilters = Filter.mapFiltersByPathAndExpense(this.filters);
        BitSet result = input;
        for (List<Filter> filters : mappedFilters) {
            IndexPath path = filters.get(0).getPath();
            if (path == null) {
                for (Filter filter : filters) {
                    result.and(filter.filter(result));
                }
                continue;
            }
            BitSet localRecords = path.calculatePathBitSet(result);
            List<IndexFilter> collectionFullTextFilters = Filter.getCollectionFullTextFilters(filters);
            if (!collectionFullTextFilters.isEmpty()) {
                Iterator<IndexFilter> textFilters = IndexFilter.createTextFilters(collectionFullTextFilters);
                TableIndex tableIndex = collectionFullTextFilters.get(0).getColumnIndex().getTable();
                localRecords = tableIndex.getCollectionTextSearchIndex().filter(localRecords, (List<TextFieldFilter>)((Object)textFilters), true);
            }
            for (Filter filter : Filter.getNonCollectionFullTextFilters(filters)) {
                localRecords = filter.localFilter(localRecords);
            }
            for (IndexFilter indexFilter : Filter.getCollectionFullTextFiltersWithLocalIndexFilterPart(filters)) {
                AbstractIndex textIndex;
                FieldIndex fieldIndex = indexFilter.getColumnIndex();
                if (fieldIndex instanceof TextIndex) {
                    textIndex = (TextIndex)fieldIndex;
                    localRecords = ((TextIndex)textIndex).filter(localRecords, (TextFilter)indexFilter.getFilter(), false);
                    continue;
                }
                if (fieldIndex instanceof TranslatableTextIndex) {
                    textIndex = (TranslatableTextIndex)fieldIndex;
                    localRecords = ((TranslatableTextIndex)textIndex).filter(localRecords, (TextFilter)indexFilter.getFilter(), false);
                    continue;
                }
                if (!(fieldIndex instanceof FileIndex)) continue;
                FileIndex fileIndex = (FileIndex)fieldIndex;
            }
            BitSet pathResult = path.calculateReversePath(localRecords, result);
            result.and(pathResult);
        }
        return result;
    }

    @Override
    public BitSet localFilter(BitSet localRecords) {
        BitSet result = localRecords;
        for (Filter filter : this.filters) {
            result = filter.localFilter(result);
        }
        return result;
    }

    @Override
    public IndexPath getPath() {
        IndexPath lastPath = null;
        for (Filter filter : this.filters) {
            if (lastPath == null) {
                lastPath = filter.getPath();
                continue;
            }
            if (lastPath.isSamePath(filter.getPath())) continue;
            return null;
        }
        return lastPath;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public String explain(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getExplainTabs(level)).append("AND (").append("\n");
        for (Filter filter : this.filters) {
            sb.append(filter.explain(level + 1));
        }
        sb.append(this.getExplainTabs(level)).append(")").append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.explain(0);
    }
}

