/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.teamapps.universaldb.context.UserContext;

public class UserContextImpl
implements UserContext {
    private final String language;
    private final Locale locale;
    private final List<String> rankedLanguages;

    public UserContextImpl(Locale locale) {
        this.locale = locale;
        this.language = locale.getLanguage();
        this.rankedLanguages = Collections.singletonList(this.language);
    }

    public UserContextImpl(String ... rankedLanguages) {
        this(Arrays.asList(rankedLanguages));
    }

    public UserContextImpl(List<String> rankedLanguages) {
        if (rankedLanguages == null || rankedLanguages.isEmpty()) {
            rankedLanguages = Collections.singletonList("en");
        }
        this.rankedLanguages = rankedLanguages;
        this.language = rankedLanguages.getFirst();
        this.locale = Locale.forLanguageTag(this.language);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public List<String> getRankedLanguages() {
        return this.rankedLanguages;
    }
}

