/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.chain;

import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.agrona.concurrent.AtomicBuffer;
import org.teamapps.universaldb.index.buffer.chain.BlockChainType;

public class BlockChainEntry {
    private static final int BLOCK_COUNT_OFFSET = 4;
    private static final int TOTAL_COUNT_OFFSET = 8;
    private static final int NEXT_BLOCK_OFFSET = 12;
    private static final int LAST_BLOCK_OFFSET = 20;
    private final long position;
    private final int offset;
    private final AtomicBuffer buffer;
    private final BlockChainType chainType;
    private final ByteOrder byteOrder;

    public BlockChainEntry(long position, int offset, AtomicBuffer buffer, BlockChainType chainType, ByteOrder byteOrder) {
        this.position = position;
        this.offset = offset;
        this.buffer = buffer;
        this.chainType = chainType;
        this.byteOrder = byteOrder;
    }

    public int getAvailableSpace() {
        return this.chainType.getItems() - this.getBlockCount();
    }

    public void clearEntry() {
        this.writeInt(this.offset + 4, 0);
        if (this.chainType.isChain()) {
            this.writeInt(this.offset + 8, 0);
            this.writeLong(this.offset + 12, 0L);
            this.writeLong(this.offset + 20, 0L);
        }
        int pos = this.offset + this.chainType.getDataOffset();
        for (int i = 0; i < this.chainType.getItems(); ++i) {
            this.writeInt(pos, 0);
            pos += 4;
        }
    }

    public void readBlockEntries(List<Integer> list) {
        int blockCount = this.getBlockCount();
        int pos = this.offset + this.chainType.getDataOffset();
        for (int i = 0; i < this.chainType.getItems(); ++i) {
            int value = this.readInt(pos);
            if (value > 0) {
                list.add(value);
            }
            pos += 4;
        }
    }

    public boolean containsBlockEntry(int entry) {
        int pos = this.offset + this.chainType.getDataOffset();
        for (int i = 0; i < this.chainType.getItems(); ++i) {
            int value = this.readInt(pos);
            if (value != entry) continue;
            return true;
        }
        return false;
    }

    public boolean containsBlockEntry(BitSet bitSet) {
        int pos = this.offset + this.chainType.getDataOffset();
        for (int i = 0; i < this.chainType.getItems(); ++i) {
            int value = this.readInt(pos);
            if (value <= 0 || !bitSet.get(value)) continue;
            return true;
        }
        return false;
    }

    public int writeBlockEntries(int startListPos, int length, List<Integer> list) {
        int listPos = startListPos;
        int writtenEntries = 0;
        int pos = this.offset + this.chainType.getDataOffset();
        for (int i = 0; i < this.chainType.getItems(); ++i) {
            if (this.readInt(pos) <= 0) {
                this.writeInt(pos, list.get(listPos));
                ++listPos;
                if (++writtenEntries == length) break;
            }
            pos += 4;
        }
        this.addBlockCount(writtenEntries);
        return writtenEntries;
    }

    public int removeBlockEntries(Set<Integer> valueSet) {
        int pos = this.offset + this.chainType.getDataOffset();
        int deletionCount = 0;
        for (int i = 0; i < this.chainType.getItems(); ++i) {
            int value = this.readInt(pos);
            if (value > 0 && valueSet.contains(value)) {
                this.writeInt(pos, 0);
                ++deletionCount;
            }
            pos += 4;
        }
        this.subtractBlockCount(deletionCount);
        return deletionCount;
    }

    private void writeInt(int pos, int value) {
        this.buffer.putInt(pos, value, this.byteOrder);
    }

    private void writeLong(int pos, long value) {
        this.buffer.putLong(pos, value, this.byteOrder);
    }

    private int readInt(int pos) {
        return this.buffer.getInt(pos, this.byteOrder);
    }

    private long readLong(int pos) {
        return this.buffer.getLong(pos, this.byteOrder);
    }

    public int getTotalCount() {
        if (this.chainType.isChain()) {
            return this.readInt(this.offset + 8);
        }
        return this.getBlockCount();
    }

    public void writeTotalCount(int count) {
        if (this.chainType.isChain()) {
            this.writeInt(this.offset + 8, count);
        }
    }

    public void addTotalCount(int add) {
        if (this.chainType.isChain()) {
            int totalCount = this.getTotalCount();
            this.writeTotalCount(totalCount + add);
        }
    }

    public void subtractTotalCont(int subtract) {
        if (this.chainType.isChain()) {
            int totalCount = this.getTotalCount();
            this.writeTotalCount(totalCount - subtract);
        }
    }

    public int getBlockCount() {
        return this.readInt(this.offset + 4);
    }

    public void writeBlockCount(int count) {
        this.writeInt(this.offset + 4, count);
    }

    public void addBlockCount(int add) {
        int blockCount = this.getBlockCount();
        this.writeBlockCount(blockCount + add);
    }

    public void subtractBlockCount(int subtract) {
        int blockCount = this.getBlockCount();
        this.writeBlockCount(blockCount - subtract);
    }

    public long getNextBlockPosition() {
        if (this.chainType.isChain()) {
            return this.readLong(this.offset + 12);
        }
        return 0L;
    }

    public void writeNextBlockPosition(long position) {
        if (this.chainType.isChain()) {
            this.writeLong(this.offset + 12, position);
        }
    }

    public long getLastBlockPosition() {
        if (this.chainType.isChain()) {
            return this.readLong(this.offset + 20);
        }
        return 0L;
    }

    public void writeLastBlockPosition(long position) {
        if (this.chainType.isChain()) {
            this.writeLong(this.offset + 20, position);
        }
    }

    public long getPosition() {
        return this.position;
    }

    public int getOffset() {
        return this.offset;
    }

    public AtomicBuffer getBuffer() {
        return this.buffer;
    }

    public BlockChainType getChainType() {
        return this.chainType;
    }
}

