/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.teamapps.message.protocol.file.FileDataReader;
import org.teamapps.message.protocol.file.FileDataWriter;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.model.PojoObjectDecoder;
import org.teamapps.universaldb.index.log.DefaultLogIndex;
import org.teamapps.universaldb.index.log.LogIndex;
import org.teamapps.universaldb.index.log.LogIterator;
import org.teamapps.universaldb.index.log.RotatingLogIndex;

public class MessageLog<TYPE extends Message> {
    private final LogIndex logIndex;
    private final FileDataReader fileDataReader;
    private final FileDataWriter fileDataWriter;
    private PojoObjectDecoder<TYPE> pojoObjectDecoder;

    public MessageLog(File basePath, String name, boolean rotating, FileDataReader fileDataReader, FileDataWriter fileDataWriter, PojoObjectDecoder<TYPE> pojoObjectDecoder) {
        this.fileDataReader = fileDataReader;
        this.fileDataWriter = fileDataWriter;
        this.pojoObjectDecoder = pojoObjectDecoder;
        this.logIndex = rotating ? new RotatingLogIndex(basePath, name) : new DefaultLogIndex(basePath, name);
    }

    public long addMessage(Message message) throws IOException {
        byte[] bytes = message.toBytes(this.fileDataWriter);
        return this.logIndex.writeLog(bytes);
    }

    public Message readMessage(long position) throws IOException {
        byte[] bytes = this.logIndex.readLog(position);
        return (Message)this.pojoObjectDecoder.decode(bytes, this.fileDataReader);
    }

    public Iterator<TYPE> getMessages(long startPos) {
        final LogIterator logIterator = this.logIndex.readLogs(startPos);
        return new Iterator<TYPE>(this){
            final /* synthetic */ MessageLog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return logIterator.hasNext();
            }

            @Override
            public TYPE next() {
                byte[] bytes = logIterator.next();
                return (Message)this.this$0.pojoObjectDecoder.decode(bytes, this.this$0.fileDataReader);
            }
        };
    }

    public void close() {
        this.logIndex.close();
    }
}

