/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.value;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RecordReference {
    private int recordId;
    private final int correlationId;

    public static List<Integer> createRecordIdsList(List<RecordReference> references) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (RecordReference reference : references) {
            if (reference.getRecordId() <= 0) continue;
            list.add(reference.getRecordId());
        }
        return list;
    }

    public RecordReference(int recordId, int correlationId) {
        this.recordId = recordId;
        this.correlationId = correlationId;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public int getCorrelationId() {
        return this.correlationId;
    }

    public void setRecordId(int recordId) {
        if (recordId == 0) {
            return;
        }
        this.recordId = recordId;
    }

    public void updateReference(Map<Integer, Integer> recordIdByCorrelationId) {
        if (this.recordId == 0) {
            this.recordId = recordIdByCorrelationId.get(this.correlationId);
        }
    }

    public String toString() {
        if (this.recordId > 0) {
            return "" + this.recordId;
        }
        return "(" + this.recordId + ", " + this.correlationId + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordReference that = (RecordReference)o;
        if (this.recordId != 0 && this.recordId == that.getRecordId()) {
            return true;
        }
        return this.correlationId != 0 && this.correlationId == that.getCorrelationId();
    }

    public int hashCode() {
        if (this.recordId != 0) {
            return this.recordId;
        }
        return this.correlationId;
    }
}

