/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.message.protocol.message.MessageRecord;

public class MessageCache<MESSAGE extends MessageRecord> {
    private final boolean fullCache;
    private final Map<Integer, MESSAGE> messageMap;
    private final List<MESSAGE> messageList;

    public static <MESSAGE extends MessageRecord> MessageCache<MESSAGE> fullCache() {
        return new MessageCache<MESSAGE>(true, 0);
    }

    public static <MESSAGE extends MessageRecord> MessageCache<MESSAGE> lruCache(int size) {
        return new MessageCache<MESSAGE>(false, size);
    }

    private MessageCache(boolean fullCache, final int maxSize) {
        this.fullCache = fullCache;
        this.messageMap = !fullCache ? new LinkedHashMap<Integer, MESSAGE>(this){
            final /* synthetic */ MessageCache this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, MESSAGE> eldest) {
                return this.size() >= maxSize;
            }
        } : new HashMap();
        this.messageList = fullCache ? new ArrayList() : null;
    }

    public void addMessage(int id, boolean update, MESSAGE message) {
        if (this.fullCache) {
            MessageRecord oldMessage;
            if (update && (oldMessage = (MessageRecord)this.messageMap.get(id)) != null) {
                this.messageList.remove(oldMessage);
            }
            this.messageList.add(message);
        }
        this.messageMap.put(id, message);
    }

    public void removeMessage(int id) {
        MessageRecord oldMessage = (MessageRecord)this.messageMap.remove(id);
        if (this.fullCache && oldMessage != null) {
            this.messageList.remove(oldMessage);
        }
    }

    public MESSAGE getMessage(int id) {
        return (MESSAGE)((MessageRecord)this.messageMap.get(id));
    }

    public List<MESSAGE> getMessages() {
        return new ArrayList<MESSAGE>(this.messageList);
    }

    public int getMessageCount() {
        return this.messageList.size();
    }

    public boolean isFullCache() {
        return this.fullCache;
    }
}

