/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo.template;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.binary.BinaryFilter;
import org.teamapps.universaldb.index.binary.BinaryIndex;
import org.teamapps.universaldb.index.bool.BooleanFilter;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.numeric.DoubleIndex;
import org.teamapps.universaldb.index.numeric.FloatIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceFilter;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.translation.TranslatableTextFilter;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.universaldb.model.EnumFieldModel;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.model.ReferenceFieldModel;
import org.teamapps.universaldb.model.TableModel;
import org.teamapps.universaldb.pojo.template.TemplateUtil;

public class PojoTemplate {
    private String template;
    private List<String> methods = new ArrayList<String>();
    private Map<String, String> blocks = TemplateUtil.getTemplateBlocksMap();

    public static PojoTemplate createModelProviderClass() throws IOException {
        return PojoTemplate.create("ModelProvider.txt");
    }

    public static PojoTemplate createModelProviderCodeTpl() throws IOException {
        return PojoTemplate.create("ModelProviderCode.txt");
    }

    public static PojoTemplate createEntityInterface() throws IOException {
        return PojoTemplate.create("EntityInterface.txt");
    }

    public static PojoTemplate createEntityViewInterface() throws IOException {
        return PojoTemplate.create("EntityViewInterface.txt");
    }

    public static PojoTemplate createUdbEntity() throws IOException {
        return PojoTemplate.create("UdbEntity.txt");
    }

    public static PojoTemplate createUdbEntityView() throws IOException {
        return PojoTemplate.create("UdbEntityView.txt");
    }

    public static PojoTemplate createQueryInterface() throws IOException {
        return PojoTemplate.create("QueryInterface.txt");
    }

    public static PojoTemplate createUdbQuery() throws IOException {
        return PojoTemplate.create("UdbQuery.txt");
    }

    public static PojoTemplate createEnum() throws IOException {
        return PojoTemplate.create("Enum.txt");
    }

    public static PojoTemplate create(String name) throws IOException {
        String tpl = TemplateUtil.readeTemplate(name);
        return new PojoTemplate(tpl);
    }

    public PojoTemplate(String template) {
        this.template = template;
    }

    public void setValue(String name, String value) {
        this.template = TemplateUtil.setValue(this.template, name, value);
    }

    public String getTemplate() {
        return this.template;
    }

    public boolean addInterfaceGetMethod(FieldModel fieldModel, int version) {
        String tpl;
        ColumnType type = fieldModel.getFieldType().getColumnType();
        Object versionTag = "";
        if (version > 1) {
            versionTag = "_" + version;
        }
        if ((tpl = this.blocks.get("INTERFACE_GET_METHOD_" + type.name() + (String)versionTag)) == null) {
            return false;
        }
        tpl = TemplateUtil.setValue(tpl, "name", this.firstUpper(fieldModel.getName()));
        if (type == ColumnType.SINGLE_REFERENCE || type == ColumnType.MULTI_REFERENCE) {
            ReferenceFieldModel referenceFieldModel = (ReferenceFieldModel)fieldModel;
            tpl = TemplateUtil.setValue(tpl, "reference", this.firstUpper(referenceFieldModel.getReferencedTable().getName()));
        } else if (type == ColumnType.ENUM) {
            EnumFieldModel enumFieldModel = (EnumFieldModel)fieldModel;
            String enumType = this.firstUpper(enumFieldModel.getEnumModel().getName());
            tpl = TemplateUtil.setValue(tpl, "enum", enumType);
        }
        this.methods.add(tpl);
        return true;
    }

    public boolean addInterfaceSetMethod(FieldModel fieldModel, TableModel table, int version) {
        String tpl;
        ColumnType type = fieldModel.getFieldType().getColumnType();
        Object versionTag = "";
        if (version > 1) {
            versionTag = "_" + version;
        }
        if ((tpl = this.blocks.get("INTERFACE_SET_METHOD_" + type.name() + (String)versionTag)) == null) {
            return false;
        }
        tpl = TemplateUtil.setValue(tpl, "name", this.firstUpper(fieldModel.getName()));
        tpl = TemplateUtil.setValue(tpl, "type", this.firstUpper(table.getName()));
        if (type == ColumnType.SINGLE_REFERENCE || type == ColumnType.MULTI_REFERENCE) {
            ReferenceFieldModel referenceFieldModel = (ReferenceFieldModel)fieldModel;
            tpl = TemplateUtil.setValue(tpl, "reference", this.firstUpper(referenceFieldModel.getReferencedTable().getName()));
        } else if (type == ColumnType.ENUM) {
            EnumFieldModel enumFieldModel = (EnumFieldModel)fieldModel;
            String enumType = this.firstUpper(enumFieldModel.getEnumModel().getName());
            tpl = TemplateUtil.setValue(tpl, "enum", enumType);
        }
        this.methods.add(tpl);
        return true;
    }

    public boolean addUdbEntityGetMethod(FieldModel fieldModel, int version) {
        String tpl;
        ColumnType type = fieldModel.getFieldType().getColumnType();
        Object versionTag = "";
        if (version > 1) {
            versionTag = "_" + version;
        }
        if ((tpl = this.blocks.get("ENTITY_GET_METHOD_" + type.name() + (String)versionTag)) == null) {
            return false;
        }
        tpl = TemplateUtil.setValue(tpl, "name", this.firstUpper(fieldModel.getName()));
        tpl = TemplateUtil.setValue(tpl, "name2", fieldModel.getName());
        if (type == ColumnType.SINGLE_REFERENCE || type == ColumnType.MULTI_REFERENCE) {
            ReferenceFieldModel referenceFieldModel = (ReferenceFieldModel)fieldModel;
            tpl = TemplateUtil.setValue(tpl, "otherType", this.firstUpper(referenceFieldModel.getReferencedTable().getName()));
            tpl = TemplateUtil.setValue(tpl, "name2", fieldModel.getName());
        } else if (type == ColumnType.ENUM) {
            EnumFieldModel enumFieldModel = (EnumFieldModel)fieldModel;
            String enumType = this.firstUpper(enumFieldModel.getEnumModel().getName());
            tpl = TemplateUtil.setValue(tpl, "enum", enumType);
        }
        this.methods.add(tpl);
        return true;
    }

    public boolean addUdbEntitySetMethod(FieldModel fieldModel, TableModel table, int version) {
        String tpl;
        ColumnType type = fieldModel.getFieldType().getColumnType();
        Object versionTag = "";
        if (version > 1) {
            versionTag = "_" + version;
        }
        if ((tpl = this.blocks.get("ENTITY_SET_METHOD_" + type.name() + (String)versionTag)) == null) {
            return false;
        }
        tpl = TemplateUtil.setValue(tpl, "name", this.firstUpper(fieldModel.getName()));
        tpl = TemplateUtil.setValue(tpl, "name2", fieldModel.getName());
        tpl = TemplateUtil.setValue(tpl, "type", this.firstUpper(table.getName()));
        if (type == ColumnType.SINGLE_REFERENCE || type == ColumnType.MULTI_REFERENCE) {
            ReferenceFieldModel referenceFieldModel = (ReferenceFieldModel)fieldModel;
            tpl = TemplateUtil.setValue(tpl, "otherType", this.firstUpper(referenceFieldModel.getReferencedTable().getName()));
            tpl = TemplateUtil.setValue(tpl, "name2", fieldModel.getName());
        } else if (type == ColumnType.ENUM) {
            EnumFieldModel enumFieldModel = (EnumFieldModel)fieldModel;
            String enumType = this.firstUpper(enumFieldModel.getEnumModel().getName());
            tpl = TemplateUtil.setValue(tpl, "enum", enumType);
        }
        this.methods.add(tpl);
        return true;
    }

    public void addQueryInterfaceMethod(FieldModel fieldModel, String query, boolean orQuery) {
        String name;
        String string = name = orQuery ? "or" + this.firstUpper(fieldModel.getName()) : fieldModel.getName();
        if (fieldModel.getFieldType() == FieldType.ENUM) {
            EnumFieldModel enumFieldModel = (EnumFieldModel)fieldModel;
            String method = "\t" + query + " " + name + "(EnumFilterType filterType, " + this.firstUpper(enumFieldModel.getEnumModel().getName()) + " ... enums);";
            this.methods.add(method);
        } else {
            String method = "\t" + query + " " + name + "(" + this.getFilterTypeName(fieldModel.getFieldType()) + " filter);";
            this.methods.add(method);
        }
    }

    public void addSubQueryInterfaceMethod(FieldModel fieldModel, String query) {
        if (fieldModel.getFieldType().isReference()) {
            ReferenceFieldModel referenceFieldModel = (ReferenceFieldModel)fieldModel;
            String method = "\t" + query + " filter" + this.firstUpper(fieldModel.getName()) + "(" + this.firstUpper(referenceFieldModel.getReferencedTable().getName() + "Query") + " query);";
            this.methods.add(method);
            if (fieldModel.getFieldType() == FieldType.MULTI_REFERENCE) {
                this.methods.add("\t" + query + " " + fieldModel.getName() + "(MultiReferenceFilterType type, " + this.firstUpper(referenceFieldModel.getReferencedTable().getName()) + " ... value);");
                this.methods.add("\t" + query + " " + fieldModel.getName() + "Count(MultiReferenceFilterType type, int count);");
            }
        }
    }

    public void addUdbSubQueryMethod(FieldModel fieldModel, String query, String type) {
        String backReference;
        if (!fieldModel.getFieldType().isReference()) {
            return;
        }
        ReferenceFieldModel referenceFieldModel = (ReferenceFieldModel)fieldModel;
        String tpl = this.blocks.get("QUERY_SUB_QUERY");
        TableModel referencedTable = referenceFieldModel.getReferencedTable();
        String string = backReference = referenceFieldModel.getReverseReferenceField() == null ? null : referenceFieldModel.getReverseReferenceField().getName();
        if (backReference == null) {
            tpl = this.blocks.get("QUERY_SUB_QUERY_2");
        }
        String name = this.firstUpper(fieldModel.getName());
        String name2 = fieldModel.getName();
        String udbType = "Udb" + type;
        String otherType = this.firstUpper(referencedTable.getName());
        tpl = TemplateUtil.setValue(tpl, "name", name);
        tpl = TemplateUtil.setValue(tpl, "query", query);
        tpl = TemplateUtil.setValue(tpl, "otherQuery", this.firstUpper(referencedTable.getName()) + "Query");
        tpl = TemplateUtil.setValue(tpl, "udbOtherQuery", "Udb" + otherType + "Query");
        tpl = TemplateUtil.setValue(tpl, "otherUdbType", "Udb" + this.firstUpper(referencedTable.getName()));
        if (backReference != null) {
            tpl = TemplateUtil.setValue(tpl, "otherName2", backReference);
        }
        tpl = TemplateUtil.setValue(tpl, "name2", name2);
        tpl = TemplateUtil.setValue(tpl, "type", type);
        tpl = TemplateUtil.setValue(tpl, "udbType", udbType);
        this.methods.add(tpl);
        if (fieldModel.getFieldType() == FieldType.MULTI_REFERENCE) {
            tpl = this.blocks.get("QUERY_MULTI_REFERENCE");
            tpl = TemplateUtil.setValue(tpl, "otherType", otherType);
            tpl = TemplateUtil.setValue(tpl, "name", name);
            tpl = TemplateUtil.setValue(tpl, "name2", name2);
            tpl = TemplateUtil.setValue(tpl, "query", query);
            tpl = TemplateUtil.setValue(tpl, "udbType", udbType);
            this.methods.add(tpl);
            tpl = this.blocks.get("QUERY_MULTI_REFERENCE_2");
            tpl = TemplateUtil.setValue(tpl, "type", type);
            tpl = TemplateUtil.setValue(tpl, "name", name);
            tpl = TemplateUtil.setValue(tpl, "name2", name2);
            tpl = TemplateUtil.setValue(tpl, "query", query);
            tpl = TemplateUtil.setValue(tpl, "udbType", udbType);
            this.methods.add(tpl);
        }
    }

    public void addUdbQueryMethod(FieldModel fieldModel, String query, String type, boolean orQuery) {
        String tpl;
        String name = fieldModel.getName();
        String string = tpl = orQuery ? this.blocks.get("QUERY_METHOD_OR") : this.blocks.get("QUERY_METHOD");
        if (fieldModel.getFieldType() == FieldType.ENUM) {
            EnumFieldModel enumFieldModel = (EnumFieldModel)fieldModel;
            tpl = orQuery ? this.blocks.get("QUERY_ENUMS_OR") : this.blocks.get("QUERY_ENUMS");
            tpl = TemplateUtil.setValue(tpl, "enumType", this.firstUpper(enumFieldModel.getEnumModel().getName()));
        }
        tpl = TemplateUtil.setValue(tpl, "query", query);
        tpl = TemplateUtil.setValue(tpl, "name", this.firstUpper(name));
        tpl = TemplateUtil.setValue(tpl, "name2", name);
        tpl = TemplateUtil.setValue(tpl, "udbType", "Udb" + type);
        tpl = TemplateUtil.setValue(tpl, "filter", this.getFilterTypeName(fieldModel.getFieldType()));
        this.methods.add(tpl);
    }

    public void addMethod(String method) {
        this.methods.add(method);
    }

    public String tabs(int count) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(count));
        return sb.toString();
    }

    public String nl() {
        return "\n";
    }

    public String firstUpper(String s) {
        return TemplateUtil.firstUpperCase(s);
    }

    public String createConstantName(String s) {
        if (PojoTemplate.isConstant(s)) {
            return s;
        }
        return s.replaceAll("(.)(\\p{Upper})", "$1_$2").toUpperCase();
    }

    private static boolean isConstant(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_' || Character.isUpperCase(c) || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public String getIndexTypeName(FieldType type) {
        IndexType indexType = type.getIndexType();
        return switch (indexType) {
            case IndexType.BOOLEAN -> BooleanIndex.class.getSimpleName();
            case IndexType.SHORT -> ShortIndex.class.getSimpleName();
            case IndexType.INT -> IntegerIndex.class.getSimpleName();
            case IndexType.LONG -> LongIndex.class.getSimpleName();
            case IndexType.FLOAT -> FloatIndex.class.getSimpleName();
            case IndexType.DOUBLE -> DoubleIndex.class.getSimpleName();
            case IndexType.TEXT -> TextIndex.class.getSimpleName();
            case IndexType.TRANSLATABLE_TEXT -> TranslatableTextIndex.class.getSimpleName();
            case IndexType.REFERENCE -> SingleReferenceIndex.class.getSimpleName();
            case IndexType.MULTI_REFERENCE -> MultiReferenceIndex.class.getSimpleName();
            case IndexType.FILE -> FileIndex.class.getSimpleName();
            case IndexType.BINARY -> BinaryIndex.class.getSimpleName();
            default -> null;
        };
    }

    public String getFilterTypeName(FieldType type) {
        switch (type) {
            case BOOLEAN: {
                return BooleanFilter.class.getSimpleName();
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return NumericFilter.class.getSimpleName();
            }
            case TEXT: {
                return TextFilter.class.getSimpleName();
            }
            case TRANSLATABLE_TEXT: {
                return TranslatableTextFilter.class.getSimpleName();
            }
            case FILE: {
                return FileFilter.class.getSimpleName();
            }
            case BINARY: {
                return BinaryFilter.class.getSimpleName();
            }
            case SINGLE_REFERENCE: {
                return NumericFilter.class.getSimpleName();
            }
            case MULTI_REFERENCE: {
                return MultiReferenceFilter.class.getSimpleName();
            }
            case TIMESTAMP: {
                return NumericFilter.class.getSimpleName();
            }
            case DATE: {
                return NumericFilter.class.getSimpleName();
            }
            case TIME: {
                return NumericFilter.class.getSimpleName();
            }
            case DATE_TIME: {
                return NumericFilter.class.getSimpleName();
            }
            case LOCAL_DATE: {
                return NumericFilter.class.getSimpleName();
            }
            case ENUM: {
                return NumericFilter.class.getSimpleName();
            }
            case CURRENCY: {
                break;
            }
        }
        return null;
    }

    public void writeTemplate(String name, File dir) throws IOException {
        String templateText = this.writeTemplateCode();
        File file = new File(dir, TemplateUtil.firstUpperCase(name) + ".java");
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        writer.write(templateText);
        writer.close();
    }

    public String writeTemplateCode() {
        if (!this.methods.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String method : this.methods) {
                sb.append(method).append("\n\n");
            }
            this.setValue("methods", sb.toString());
            this.methods.clear();
        }
        return this.template;
    }
}

