/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Set;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedStoreUtil {
    public static ByteOrder BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private static Logger logger = LoggerFactory.getLogger(MappedStoreUtil.class);
    private static Set<String> bufferPathSet = new HashSet<String>();

    public static AtomicBuffer createAtomicBuffer(File file, int bufferSize) {
        MappedByteBuffer mappedByteBuffer = MappedStoreUtil.createBuffer(file, bufferSize);
        return new UnsafeBuffer((ByteBuffer)mappedByteBuffer);
    }

    public static MappedByteBuffer createBuffer(File file, int bufferSize) {
        try {
            String path = file.getPath();
            if (bufferPathSet.contains(path)) {
                System.err.println("ERROR: trying to create a second buffer for the same path!:" + path);
                throw new RuntimeException("ERROR: trying to create a second buffer for the same path!:" + path);
            }
            bufferPathSet.add(path);
            file.getParentFile().mkdir();
            RandomAccessFile ras = new RandomAccessFile(file, "rw");
            if (!file.exists()) {
                ras.seek(bufferSize - 10);
                ras.write(new byte[10]);
            }
            MappedByteBuffer buffer = ras.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, bufferSize);
            try {
                ras.close();
            }
            catch (Throwable t) {
                logger.warn("Error releasing RAS file on buffer creation:" + t.getMessage() + ", file:" + String.valueOf(file));
            }
            return buffer;
        }
        catch (IOException e) {
            logger.error("Error creating buffer:" + e.getMessage() + ", file:" + String.valueOf(file));
            throw new RuntimeException(e);
        }
    }

    public static void deleteBufferAndData(File file, MappedByteBuffer buffer) {
        try {
            buffer.force();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            MappedStoreUtil.releaseBufferUnsafe(buffer);
            file.delete();
            bufferPathSet.remove(file.getPath());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void deleteBufferAndData(File file, AtomicBuffer atomicBuffer) {
        MappedByteBuffer buffer = (MappedByteBuffer)atomicBuffer.byteBuffer();
        MappedStoreUtil.deleteBufferAndData(file, buffer);
    }

    public static void releaseBufferUnsafe(MappedByteBuffer buffer) {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object unsafe = unsafeField.get(null);
            Method invokeCleaner = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
            invokeCleaner.invoke(unsafe, buffer);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

