/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.chain;

import java.util.HashMap;
import java.util.Map;

public enum BlockChainType {
    ENTRIES_4(4),
    ENTRIES_8(8),
    ENTRIES_16(16),
    ENTRIES_32(32),
    ENTRIES_64(64),
    ENTRIES_128(128),
    ENTRIES_256(256),
    ENTRIES_512(512),
    ENTRIES_1024(1024),
    ENTRIES_2048(2048),
    ENTRIES_4096_CHAIN(4096);

    private static Map<Integer, BlockChainType> blockTypeByLength;
    private final int items;
    private final int length;

    private BlockChainType(int items) {
        this.items = items;
        this.length = items * 4 + this.getDataOffset() - 4;
    }

    public int getItems() {
        return this.items;
    }

    public int getBlockLength() {
        return this.length;
    }

    public int getDataOffset() {
        return this.isChain() ? 28 : 8;
    }

    public boolean isChain() {
        return this.items == 4096;
    }

    public BlockChainType getNext() {
        switch (this.ordinal()) {
            case 0: {
                return ENTRIES_8;
            }
            case 1: {
                return ENTRIES_16;
            }
            case 2: {
                return ENTRIES_32;
            }
            case 3: {
                return ENTRIES_64;
            }
            case 4: {
                return ENTRIES_128;
            }
            case 5: {
                return ENTRIES_256;
            }
            case 6: {
                return ENTRIES_512;
            }
            case 7: {
                return ENTRIES_1024;
            }
            case 8: {
                return ENTRIES_2048;
            }
            case 9: {
                return ENTRIES_4096_CHAIN;
            }
        }
        return null;
    }

    public static BlockChainType getTypeBySize(int size) {
        if (size <= 4) {
            return ENTRIES_4;
        }
        if (size <= 8) {
            return ENTRIES_8;
        }
        if (size <= 16) {
            return ENTRIES_16;
        }
        if (size <= 32) {
            return ENTRIES_32;
        }
        if (size <= 64) {
            return ENTRIES_64;
        }
        if (size <= 128) {
            return ENTRIES_128;
        }
        if (size <= 256) {
            return ENTRIES_256;
        }
        if (size <= 512) {
            return ENTRIES_512;
        }
        if (size <= 1024) {
            return ENTRIES_1024;
        }
        if (size <= 2048) {
            return ENTRIES_2048;
        }
        return ENTRIES_4096_CHAIN;
    }

    public static BlockChainType getTypeByLength(int length) {
        return blockTypeByLength.get(length);
    }

    static {
        blockTypeByLength = new HashMap<Integer, BlockChainType>();
        for (BlockChainType value : BlockChainType.values()) {
            blockTypeByLength.put(value.getBlockLength(), value);
        }
    }
}

