/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file.value;

import com.github.pemistahl.lingua.api.IsoCode639_1;
import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.api.LanguageDetector;
import com.github.pemistahl.lingua.api.LanguageDetectorBuilder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.WriteLimitReachedException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.teamapps.udb.model.FileContentData;
import org.xml.sax.ContentHandler;

public class FileContentParser {
    public static TikaConfig TIKA_CONFIG;
    private static final LanguageDetector languageDetector;
    private final File file;
    private final String fileName;
    private Metadata meta;
    private FileContentData data;

    public static FileContentData parseFile(File file) {
        return FileContentParser.parseFile(file, file.getName());
    }

    public static FileContentData parseFile(File file, String fileName) {
        FileContentParser fileContentParser = new FileContentParser(file, fileName);
        return fileContentParser.getFileContentData(100000);
    }

    public FileContentParser(File file, String fileName) {
        this.file = file;
        this.fileName = fileName != null ? fileName : file.getName();
        this.data = new FileContentData();
        this.data.setName(fileName);
        this.data.setFileSize(file.length());
        this.data.setHash(FileContentParser.createFileHash(file));
    }

    public String getHash() {
        return this.data.getHash();
    }

    public FileContentData getFileContentData(int maxContentLength) {
        if (this.meta == null) {
            this.parseMetaData(maxContentLength);
        }
        return this.data;
    }

    public String getContentLanguage() {
        this.getFileContentData(100000);
        if (this.data.getLanguage() == null) {
            this.detectLanguage();
        }
        return this.data.getLanguage();
    }

    private void parseMetaData(int maxContentLength) {
        try {
            Integer imageHeight;
            BodyContentHandler handler = new BodyContentHandler(maxContentLength);
            this.meta = new Metadata();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file));
            AutoDetectParser parser = new AutoDetectParser(TIKA_CONFIG);
            try {
                parser.parse((InputStream)bis, (ContentHandler)handler, this.meta, new ParseContext());
            }
            catch (WriteLimitReachedException writeLimitReachedException) {
                // empty catch block
            }
            this.data.setContent(handler.toString());
            ArrayList<String> propertyNames = new ArrayList<String>();
            ArrayList<String> propertyValues = new ArrayList<String>();
            for (String name2 : Arrays.stream(this.meta.names()).filter(name -> !name.startsWith("X-TIKA:")).sorted(String::compareTo).toList()) {
                propertyNames.add(name2);
                propertyValues.add(this.meta.get(name2));
            }
            this.data.setMetaKeysAsList(propertyNames);
            this.data.setMetaValuesAsList(propertyValues);
            this.data.setMimeType(this.properties("Content-Type").getString());
            this.data.setCreatedBy(this.properties(TikaCoreProperties.CREATOR).properties("xmpDM:artist").getString());
            this.data.setModifiedBy(this.properties(TikaCoreProperties.MODIFIER).getString());
            this.data.setDateCreated(this.properties(TikaCoreProperties.CREATED).getInstant());
            this.data.setDateModified(this.properties(TikaCoreProperties.MODIFIED).getInstant());
            Integer pages = this.properties(Office.PAGE_COUNT, Office.SLIDE_COUNT).properties("meta:page-count", "xmpTPg:NPages", "meta:slide-count").getInt();
            if (pages != null) {
                this.data.setPages(pages);
            }
            this.data.setTitle(this.properties(TikaCoreProperties.TITLE, TikaCoreProperties.SUBJECT).properties("dc:title", "xmpDM:album").getString());
            this.data.setLatitude(this.properties(TikaCoreProperties.LATITUDE).properties("geo:lat").getString());
            this.data.setLongitude(this.properties(TikaCoreProperties.LONGITUDE).properties("geo:long").getString());
            this.data.setDevice(this.properties("tiff:Model", "Exif IFD0:Model", "Exif SubIFD:Lens Model").getString());
            this.data.setSoftware(this.properties("extended-properties:Application", "pdf:docinfo:creator_tool", "pdf:producer", "pdf:docinfo:producer").getString());
            this.data.setSoftwareVersion(this.properties("extended-properties:AppVersion").getString());
            this.data.setDuration(this.properties("xmpDM:duration").getString());
            Integer imageWidth = this.properties("tiff:ImageWidth").getInt();
            if (imageWidth != null) {
                this.data.setImageWidth(imageWidth);
            }
            if ((imageHeight = this.properties("tiff:ImageLength").getInt()) != null) {
                this.data.setImageHeight(imageHeight);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void detectLanguage() {
        Language language;
        String content = this.data.getContent();
        if (content != null && content.length() > 100 && (language = languageDetector.detectLanguageOf(content)).getIsoCode639_1() != IsoCode639_1.NONE) {
            this.data.setLanguage(language.getIsoCode639_1().name().toLowerCase());
        }
    }

    private PropertyReader properties(Property ... properties) {
        return new PropertyReader(this.meta).properties(properties);
    }

    private PropertyReader properties(String ... properties) {
        return new PropertyReader(this.meta).properties(properties);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String createFileHash(File file) {
        try {
            int count;
            byte[] buffer = new byte[8192];
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            while ((count = bis.read(buffer)) > 0) {
                digest.update(buffer, 0, count);
            }
            bis.close();
            byte[] hash = digest.digest();
            return FileContentParser.bytesToHex(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        languageDetector = LanguageDetectorBuilder.fromAllLanguages().withLowAccuracyMode().build();
        try {
            String xmlConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<properties>\n   <parsers>\n       <parser class=\"org.apache.tika.parser.DefaultParser\">\n           <parser-exclude class=\"org.apache.tika.parser.external.CompositeExternalParser\"/>\n           <parser-exclude class=\"org.apache.tika.parser.executable.ExecutableParser\"/>\n           <parser-exclude class=\"org.apache.tika.parser.ocr.TesseractOCRParser\"/>\n       </parser>\n   </parsers>\n</properties>";
            TIKA_CONFIG = new TikaConfig((InputStream)new ByteArrayInputStream(xmlConfig.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class PropertyReader {
        private final Metadata meta;
        private final List<Property> properties = new ArrayList<Property>();
        private final List<String> otherProperties = new ArrayList<String>();

        public PropertyReader(Metadata meta) {
            this.meta = meta;
        }

        public PropertyReader properties(Property ... properties) {
            this.properties.addAll(Arrays.asList(properties));
            return this;
        }

        public PropertyReader properties(String ... properties) {
            this.otherProperties.addAll(Arrays.asList(properties));
            return this;
        }

        public String getString() {
            String value;
            for (Property property : this.properties) {
                value = this.meta.get(property);
                if (value == null || value.isBlank()) continue;
                return value;
            }
            for (String string : this.otherProperties) {
                value = this.meta.get(string);
                if (value == null || value.isBlank()) continue;
                return value;
            }
            return null;
        }

        public Integer getInt() {
            Object value;
            for (Property property : this.properties) {
                value = this.meta.getInt(property);
                if (value == null) continue;
                return value;
            }
            for (String string : this.otherProperties) {
                value = this.meta.get(string);
                if (value == null || ((String)value).isBlank()) continue;
                try {
                    return Integer.valueOf((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return null;
        }

        public Instant getInstant() {
            for (Property property : this.properties) {
                Date value = this.meta.getDate(property);
                if (value == null) continue;
                return value.toInstant();
            }
            return null;
        }
    }
}

