/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file.value;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.udb.model.FileContentData;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.file.value.FileValueType;

public class StoreDescriptionFile
implements FileValue {
    private final File file;
    private final String fileName;
    private final long size;
    private final String hash;
    private final String key;
    private final FileContentData contentData;

    public StoreDescriptionFile(File file, String fileName, long size, String hash, String key, FileContentData contentData) {
        this.file = file;
        this.fileName = fileName;
        this.size = size;
        this.hash = hash;
        this.key = key;
        this.contentData = contentData;
    }

    public StoreDescriptionFile(DataInputStream dis) throws IOException {
        this.file = null;
        this.fileName = MessageUtils.readString((DataInputStream)dis);
        this.hash = MessageUtils.readString((DataInputStream)dis);
        this.size = dis.readLong();
        this.key = MessageUtils.readString((DataInputStream)dis);
        boolean withContentData = dis.readBoolean();
        this.contentData = withContentData ? new FileContentData(dis) : null;
    }

    @Override
    public FileValueType getType() {
        return FileValueType.STORE_DESCRIPTION;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.file != null ? new BufferedInputStream(new FileInputStream(this.file)) : null;
    }

    @Override
    public File getAsFile() {
        try {
            if (this.file == null) {
                return null;
            }
            Path path = Files.createTempFile("tmp", "." + this.getFileExtension(), new FileAttribute[0]);
            Files.copy(this.file.toPath(), path, StandardCopyOption.REPLACE_EXISTING);
            return path.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void copyToFile(File file) throws IOException {
        Files.copy(this.file.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public FileContentData getFileContentData() {
        return this.contentData;
    }

    @Override
    public String getDetectedLanguage() {
        return this.contentData != null ? this.contentData.getLanguage() : null;
    }
}

