/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.transaction.request;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.transaction.request.TransactionRequest;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecordType;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecordValue;
import org.teamapps.universaldb.pojo.EntityChangeSet;

public class TransactionRequestRecord {
    private final TransactionRequestRecordType recordType;
    private final int tableId;
    private final int recordId;
    private final int correlationId;
    private final List<TransactionRequestRecordValue> recordValues = new ArrayList<TransactionRequestRecordValue>();
    private boolean transactionProcessingStarted;

    public static TransactionRequestRecord createOrUpdateRecord(TransactionRequest transactionRequest, TableIndex tableIndex, int recordId, int correlationId, boolean update, EntityChangeSet entityChangeSet) {
        TransactionRequestRecordType type;
        TransactionRequestRecordType transactionRequestRecordType = type = update ? TransactionRequestRecordType.UPDATE : TransactionRequestRecordType.CREATE;
        if (!update && recordId > 0) {
            type = TransactionRequestRecordType.CREATE_WITH_ID;
        }
        TransactionRequestRecord requestRecord = new TransactionRequestRecord(type, tableIndex.getMappingId(), recordId, correlationId);
        requestRecord.createMetaData(tableIndex, transactionRequest.getUserId(), transactionRequest.getTimestamp(), entityChangeSet);
        return requestRecord;
    }

    public static TransactionRequestRecord createDeleteRecord(TransactionRequest transactionRequest, TableIndex tableIndex, int recordId, EntityChangeSet entityChangeSet) {
        TransactionRequestRecord requestRecord = new TransactionRequestRecord(TransactionRequestRecordType.DELETE, tableIndex.getMappingId(), recordId, 0);
        requestRecord.createMetaData(tableIndex, transactionRequest.getUserId(), transactionRequest.getTimestamp(), entityChangeSet);
        if (recordId <= 0) {
            throw new RuntimeException("Cannot delete record with id:" + recordId);
        }
        return requestRecord;
    }

    public static TransactionRequestRecord createRestoreRecord(TransactionRequest transactionRequest, TableIndex tableIndex, int recordId, EntityChangeSet entityChangeSet) {
        TransactionRequestRecord requestRecord = new TransactionRequestRecord(TransactionRequestRecordType.RESTORE, tableIndex.getMappingId(), recordId, 0);
        requestRecord.createMetaData(tableIndex, transactionRequest.getUserId(), transactionRequest.getTimestamp(), entityChangeSet);
        if (recordId <= 0) {
            throw new RuntimeException("Cannot restore record with id:" + recordId);
        }
        return requestRecord;
    }

    public TransactionRequestRecord(TransactionRequestRecordType recordType, int tableId, int recordId, int correlationId) {
        this.recordType = recordType;
        this.tableId = tableId;
        this.recordId = recordId;
        this.correlationId = correlationId;
    }

    public TransactionRequestRecord(DataInputStream dis) throws IOException {
        this.recordType = TransactionRequestRecordType.getById(dis.readByte());
        this.tableId = dis.readInt();
        this.recordId = dis.readInt();
        this.correlationId = dis.readInt();
        int count = dis.readInt();
        for (int i = 0; i < count; ++i) {
            this.recordValues.add(new TransactionRequestRecordValue(dis));
        }
    }

    public void createMetaData(TableIndex tableIndex, int userId, long timestamp, EntityChangeSet entityChangeSet) {
        int changeDate = (int)(timestamp / 1000L);
        switch (this.recordType) {
            case CREATE: 
            case CREATE_WITH_ID: {
                FieldIndex modifiedByIndex;
                FieldIndex modificationDateIndex;
                FieldIndex createByIndex;
                if (!tableIndex.getTableModel().isTrackModifications()) break;
                FieldIndex createDateIndex = tableIndex.getFieldIndex("metaCreationDate");
                if (!entityChangeSet.isChanged(createDateIndex)) {
                    this.addRecordValue(createDateIndex, changeDate);
                }
                if (!entityChangeSet.isChanged(createByIndex = tableIndex.getFieldIndex("metaCreatedBy"))) {
                    this.addRecordValue(createByIndex, userId);
                }
                if (!entityChangeSet.isChanged(modificationDateIndex = tableIndex.getFieldIndex("metaModificationDate"))) {
                    this.addRecordValue(modificationDateIndex, changeDate);
                }
                if (entityChangeSet.isChanged(modifiedByIndex = tableIndex.getFieldIndex("metaModifiedBy"))) break;
                this.addRecordValue(modifiedByIndex, userId);
                break;
            }
            case UPDATE: {
                FieldIndex modifiedByIndex;
                if (!tableIndex.getTableModel().isTrackModifications()) break;
                FieldIndex modificationDateIndex = tableIndex.getFieldIndex("metaModificationDate");
                if (!entityChangeSet.isChanged(modificationDateIndex)) {
                    this.addRecordValue(modificationDateIndex, changeDate);
                }
                if (entityChangeSet.isChanged(modifiedByIndex = tableIndex.getFieldIndex("metaModifiedBy"))) break;
                this.addRecordValue(modifiedByIndex, userId);
                break;
            }
            case DELETE: {
                if (!tableIndex.getTableModel().isRecoverableRecords()) break;
                FieldIndex deletionDateIndex = tableIndex.getFieldIndex("metaDeletionDate");
                if (entityChangeSet == null || !entityChangeSet.isChanged(deletionDateIndex)) {
                    this.addRecordValue(deletionDateIndex, changeDate);
                }
                FieldIndex deletedByIndex = tableIndex.getFieldIndex("metaDeletedBy");
                if (entityChangeSet != null && entityChangeSet.isChanged(deletedByIndex)) break;
                this.addRecordValue(deletedByIndex, userId);
                break;
            }
            case RESTORE: {
                if (!tableIndex.getTableModel().isRecoverableRecords()) break;
                FieldIndex restoreDateIndex = tableIndex.getFieldIndex("metaRestoreDate");
                if (entityChangeSet == null || !entityChangeSet.isChanged(restoreDateIndex)) {
                    this.addRecordValue(restoreDateIndex, changeDate);
                }
                FieldIndex restoredByIndex = tableIndex.getFieldIndex("metaRestoredBy");
                if (entityChangeSet != null && entityChangeSet.isChanged(restoredByIndex)) break;
                this.addRecordValue(restoredByIndex, userId);
            }
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeByte(this.recordType.getId());
        dos.writeInt(this.tableId);
        dos.writeInt(this.recordId);
        dos.writeInt(this.correlationId);
        dos.writeInt(this.recordValues.size());
        for (TransactionRequestRecordValue recordValue : this.recordValues) {
            recordValue.write(dos);
        }
    }

    public int getTableId() {
        return this.tableId;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public int getCorrelationId() {
        return this.correlationId;
    }

    public void addRecordValue(FieldIndex fieldIndex, Object value) {
        this.addRecordValue(new TransactionRequestRecordValue(fieldIndex.getMappingId(), fieldIndex.getType(), value));
    }

    public void addRecordValue(TransactionRequestRecordValue recordValue) {
        this.recordValues.add(recordValue);
    }

    public TransactionRequestRecordType getRecordType() {
        return this.recordType;
    }

    public List<TransactionRequestRecordValue> getRecordValues() {
        return this.recordValues;
    }

    public boolean isTransactionProcessingStarted() {
        return this.transactionProcessingStarted;
    }

    public void setTransactionProcessingStarted(boolean transactionProcessingStarted) {
        this.transactionProcessingStarted = transactionProcessingStarted;
    }
}

