/*
 * Decompiled with CFR 0.152.
 */
package TeamControlium.Controlium.ElementControls;

import TeamControlium.Controlium.ControlBase;
import TeamControlium.Controlium.ObjectMapping;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;

public class Select
extends ControlBase {
    private boolean delectAllOnSetting = false;

    public Select(ObjectMapping mapping) {
        this.setMapping(mapping);
    }

    public Select(ObjectMapping mapping, boolean startAllDeselected) {
        this.setMapping(mapping);
        this.delectAllOnSetting = startAllDeselected;
    }

    @Override
    protected void controlBeingSet(boolean isFirstSetting) {
        if (this.delectAllOnSetting) {
            new org.openqa.selenium.support.ui.Select((WebElement)this.getRootElement().getUnderlyingWebElement()).deselectAll();
        }
    }

    public void selectItemByText(String text) {
        new org.openqa.selenium.support.ui.Select((WebElement)this.getRootElement().getUnderlyingWebElement()).selectByVisibleText(text);
    }

    public void selectItemByValueAttribute(String text) {
        new org.openqa.selenium.support.ui.Select((WebElement)this.getRootElement().getUnderlyingWebElement()).selectByValue(text);
    }

    public void selectItemByIndex(int index) {
        org.openqa.selenium.support.ui.Select selectElement = new org.openqa.selenium.support.ui.Select((WebElement)this.getRootElement().getUnderlyingWebElement());
        List allOptions = selectElement.getOptions();
        if (allOptions.size() < index + 1) {
            throw new RuntimeException(String.format("Select element [%s] only has [%d] options but we wanted to select option [%d] (Zero based)", this.getMapping().getFriendlyName(), allOptions.size()));
        }
        selectElement.selectByIndex(index);
    }

    public String getSelectedItemText() {
        List elements = new org.openqa.selenium.support.ui.Select((WebElement)this.getRootElement().getUnderlyingWebElement()).getAllSelectedOptions();
        if (elements.size() == 0) {
            throw new RuntimeException(String.format("Select element [%] has no selected items", this.getMapping().getFriendlyName()));
        }
        if (elements.size() > 1) {
            throw new RuntimeException(String.format("Select element [%] has [%d] selected items.  Expected 1", elements.size(), this.getMapping().getFriendlyName()));
        }
        return ((WebElement)elements.get(0)).getText();
    }

    public int getSelectedItemTextsCount() {
        List elements = new org.openqa.selenium.support.ui.Select((WebElement)this.getRootElement().getUnderlyingWebElement()).getAllSelectedOptions();
        if (elements.size() == 0) {
            throw new RuntimeException(String.format("Select element [%] has no selected items", this.getMapping().getFriendlyName()));
        }
        return elements.size();
    }

    public List<String> getAllSelectedItemTexts() {
        List elements = new org.openqa.selenium.support.ui.Select((WebElement)this.getRootElement().getUnderlyingWebElement()).getAllSelectedOptions();
        if (elements.size() == 0) {
            throw new RuntimeException(String.format("Select element [%] has no selected items", this.getMapping().getFriendlyName()));
        }
        List<String> texts = elements.stream().map(element -> element.getText()).collect(Collectors.toList());
        return texts;
    }
}

