/*
 * Decompiled with CFR 0.152.
 */
package TeamControlium.Controlium;

import TeamControlium.Utilities.Logger;
import TeamControlium.Utilities.TestData;

public class Browsers {
    private static final String[] ConfigBrowser = new String[]{"Selenium", "Browser"};
    private static BrowserType _TestBrowser;
    private static boolean _IsChrome;
    private static boolean _IsInternetExplorer;
    private static boolean _isEdge;
    private static boolean _isSafari;
    private static boolean testBrowserHasBeenSet;

    public static BrowserType getBrowserType() {
        return _TestBrowser;
    }

    public static boolean isChrome() {
        return _IsChrome;
    }

    public static boolean isInternetExplorer() {
        return _IsInternetExplorer;
    }

    public static boolean isEdge() {
        return _isEdge;
    }

    public static boolean isSafari() {
        return _isSafari;
    }

    public static void SetTestBrowser() {
        Browsers.SetTestBrowser(null);
    }

    public static void SetTestBrowser(String browser) {
        block47: {
            _IsChrome = false;
            _IsInternetExplorer = false;
            _isSafari = false;
            _isEdge = false;
            try {
                String browserFromTestData = (String)TestData.getItem(String.class, (String)ConfigBrowser[0], (String)ConfigBrowser[1]);
                if (!browserFromTestData.isEmpty()) {
                    if (browser != null && !browser.isEmpty()) {
                        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)String.format("Browser set in Test Data.  Overriding passed device with [%s] (Test data [%s.%s])", browserFromTestData, ConfigBrowser[0], ConfigBrowser[1]), (Object[])new Object[0]);
                    }
                    browser = browserFromTestData;
                }
            }
            catch (Exception e) {
                if (browser != null && !browser.isEmpty()) break block47;
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)String.format("Cannot get Browser type setting from test data: [%s],[%s]. Defaulting to Chrome", ConfigBrowser[0], ConfigBrowser[1], e.getMessage()), (Object[])new Object[0]);
                browser = "Chrome";
            }
        }
        if (browser == null || browser.isEmpty()) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)String.format("Browser not defined and empty Browser type in test data: [%s],[%s].", ConfigBrowser[0], ConfigBrowser[1]), (Object[])new Object[0]);
            throw new RuntimeException(String.format("Browser not defined and empty Browser type in test data: [%s],[%s].", ConfigBrowser[0], ConfigBrowser[1]));
        }
        switch (browser.toLowerCase().replace(" ", "").replace("(", "").replace(")", "")) {
            case "chrome66": {
                _TestBrowser = BrowserType.Chrome66;
                _IsChrome = true;
                break;
            }
            case "chrome67": {
                _TestBrowser = BrowserType.Chrome67;
                _IsChrome = true;
                break;
            }
            case "chrome68": {
                _TestBrowser = BrowserType.Chrome68;
                _IsChrome = true;
                break;
            }
            case "chrome69": {
                _TestBrowser = BrowserType.Chrome69;
                _IsChrome = true;
                break;
            }
            case "chrome": 
            case "chrome70": {
                _TestBrowser = BrowserType.Chrome70;
                _IsChrome = true;
                break;
            }
            case "ie8": 
            case "internetexplorer8": {
                _TestBrowser = BrowserType.IE8;
                _IsInternetExplorer = true;
                break;
            }
            case "ie9": 
            case "internetexplorer9": {
                _TestBrowser = BrowserType.IE9;
                _IsInternetExplorer = true;
                break;
            }
            case "ie10": 
            case "internetexplorer10": {
                _TestBrowser = BrowserType.IE10;
                _IsInternetExplorer = true;
                break;
            }
            case "ie11": 
            case "internetexplorer11": 
            case "ie": 
            case "internetexplorer": {
                _TestBrowser = BrowserType.IE11;
                _IsInternetExplorer = true;
                break;
            }
            case "edge": {
                _TestBrowser = BrowserType.Edge;
                _isEdge = true;
                break;
            }
            case "safari4": {
                _TestBrowser = BrowserType.Safari4;
                _isSafari = true;
                break;
            }
            case "safari5": 
            case "safari": {
                _TestBrowser = BrowserType.Safari5;
                _isSafari = true;
                break;
            }
            case "safari9": {
                _TestBrowser = BrowserType.Safari9;
                _isSafari = true;
                break;
            }
            case "safari10": {
                _TestBrowser = BrowserType.Safari10;
                _isSafari = true;
                break;
            }
            case "safari11": {
                _TestBrowser = BrowserType.Safari11;
                _isSafari = true;
                break;
            }
            default: {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)String.format("Unsupported Browser: [%s]", browser), (Object[])new Object[0]);
                throw new RuntimeException(String.format("Unsupported Browser: [%s]", browser));
            }
        }
        testBrowserHasBeenSet = true;
    }

    static {
        testBrowserHasBeenSet = false;
    }

    public static enum BrowserType {
        NoneSelected,
        Chrome66,
        Chrome67,
        Chrome68,
        Chrome69,
        Chrome70,
        IE8,
        IE9,
        IE10,
        IE11,
        Edge,
        Safari4,
        Safari5,
        Safari9,
        Safari10,
        Safari11;

    }
}

