/*
 * Decompiled with CFR 0.152.
 */
package TeamControlium.Controlium;

import TeamControlium.Controlium.HTMLElement;
import TeamControlium.Controlium.ObjectMapping;
import TeamControlium.Controlium.SeleniumDriver;
import TeamControlium.Utilities.Logger;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;

public abstract class ControlBase {
    protected ObjectMapping _Mapping;
    protected HTMLElement _RootElement;
    private SeleniumDriver _SeleniumDriver;
    private ControlBase _parentControl;

    public ObjectMapping getMapping() {
        return this._Mapping;
    }

    protected ObjectMapping setMapping(ObjectMapping mapping) {
        this._Mapping = mapping;
        return this._Mapping;
    }

    public HTMLElement getRootElement() {
        if (this._RootElement == null) {
            throw new RuntimeException(String.format("Control [%s] root element NULL.  Has control been located on the page (IE. SetControl(...)?", this.getMapping().getFriendlyName()));
        }
        return this._RootElement;
    }

    protected HTMLElement setRootElement(HTMLElement element) {
        this._RootElement = element;
        this.setMapping(element.getMappingDetails());
        return this._RootElement;
    }

    protected HTMLElement setRootElement(ObjectMapping mapping) {
        this.setRootElement(new HTMLElement(mapping));
        return this._RootElement;
    }

    public SeleniumDriver getSeleniumDriver() {
        return this._SeleniumDriver;
    }

    public SeleniumDriver setSeleniumDriver(SeleniumDriver seleniumDriver) {
        this._SeleniumDriver = seleniumDriver;
        return this._SeleniumDriver;
    }

    public ControlBase getParentControl() {
        return this._parentControl;
    }

    public ControlBase setParentControl(ControlBase parentControl) {
        this._parentControl = parentControl;
        return this._parentControl;
    }

    public static void clearCache() {
        throw new RuntimeException("No caching implemented yet!");
    }

    public <T extends ControlBase> T setControl(T newControl) {
        return ControlBase.setControl(this, newControl);
    }

    public static <T extends ControlBase> T setControl(ControlBase parentControl, T newControl) {
        return ControlBase.setControl(parentControl.getSeleniumDriver(), parentControl, newControl);
    }

    public static <T extends ControlBase> T setControl(SeleniumDriver seleniumDriver, T newControl) {
        return ControlBase.setControl(seleniumDriver, null, newControl);
    }

    public static <T extends ControlBase> T setControl(SeleniumDriver seleniumDriver, ControlBase parentControl, T newControl) {
        if (newControl == null) {
            throw new RuntimeException("newControl Null!");
        }
        StopWatch timeWaited = StopWatch.createStarted();
        try {
            Object[] objectArray = new Object[4];
            Object object = objectArray[0] = newControl.getMapping() == null ? "No mapping logic!" : newControl.getMapping().getFriendlyName();
            objectArray[1] = parentControl == null ? "No parent Control - So Top Level control" : (parentControl.getMapping() == null ? "No mapping logic!" : parentControl.getMapping().getFriendlyName());
            Object object2 = objectArray[2] = seleniumDriver == null ? "null" : Integer.toString(seleniumDriver.hashCode());
            objectArray[3] = seleniumDriver == null ? "N/A" : (seleniumDriver.getWebDriver() == null ? "Null!" : Integer.toString(seleniumDriver.getWebDriver().hashCode()));
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Setting on Control [%s] from Parent [%s] with SeleniumDriver hash [%s] (WebDriver hash [%s])", (Object[])objectArray);
            if (parentControl != null && parentControl.isStale()) {
                ControlBase refreshedParentControl;
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Parent control is stale. Refreshing", (Object[])new Object[0]);
                parentControl.setRootElement((HTMLElement)null);
                parentControl = refreshedParentControl = ControlBase.setControl(parentControl.getSeleniumDriver(), parentControl.getParentControl(), parentControl);
            }
            if (newControl._RootElement == null || !newControl.getRootElement().isBoundToAWebElement()) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"New control root element is null or unbound to a Selenium element.  So finding element", (Object[])new Object[0]);
                HTMLElement element = parentControl == null ? seleniumDriver.findElement(newControl.getMapping()) : parentControl.getRootElement().findElement(newControl.getMapping());
                newControl.setRootElement(element);
            }
            newControl.setSeleniumDriver(seleniumDriver);
            newControl.setParentControl(parentControl);
            newControl.controlBeingSet(true);
            return newControl;
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Error setting on control: %s", (Object[])new Object[]{e.getMessage()});
            throw new RuntimeException(String.format("Error setting on control: %s", e.getMessage()));
        }
    }

    public static <T extends ControlBase> boolean controlExists(ControlBase parentControl, T control) {
        return parentControl.elementExists(control.getMapping());
    }

    public static <T extends ControlBase> boolean controlExists(SeleniumDriver seleniumDriver, T control) {
        return seleniumDriver.findElementOrNull(control.getMapping()) != null;
    }

    public static <T extends ControlBase> boolean controlExists(SeleniumDriver seleniumDriver, ControlBase parentControl, T control) {
        return seleniumDriver.findElement(parentControl.getMapping()).findElementOrNull(control.getMapping()) != null;
    }

    public <T extends ControlBase> boolean controlExists(T control) {
        return this.elementExists(control.getMapping());
    }

    protected abstract void controlBeingSet(boolean var1);

    public boolean isStale() {
        try {
            this.getRootElement().isElementEnabled();
            return false;
        }
        catch (Exception ex) {
            Logger.LogException((Exception)ex);
            return true;
        }
    }

    public boolean elementExists(ObjectMapping mapping) {
        return this.getRootElement().findElementOrNull(mapping) != null;
    }

    public void clearElement(ObjectMapping mapping) {
        this.findElement(mapping).clear();
    }

    public void clearElement() {
        this.getRootElement().clear();
    }

    public void click() {
        this.getRootElement().click();
    }

    public void click(ObjectMapping mapping) {
        this.findElement(mapping).click();
    }

    public void clickIfExists(ObjectMapping mapping) {
        HTMLElement element = this.getRootElement().findElementOrNull(mapping);
        if (element == null) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"[%s] didnt find any match.  No click.", (Object[])new Object[]{mapping == null ? "Null mapping!" : mapping.getFriendlyName()});
        } else {
            element.click();
        }
    }

    public String getAttribute(ObjectMapping mapping, String attributeName) {
        HTMLElement element = this.findElement(mapping);
        try {
            return element.getAttribute(attributeName);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getAttribute(String attributeName) {
        try {
            return this.getRootElement().getAttribute(attributeName);
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean hasAttribute(ObjectMapping mapping, String attributeName) {
        HTMLElement element = this.findElement(mapping);
        try {
            return element.hasAttribute(attributeName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasAttribute(String attributeName) {
        try {
            return this.getRootElement().hasAttribute(attributeName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getCssValue(ObjectMapping mapping, String valueName) {
        HTMLElement element = this.findElement(mapping);
        try {
            return element.getCssValue(valueName);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getCssValue(String valueName) {
        try {
            return this.getRootElement().getCssValue(valueName);
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean hasCssValue(ObjectMapping mapping, String valueName) {
        HTMLElement element = this.findElement(mapping);
        try {
            return element.hasCssValue(valueName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasCssValue(String valueName) {
        try {
            return this.getRootElement().hasCssValue(valueName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getText(ObjectMapping mapping) {
        HTMLElement element = this.findElement(mapping);
        try {
            return element.getText();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getText() {
        try {
            return this.getRootElement().getText();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setText(ObjectMapping mapping, String text) {
        HTMLElement element = this.findElement(mapping);
        element.setText(text);
    }

    public void setText(String text) {
        this.getRootElement().setText(text);
    }

    public HTMLElement findElement(ObjectMapping mapping) {
        if (this.getRootElement() == null) {
            throw new RuntimeException(String.format("Control [%s] root element is null.  Has the Control been Set (SetControl) yet?", this.getMapping() == null ? "Unknown" : (this.getMapping().getFriendlyName() == null ? "Unknown" : this.getMapping().getFriendlyName())));
        }
        return this.getRootElement().findElement(mapping);
    }

    public List<HTMLElement> findAllElements(ObjectMapping mapping) {
        if (this.getRootElement() == null) {
            throw new RuntimeException(String.format("Control [%s] root element is null.  Has the Control been Set (SetControl) yet?", this.getMapping() == null ? "Unknown" : (this.getMapping().getFriendlyName() == null ? "Unknown" : this.getMapping().getFriendlyName())));
        }
        return this.getRootElement().findAllElements(mapping);
    }
}

