/*
 * Decompiled with CFR 0.152.
 */
package TeamControlium.Controlium;

import TeamControlium.Controlium.Exception.InvalidElementState;
import TeamControlium.Controlium.ObjectMapping;
import TeamControlium.Controlium.SeleniumDriver;
import TeamControlium.Controlium.Size;
import TeamControlium.Utilities.Logger;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;

public class HTMLElement {
    private ObjectMapping _mappingDetails;
    private Object _webElement;
    private Object _parentElementOrDriver;
    private long elementDefaultChangeDeltaTimemS = 200L;

    public HTMLElement() {
    }

    public HTMLElement(Object parent, Object underlyingWebElement, ObjectMapping mapping) {
        this.setParentOfThisElement(parent);
        this.setUnderlyingWebElement(underlyingWebElement, mapping);
    }

    public HTMLElement(ObjectMapping mapping) {
        this.setParentOfThisElement(null);
        this.setMappingDetails(mapping);
        this.setUnderlyingWebElement(null);
    }

    public String getFriendlyName() {
        ObjectMapping objectMapping = this.getMappingDetails();
        if (objectMapping == null) {
            return "No mapping details for element!";
        }
        return objectMapping.getFriendlyName();
    }

    public Object getUnderlyingWebElement() {
        return this._webElement;
    }

    public Object setUnderlyingWebElement(Object webElement) {
        return this.setUnderlyingWebElement(webElement, null);
    }

    public Object setUnderlyingWebElement(Object webElement, ObjectMapping mapping) {
        this._webElement = webElement;
        this._mappingDetails = mapping == null ? new ObjectMapping(null, String.format("Wired directly to underlying UI driver WebElement [%s]", webElement.getClass().getName())) : mapping;
        return this._webElement;
    }

    public ObjectMapping getMappingDetails() {
        return this._mappingDetails;
    }

    public ObjectMapping setMappingDetails(ObjectMapping mappingDetails) {
        if (mappingDetails != null && this._webElement != null) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Trying to set Mapping Details after Element ([%s]) has already been bound (found by Selenium).  So cannot change mapping details.", (Object[])new Object[]{this.getFriendlyName()});
            throw new RuntimeException("Cannot set mapping logic after element has been bound.  See log!");
        }
        this._mappingDetails = mappingDetails;
        return this._mappingDetails;
    }

    public SeleniumDriver getSeleniumDriver() {
        if (this.getParentOfThisElement() == null) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Trying to get parent Element of [%s]. However, element has no Parent (it has not yet be found!)", (Object[])new Object[]{this.getFriendlyName()});
            throw new RuntimeException("Cannot get an instance of the Selenium Driver as this element (or a Parent of) does not have a Parent!");
        }
        if (this.getParentOfThisElement().getClass() == SeleniumDriver.class) {
            return (SeleniumDriver)this.getParentOfThisElement();
        }
        return ((HTMLElement)this.getParentOfThisElement()).getSeleniumDriver();
    }

    public Object getParentOfThisElement() {
        return this._parentElementOrDriver;
    }

    public Object setParentOfThisElement(Object parentOfThisElement) {
        if (parentOfThisElement == null) {
            this._parentElementOrDriver = null;
        } else {
            if (parentOfThisElement.getClass() != SeleniumDriver.class && parentOfThisElement.getClass() != HTMLElement.class) {
                throw new RuntimeException(String.format("An element can only have another Element or the SeleniumDriver as a parent. Type [%s] is invalid!", parentOfThisElement.getClass().getName()));
            }
            this._parentElementOrDriver = parentOfThisElement;
        }
        return this.getParentOfThisElement();
    }

    public boolean hasAParent() {
        return this._parentElementOrDriver != null;
    }

    public boolean hasMappingDetails() {
        return this.getMappingDetails() != null && this.getMappingDetails().getOriginalFindLogic() != null;
    }

    public boolean isBoundToAWebElement() {
        return this._webElement != null;
    }

    public boolean isVisible() {
        return this.isVisible(false);
    }

    public boolean isVisible(boolean checkIfElementIsInViewport) {
        this.throwIfUnbound();
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Verifying if element is visible", (Object[])new Object[0]);
        boolean seleniumStatesElementDisplayed = this.getSeleniumDriver().isDisplayed(this._webElement);
        if (checkIfElementIsInViewport && seleniumStatesElementDisplayed) {
            boolean elementWithinViewport = false;
            String sResult = null;
            try {
                sResult = this.getSeleniumDriver().executeJavaScript(String.class, "var rect = arguments[0].getBoundingClientRect(); return ( rect.top >= 0 && rect.left >= 0 && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth));", this._webElement);
                return sResult.trim().toLowerCase() == "true";
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Exception executing Javascript to find status of element [%s]", this.getFriendlyName()));
            }
        }
        return checkIfElementIsInViewport;
    }

    public boolean isHeightStable(Duration deltaTime) {
        return !this.isAttributeChanging("offsetHeight", deltaTime);
    }

    public boolean isHeightStable() {
        return this.isHeightStable(Duration.ofMillis(this.elementDefaultChangeDeltaTimemS));
    }

    public boolean isWidthStable(Duration deltaTime) {
        return !this.isAttributeChanging("offsetWidth", deltaTime);
    }

    public boolean isWidthStable() {
        return this.isWidthStable(Duration.ofMillis(this.elementDefaultChangeDeltaTimemS));
    }

    public boolean isSizeStable(Duration deltaTime) {
        return !this.isAttributeChanging(new String[]{"offsetWidth", "offsetHeight"}, deltaTime);
    }

    public boolean isSizeStable() {
        return this.isSizeStable(Duration.ofMillis(this.elementDefaultChangeDeltaTimemS));
    }

    public boolean isPositionStable(Duration timeDelta) {
        String jsGetPositionalData = "var rect = arguments[0].getBoundingClientRect(); return '' + rect.left + ',' + rect.top + ',' + rect.right + ',' + rect.bottom";
        try {
            String first = this.getSeleniumDriver().executeJavaScript(String.class, jsGetPositionalData, this._webElement);
            try {
                Thread.sleep(timeDelta.toMillis());
            }
            catch (Exception e) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Exception sleeping during change monitoring of attribute.", (Object[])new Object[0]);
                throw new RuntimeException(String.format("Exception sleeping during time stop-start delta", e));
            }
            String second = this.getSeleniumDriver().executeJavaScript(String.class, jsGetPositionalData, this._webElement);
            boolean isChanging = first.equals(second);
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Element [%s], Time Delta [%dmS], First State [%s], Second State [%s] - %s", (Object[])new Object[]{this.getFriendlyName(), timeDelta.toMillis(), first, second, isChanging ? "Is changing" : "Is not changing"});
            return first.equals(second);
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Exception monitoring position of element [%s]: %s", (Object[])new Object[]{this.getFriendlyName(), e.toString()});
            throw new RuntimeException(String.format("Exception monitoring element attribute. See log.", e));
        }
    }

    public boolean isPositionStable() {
        return this.isPositionStable(Duration.ofMillis(this.elementDefaultChangeDeltaTimemS));
    }

    public boolean isElementEnabled() {
        boolean elementEnabled = false;
        if (this._webElement != null) {
            elementEnabled = this.getSeleniumDriver().isEnabled(this._webElement);
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)String.format("Element [%s] enabled = [%s]", this.getFriendlyName(), elementEnabled ? "true" : "false"), (Object[])new Object[0]);
            return elementEnabled;
        }
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Element enabled = [Web or element is NULL, returning false]", (Object[])new Object[0]);
        return false;
    }

    public Size getSize() {
        int widthInt;
        int heightInt;
        String height = this.getSeleniumDriver().executeJavaScript(String.class, "return arguments[0].clientHeight", this._webElement);
        String width = this.getSeleniumDriver().executeJavaScript(String.class, "return arguments[0].clientWidth", this._webElement);
        try {
            heightInt = Integer.parseInt(height);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error parsing height [%s] from Javascript execution for element [%s]", height, this.getFriendlyName()));
        }
        try {
            widthInt = Integer.parseInt(width);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error parsing height [%s] from Javascript execution for element [%s]", width, this.getFriendlyName()));
        }
        Size size = new Size(heightInt, widthInt);
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Element [%s], Height [%d], Width [%s]", (Object[])new Object[]{this.getFriendlyName(), size.getHeight(), size.getWidth()});
        return size;
    }

    private boolean isAttributeChanging(String attributeName, Duration timeDelta) {
        try {
            String first = this.getSeleniumDriver().executeJavaScript(String.class, String.format("return argumaents[0].%s;", attributeName), this._webElement);
            try {
                Thread.sleep(timeDelta.toMillis());
            }
            catch (Exception e) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Exception sleeping during change monitoring of attribute.", (Object[])new Object[0]);
                throw new RuntimeException(String.format("Exception sleeping during time stop-start delta", e));
            }
            String second = this.getSeleniumDriver().executeJavaScript(String.class, String.format("return arguments[0].%s;", attributeName), this._webElement);
            boolean isChanging = first.equals(second);
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Element [%s], Attribute [%s], Time Delta [%dmS], First State [%s], Second State [%s] - %s", (Object[])new Object[]{this.getFriendlyName(), attributeName, timeDelta.toMillis(), first, second, isChanging ? "Is changing" : "Is not changing"});
            return first.equals(second);
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Exception monitoring attribute [%s] of element [%s]: %s", (Object[])new Object[]{attributeName, this.getFriendlyName(), e.toString()});
            throw new RuntimeException(String.format("Exception monitoring element attribute. See log.", e));
        }
    }

    private boolean isAttributeChanging(String[] attributeNames, Duration timeDelta) {
        HashMap<String, String> attributeFirstStates = new HashMap<String, String>();
        for (String attributeName : attributeNames) {
            attributeFirstStates.put(attributeName, this.getSeleniumDriver().executeJavaScript(String.class, String.format("return arguments[0].%s;", attributeName), this._webElement));
        }
        try {
            Thread.sleep(timeDelta.toMillis());
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Exception sleeping during change monitoring of attribute.", (Object[])new Object[0]);
            throw new RuntimeException(String.format("Exception sleeping during time stop-start delta", e));
        }
        for (Map.Entry entry : attributeFirstStates.entrySet()) {
            String second = this.getSeleniumDriver().executeJavaScript(String.class, String.format("return argumaents[0].%s;", entry.getKey()), this._webElement);
            boolean isChanging = ((String)entry.getValue()).equals(second);
            if (!isChanging) continue;
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Element [%s], Attribute [%s], Time Delta [%dmS], First State [%s], Second State [%s] - Is changing", (Object[])new Object[]{this.getFriendlyName(), entry.getKey(), timeDelta.toMillis(), entry.getValue(), second});
            return true;
        }
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Element [%s], Attributes [%s], Time Delta [%dmS].  All first states equal second states.  Element NOT changing", (Object[])new Object[]{this.getFriendlyName(), String.join((CharSequence)", ", attributeNames), timeDelta.toMillis()});
        return false;
    }

    public List<HTMLElement> findAllElements(ObjectMapping mapping) {
        this.throwIfUnbound();
        return this.getSeleniumDriver().findElements(this, mapping);
    }

    public HTMLElement findElement(ObjectMapping mapping) {
        this.throwIfUnbound();
        return this.getSeleniumDriver().findElement(this, mapping);
    }

    public HTMLElement findElement(ObjectMapping mapping, boolean allowMultipleMatches) {
        this.throwIfUnbound();
        return this.getSeleniumDriver().findElement(this, mapping, allowMultipleMatches);
    }

    public HTMLElement findElement(ObjectMapping mapping, boolean waitUntilSingle, boolean waitUntilStable) {
        this.throwIfUnbound();
        return this.getSeleniumDriver().findElement(this, mapping, waitUntilSingle, waitUntilStable);
    }

    public HTMLElement findElementOrNull(ObjectMapping mapping) {
        this.throwIfUnbound();
        return this.getSeleniumDriver().findElementOrNull(this, mapping);
    }

    public HTMLElement findElementOrNull(ObjectMapping mapping, boolean allowMultipleMatches) {
        this.throwIfUnbound();
        return this.getSeleniumDriver().findElementOrNull(this, mapping, allowMultipleMatches);
    }

    public HTMLElement findElementOrNull(ObjectMapping mapping, boolean waitUntilSingle, boolean waitUntilStable) {
        this.throwIfUnbound();
        return this.getSeleniumDriver().findElementOrNull(this, mapping, waitUntilSingle, waitUntilStable);
    }

    public Exception getLastFindException() {
        return this.getSeleniumDriver().getLastException();
    }

    public boolean waitForHeightStable(Duration timeout) {
        return this.waitForElementStable(StabilityType.HEIGHT, timeout);
    }

    public boolean waitForWidthStable(Duration timeout) {
        return this.waitForElementStable(StabilityType.WIDTH, timeout);
    }

    public boolean waitForSizeStable(Duration timeout) {
        return this.waitForElementStable(StabilityType.SIZE, timeout);
    }

    public boolean waitForPositionStable(Duration timeout) {
        return this.waitForElementStable(StabilityType.POSITION, timeout);
    }

    public HTMLElement findElementAndBind() {
        HTMLElement foundElement;
        if (this.hasAParent()) {
            throw new RuntimeException(String.format("[%s]: Cannot find an element without having a parent (either SeleniumDriver or another Element)!", this.getFriendlyName()));
        }
        if (this.hasMappingDetails()) {
            throw new RuntimeException(String.format("[%s]: Cannot find a WebElement, mapping details (find logic) are unknown!", this.getFriendlyName()));
        }
        try {
            foundElement = this.getParentOfThisElement().getClass() == SeleniumDriver.class ? ((SeleniumDriver)this.getParentOfThisElement()).findElement(this.getMappingDetails()) : ((HTMLElement)this.getParentOfThisElement()).findElement(this.getMappingDetails());
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to bind element [%s] as child of [%s] (Find Logic [%s])", this.getMappingDetails().getFriendlyName(), this.getParentOfThisElement().getClass() == SeleniumDriver.class ? "Driver - IE. a Root element" : ((HTMLElement)this.getParentOfThisElement()).getMappingDetails().getFriendlyName(), this.getMappingDetails().getOriginalFindLogic()), ex);
        }
        this.setUnderlyingWebElement(foundElement.getUnderlyingWebElement());
        return this;
    }

    public void clear() {
        this.throwIfUnbound();
        try {
            this.getSeleniumDriver().clear(this.getUnderlyingWebElement());
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Error thrown clearing text in [%s]: %s", (Object[])new Object[]{this.getFriendlyName(), e.getMessage()});
            throw new RuntimeException(String.format("Error thrown clearing text in [%s] ([%s]).", this.getFriendlyName(), this.getMappingDetails().getActualFindLogic()), e);
        }
    }

    public void setText(String text) {
        this.setText(text, 1, null);
    }

    public void setText(String text, int maxTries) {
        this.setText(text, maxTries, null);
    }

    public void setText(String text, Duration retryInterval) {
        this.setText(text, 1, retryInterval);
    }

    public void setText(String text, int maxTries, Duration retryInterval) {
        Exception lastException = null;
        this.throwIfUnbound();
        if (maxTries < 1) {
            throw new RuntimeException(String.format("Maximum tries [%d].  Cannot be less than 1.", maxTries));
        }
        int tryIndex = 0;
        Duration interval = retryInterval == null ? Duration.ofMillis(200L) : retryInterval;
        try {
            while (tryIndex++ <= maxTries) {
                try {
                    Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Calling Selenium driver clear with WebElement. Driver %s, Element %s", (Object[])new Object[]{this.getSeleniumDriver() == null ? "Null" : "Good", this.getUnderlyingWebElement() == null ? "Null!" : "Good"});
                    this.getSeleniumDriver().clear(this.getUnderlyingWebElement());
                    this.enterText(text);
                    if (tryIndex > 1) {
                        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"{0} attempt attempt good.)", (Object[])new Object[]{tryIndex});
                    }
                    return;
                }
                catch (InvalidElementState e) {
                    Thread.sleep(retryInterval.toMillis());
                    lastException = e;
                }
                catch (Exception e) {
                    Thread.sleep(retryInterval.toMillis());
                    lastException = e;
                }
            }
            throw lastException;
        }
        catch (InvalidElementState ex) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Error thrown setting text (clear then enter) in [%s] (Tried %d times): %s", (Object[])new Object[]{this.getFriendlyName(), tryIndex, ex});
            throw new InvalidElementState(String.format("Error thrown setting text (clear then enter) in [%s] ([%s]).  Tried %d times).", this.getFriendlyName(), this.getMappingDetails().getActualFindLogic(), tryIndex), ex);
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Error thrown setting text (clear then enter) in [%s] (Tried %d times): %s", (Object[])new Object[]{this.getFriendlyName(), tryIndex, e.getMessage()});
            throw new RuntimeException(String.format("Error thrown setting text (clear then enter) in [%s] ([%s]).  Tried %d times).", this.getFriendlyName(), this.getMappingDetails().getActualFindLogic(), tryIndex), e);
        }
    }

    public void enterText(String text) {
        this.enterText(text, 1, null);
    }

    public void enterText(String text, int maxTries) {
        this.enterText(text, maxTries, null);
    }

    public void enterText(String text, Duration retryInterval) {
        this.enterText(text, 1, retryInterval);
    }

    public void enterText(String text, int maxTries, Duration retryInterval) {
        InvalidElementState lastException = null;
        this.throwIfUnbound();
        if (maxTries < 1) {
            throw new RuntimeException(String.format("Maximum tries [%d].  Cannot be less than 1.", maxTries));
        }
        int tryIndex = 0;
        Duration interval = retryInterval == null ? Duration.ofMillis(200L) : retryInterval;
        try {
            while (tryIndex++ <= maxTries) {
                try {
                    Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Calling Selenium driver setText with WebElement. Driver %s, Element %s, text = [%s]", (Object[])new Object[]{this.getSeleniumDriver() == null ? "Null" : "Good", this.getUnderlyingWebElement() == null ? "Null!" : "Good", text == null ? "<null!>" : text});
                    this.getSeleniumDriver().setText(this.getUnderlyingWebElement(), text == null ? "" : text);
                    if (tryIndex > 1) {
                        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"{0} attempt attempt good.)", (Object[])new Object[]{tryIndex});
                    }
                    return;
                }
                catch (InvalidElementState e) {
                    Thread.sleep(retryInterval.toMillis());
                    lastException = e;
                }
            }
            throw lastException;
        }
        catch (InvalidElementState ex) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Error thrown entering text in [%s] (Tried %d times): %s", (Object[])new Object[]{this.getFriendlyName(), tryIndex, ex.getMessage()});
            throw new InvalidElementState(String.format("Error thrown entering text in [%s] ([%s]).  Tried %d times).", this.getFriendlyName(), this.getMappingDetails().getActualFindLogic(), tryIndex), ex);
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Error thrown entering text in [%s] (Tried %d times): %s", (Object[])new Object[]{this.getFriendlyName(), tryIndex, e.getMessage()});
            throw new RuntimeException(String.format("Error thrown entering text in [%s] ([%s]).  Tried %d times).", this.getFriendlyName(), this.getMappingDetails().getActualFindLogic(), tryIndex), e);
        }
    }

    public String getText() {
        this.throwIfUnbound();
        return this.getText(true);
    }

    public String getText(boolean includeDesendants) {
        this.throwIfUnbound();
        try {
            return this.getSeleniumDriver().getText(this.getUnderlyingWebElement(), includeDesendants, false, false);
        }
        catch (InvalidElementState ex) {
            throw ex;
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Error thrown getting text from [%s]: %s", (Object[])new Object[]{this.getFriendlyName(), e.getMessage()});
            throw new RuntimeException(String.format("Error thrown getting text from [%s] ([%s])", this.getFriendlyName(), this.getMappingDetails().getActualFindLogic()), e);
        }
    }

    public String scrollIntoViewAndGetText() {
        this.throwIfUnbound();
        return this.scrollIntoViewAndGetText(true);
    }

    public String scrollIntoViewAndGetText(boolean includeDesendants) {
        this.throwIfUnbound();
        try {
            return this.getSeleniumDriver().getText(this.getUnderlyingWebElement(), includeDesendants, true, false);
        }
        catch (InvalidElementState ex) {
            throw ex;
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Error thrown scrolling into view and getting text from [%s]: %s", (Object[])new Object[]{this.getFriendlyName(), e.getMessage()});
            throw new RuntimeException(String.format("Error thrown scrolling into view and getting text from [%s] ([%s])", this.getFriendlyName(), this.getMappingDetails().getActualFindLogic()), e);
        }
    }

    public String getAttribute(String attribute) {
        this.throwIfUnbound();
        try {
            return this.getSeleniumDriver().getAttribute(this.getUnderlyingWebElement(), attribute);
        }
        catch (InvalidElementState ex) {
            throw ex;
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Error thrown getting attribute [%s] from [%s]: %s", (Object[])new Object[]{attribute, this.getFriendlyName(), e.getMessage()});
            throw new RuntimeException(String.format("Error thrown getting attribute [%s] from [%s] ([%s])", attribute == null ? "Null" : attribute, this.getFriendlyName(), this.getMappingDetails().getActualFindLogic()), e);
        }
    }

    public boolean hasAttribute(String attribute) {
        this.throwIfUnbound();
        try {
            return this.getSeleniumDriver().hasAttribute(this.getUnderlyingWebElement(), attribute);
        }
        catch (InvalidElementState ex) {
            throw ex;
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Error thrown getting attribute [%s] from [%s]. Assume does not have attribute: %s", (Object[])new Object[]{attribute, this.getFriendlyName(), e.getMessage()});
            return false;
        }
    }

    public String getCssValue(String valueName) {
        this.throwIfUnbound();
        try {
            return this.getSeleniumDriver().getCssValue(this.getUnderlyingWebElement(), valueName);
        }
        catch (InvalidElementState ex) {
            throw ex;
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Error thrown getting CSS value [%s] from [%s]: %s", (Object[])new Object[]{valueName, this.getFriendlyName(), e.getMessage()});
            throw new RuntimeException(String.format("Error thrown getting CSS value [%s] from [%s] ([%s])", valueName == null ? "Null" : valueName, this.getFriendlyName(), this.getMappingDetails().getActualFindLogic()), e);
        }
    }

    public boolean hasCssValue(String valueName) {
        this.throwIfUnbound();
        try {
            return this.getSeleniumDriver().hasCssValue(this.getUnderlyingWebElement(), valueName);
        }
        catch (InvalidElementState ex) {
            throw ex;
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Error thrown getting CSS value [%s] from [%s]. Assume does not have CSS value: %s", (Object[])new Object[]{valueName, this.getFriendlyName(), e.getMessage()});
            return false;
        }
    }

    public void click() {
        this.throwIfUnbound();
        try {
            this.getSeleniumDriver().click(this.getUnderlyingWebElement());
        }
        catch (InvalidElementState ex) {
            throw ex;
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Error thrown clicking [%s]: %s", (Object[])new Object[]{this.getFriendlyName(), e.getMessage()});
            throw new RuntimeException(String.format("Error thrown clicking [%s] ([%s])", this.getFriendlyName(), this.getMappingDetails().getActualFindLogic()), e);
        }
    }

    private boolean waitForElementStable(StabilityType stabilityType) {
        return this.waitForElementStable(stabilityType, null);
    }

    private boolean waitForElementStable(StabilityType stabilityType, Duration timeout) {
        this.throwIfUnbound();
        boolean didStabilzeBeforeTimeout = false;
        int iterations = 0;
        Duration actualTimeout = timeout == null ? this.getSeleniumDriver().getElementFindTimeout() : timeout;
        long actualTimeoutMillis = actualTimeout.toMillis();
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Wait %dms for element [%s] to become [%s] stable", (Object[])new Object[]{actualTimeoutMillis, this.getFriendlyName(), stabilityType.toString()});
        StopWatch timeWaited = StopWatch.createStarted();
        while (timeWaited.getTime(TimeUnit.MILLISECONDS) < actualTimeoutMillis) {
            try {
                ++iterations;
                boolean isStable = false;
                switch (stabilityType) {
                    case HEIGHT: {
                        isStable = this.isHeightStable(timeout);
                        break;
                    }
                    case WIDTH: {
                        isStable = this.isWidthStable(timeout);
                        break;
                    }
                    case POSITION: {
                        isStable = this.isPositionStable(timeout);
                        break;
                    }
                    case SIZE: {
                        isStable = this.isSizeStable(timeout);
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.format("Stability type [%s] unknown!", stabilityType.toString()));
                    }
                }
                if (!isStable) continue;
                didStabilzeBeforeTimeout = true;
                break;
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Cannot determine if element [%s] is height-stable.", this.getFriendlyName()), ex);
            }
        }
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Element %s %s stable after %dms (%d iterations)", (Object[])new Object[]{this.getFriendlyName(), didStabilzeBeforeTimeout ? "is" : "NOT", timeWaited.getTime(TimeUnit.MILLISECONDS), iterations});
        return didStabilzeBeforeTimeout;
    }

    private void throwIfUnbound() {
        if (!this.hasAParent()) {
            throw new RuntimeException("Cannot identify Selenium Driver as no parent set (SeleniumDriver or Element)!");
        }
        if (!this.isBoundToAWebElement()) {
            throw new RuntimeException("Not bound to a Selenium Web Element");
        }
    }

    public static boolean isVisible(HTMLElement element) {
        return HTMLElement.isVisible(element, false);
    }

    public static boolean isVisible(HTMLElement element, boolean CheckIfElementIsInViewport) {
        return element.isVisible(CheckIfElementIsInViewport);
    }

    private static enum StabilityType {
        HEIGHT("Height"),
        WIDTH("Width"),
        SIZE("Size"),
        POSITION("Position");

        private String asString;

        private StabilityType(String stringRepresentation) {
            this.asString = stringRepresentation;
        }

        public String toString() {
            return this.asString;
        }
    }
}

