/*
 * Decompiled with CFR 0.152.
 */
package TeamControlium.Controlium;

import TeamControlium.Utilities.Logger;
import java.util.Map;
import org.openqa.selenium.By;

public class ObjectMapping {
    private ByType _mappingType;
    private String _findLogicOriginal;
    private String _findLogicActual;
    private String _friendlyName;
    private String _friendlyNameOriginal;
    private By _seleniumBy;

    public ObjectMapping(String findLogic) {
        this.InitObjectMap(findLogic, null);
    }

    public ObjectMapping(String findLogic, String friendlyName) {
        this.InitObjectMap(findLogic, friendlyName);
    }

    private void InitObjectMap(String findLogic, String friendlyName) {
        this._findLogicOriginal = findLogic;
        this._friendlyName = this._friendlyNameOriginal = friendlyName == null ? findLogic : friendlyName;
    }

    public ByType getMappingType() {
        if (this._mappingType == null) {
            this.processFindLogic(this._findLogicActual == null ? this._findLogicOriginal : this._findLogicActual);
        }
        return this._mappingType;
    }

    public String getOriginalFindLogic() {
        return this._findLogicOriginal;
    }

    public String setOriginalFindLogic(String findLogic) {
        if (this._findLogicActual != null) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"[%s]: Cannot change Find Logic ([%s]) after Actual Find Logic used! ", (Object[])new Object[]{this.getFriendlyName(), this._findLogicActual});
            throw new RuntimeException(String.format("[%s]: Cannot change Find Logic ([%s]) after Actual Find Logic used! ", this.getFriendlyName(), this._findLogicActual));
        }
        this._findLogicOriginal = findLogic;
        return this.getOriginalFindLogic();
    }

    public String getActualFindLogic() {
        if (this._findLogicActual == null) {
            this._findLogicActual = this._findLogicOriginal;
        }
        return this._findLogicActual;
    }

    public String setActualFindLogic(String findLogic) {
        if (this._findLogicActual != null) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"[%s]: Cannot change Actual Find Logic ([%s]) after Actual Find Logic used! ", (Object[])new Object[]{this.getFriendlyName(), this._findLogicActual});
            throw new RuntimeException(String.format("[%s]: Cannot change Actual Find Logic ([%s]) after Actual Find Logic used! ", this.getFriendlyName(), this._findLogicActual));
        }
        this._findLogicActual = findLogic;
        return this.getActualFindLogic();
    }

    public By getSeleniumBy() {
        return this.processFindLogic(this.getActualFindLogic());
    }

    public String getFriendlyName() {
        return this._friendlyName == null ? (this._findLogicOriginal == null ? (this._findLogicActual == null ? "No name or find logic!" : this._findLogicActual) : this._findLogicOriginal) : this._friendlyName;
    }

    public ObjectMapping copy() {
        try {
            ObjectMapping clone = new ObjectMapping(this._findLogicActual, this._friendlyName);
            return clone;
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Exception cloning current Object Map (%s): %s", (Object[])new Object[]{this.getFriendlyName(), e});
            return null;
        }
    }

    public ObjectMapping resolveParameters(String ... params) {
        String newFindLogic = null;
        String newFriendlyName = null;
        try {
            if (this._findLogicOriginal == null) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Cannot resolve parameters, find logic is null!", (Object[])new Object[0]);
                throw new RuntimeException("Cannot resolve parameters, find logic is null! See log.");
            }
            newFindLogic = String.format(this._findLogicOriginal, params);
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Error resolving find logic parameters!", (Object[])new Object[0]);
            throw new RuntimeException("Error resolving find logic parameters! See log.");
        }
        try {
            if (this._friendlyNameOriginal != null) {
                newFriendlyName = String.format(this._friendlyNameOriginal, params);
            }
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Error resolving friendly name parameters!", (Object[])new Object[0]);
            newFriendlyName = newFindLogic;
        }
        this._findLogicActual = newFindLogic;
        this._friendlyName = newFriendlyName;
        return this;
    }

    private By processFindLogic(String property) {
        By returnValue;
        KeyValue<String, String> findLogicNameValue;
        if (property == null) {
            return null;
        }
        if (property.contains("=")) {
            String[] nameValue = property.split("=", 2);
            findLogicNameValue = new KeyValue<String, String>(nameValue[0], nameValue[1]);
        } else {
            findLogicNameValue = new KeyValue<String, String>("xpath", property);
        }
        switch (findLogicNameValue.getKey()) {
            case "id": {
                returnValue = By.id((String)findLogicNameValue.getValue());
                this._mappingType = ByType.Id;
                break;
            }
            case "class": {
                returnValue = By.className((String)findLogicNameValue.getValue());
                this._mappingType = ByType.Class;
                break;
            }
            case "css": {
                returnValue = By.cssSelector((String)findLogicNameValue.getValue());
                this._mappingType = ByType.Css;
                break;
            }
            case "linktext": {
                returnValue = By.linkText((String)findLogicNameValue.getValue());
                this._mappingType = ByType.LinkText;
                break;
            }
            case "name": {
                returnValue = By.name((String)findLogicNameValue.getValue());
                this._mappingType = ByType.Name;
                break;
            }
            case "partial": {
                returnValue = By.partialLinkText((String)findLogicNameValue.getValue());
                this._mappingType = ByType.Partial;
                break;
            }
            case "tag": {
                returnValue = By.tagName((String)findLogicNameValue.getValue());
                this._mappingType = ByType.Tag;
                break;
            }
            case "xpath": {
                returnValue = By.xpath((String)findLogicNameValue.getValue());
                this._mappingType = ByType.XPath;
                break;
            }
            default: {
                returnValue = By.xpath((String)property);
                this._mappingType = ByType.XPath;
            }
        }
        return returnValue;
    }

    public class KeyValue<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public KeyValue(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public K setKey(K key) {
            this.key = key;
            return this.key;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return this.value;
        }
    }

    public static enum ByType {
        Id,
        Class,
        Css,
        LinkText,
        Name,
        Partial,
        Tag,
        XPath,
        Unknown;

    }
}

