/*
 * Decompiled with CFR 0.152.
 */
package TeamControlium.Controlium;

import TeamControlium.Controlium.Browsers;
import TeamControlium.Controlium.Devices;
import TeamControlium.Controlium.Exception.InvalidElementState;
import TeamControlium.Controlium.HTMLElement;
import TeamControlium.Controlium.ObjectMapping;
import TeamControlium.Utilities.Detokenizer;
import TeamControlium.Utilities.General;
import TeamControlium.Utilities.Logger;
import TeamControlium.Utilities.TestData;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.ConnectException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.internal.WrapsDriver;
import org.w3c.dom.NodeList;

public class SeleniumDriver {
    private final String[] SeleniumServerFolder = new String[]{"Selenium", "SeleniumServerFolder"};
    private final String[] ConfigTimeout = new String[]{"Selenium", "ElementFindTimeout"};
    private final String[] ConfigPollingInterval = new String[]{"Selenium", "PollInterval"};
    private final String[] ConfigPageLoadTimeout = new String[]{"Selenium", "PageLoadTimeout"};
    private final String[] ConfigDevice = new String[]{"Selenium", "Device"};
    private final String[] ConfigHost = new String[]{"Selenium", "Host"};
    private final String[] ConfigHostURI = new String[]{"Selenium", "HostURI"};
    private final String[] ConfigConnectionTimeout = new String[]{"Selenium", "ConnectionTimeout"};
    private final String[] SeleniumDebugMode = new String[]{"Selenium", "DebugMode"};
    private final String[] SeleniumLogFilename = new String[]{"Selenium", "LogFile"};
    private WebDriver webDriver;
    private Exception _lastException = null;
    private Duration _findTimeout = null;
    private Duration _pollInterval = null;
    private Duration _pageLoadTimeout = null;
    private static final long defaultTimeout = 60000L;
    private static final long defaultPollInterval = 500L;
    private Browsers _browser = null;
    private Devices _device = null;
    private String seleniumHost;
    private boolean isLocalSelenium = true;
    private String seleniumServerFolder = null;
    private boolean seleniumDebugMode = false;
    private String seleniumLogFilename = null;

    public SeleniumDriver(String seleniumHost, String device, String browser) {
        this.commonConstructs(false, seleniumHost, device, browser);
    }

    public SeleniumDriver(String seleniumHost) {
        this.commonConstructs(false, seleniumHost, null, null);
    }

    public SeleniumDriver(String device, String browser) {
        this.commonConstructs(false, null, device, browser);
    }

    public SeleniumDriver() {
        this.commonConstructs(false, null, null, null);
    }

    public SeleniumDriver(boolean killDriverInstancesFirst, String seleniumHost, String device, String browser) {
        this.commonConstructs(killDriverInstancesFirst, seleniumHost, device, browser);
    }

    public SeleniumDriver(boolean killDriverInstancesFirst, String seleniumHost) {
        this.commonConstructs(killDriverInstancesFirst, seleniumHost, null, null);
    }

    public SeleniumDriver(boolean killDriverInstancesFirst, String device, String browser) {
        this.commonConstructs(killDriverInstancesFirst, null, device, browser);
    }

    public SeleniumDriver(boolean killDriverInstancesFirst) {
        this.commonConstructs(killDriverInstancesFirst, null, null, null);
    }

    private void commonConstructs(boolean killFirst, String seleniumHost, String device, String browser) {
        this.setFindTimeout(Duration.ofMillis(60000L));
        this.setPollInterval(Duration.ofMillis(500L));
        this.setPageLoadTimeout(Duration.ofMillis(60000L));
        try {
            this.seleniumServerFolder = (String)TestData.getItem(String.class, (String)this.SeleniumServerFolder[0], (String)this.SeleniumServerFolder[1]);
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Selenium Server Folder not set in TestData (%s.%s).  Defaulting to local", (Object[])new Object[]{this.SeleniumServerFolder[0], this.SeleniumServerFolder[1]});
            this.seleniumServerFolder = System.getProperty("user.dir");
        }
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Selenium Server Folder [%s]", (Object[])new Object[]{this.seleniumServerFolder});
        try {
            this.seleniumDebugMode = General.IsValueTrue((String)((String)TestData.getItem(String.class, (String)this.SeleniumDebugMode[0], (String)this.SeleniumDebugMode[1])));
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Selenium Server debug mode not set in TestData (%s.%s).  Defaulting to off", (Object[])new Object[]{this.SeleniumDebugMode[0], this.SeleniumDebugMode[1]});
            this.seleniumDebugMode = false;
        }
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Selenium Debug Mode: [%s]", (Object[])new Object[]{this.seleniumDebugMode ? "on" : "off"});
        try {
            this.seleniumLogFilename = (String)TestData.getItem(String.class, (String)this.SeleniumLogFilename[0], (String)this.SeleniumLogFilename[1]);
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Selenium Log filename not set in TestData (%s.%s).  Defaulting to stdio (console)", (Object[])new Object[]{this.SeleniumLogFilename[0], this.SeleniumLogFilename[1]});
            this.seleniumLogFilename = null;
        }
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Selenium Log filename: [%s]", (Object[])new Object[]{this.seleniumLogFilename == null ? "stdio (console)" : this.seleniumLogFilename});
        Browsers.SetTestBrowser(browser);
        Devices.SetTestDevice(device);
        this.setSeleniumHost(seleniumHost);
        this.startOrConnectToSeleniumServer(killFirst);
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Started SeleniumDriver. Hash code [%d].  WebDriver hash code [%s]", (Object[])new Object[]{this.hashCode(), this.getWebDriver() == null ? "null!" : Integer.toString(this.getWebDriver().hashCode())});
    }

    public Exception getLastException() {
        return this._lastException;
    }

    public Duration setFindTimeout(Duration findTimeout) {
        this._findTimeout = findTimeout;
        return this.getElementFindTimeout();
    }

    public Duration getElementFindTimeout() {
        return this._findTimeout;
    }

    public Duration setPollInterval(Duration pollInterval) {
        this._pollInterval = pollInterval;
        return this.getPollInterval();
    }

    public Duration getPollInterval() {
        return this._pollInterval;
    }

    public Duration setPageLoadTimeout(Duration pageLoadTimeout) {
        if (this.webDriver != null) {
            this.webDriver.manage().timeouts().pageLoadTimeout(pageLoadTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        this._pageLoadTimeout = pageLoadTimeout;
        return this.getPageLoadTimeout();
    }

    public Duration getPageLoadTimeout() {
        return this._pageLoadTimeout;
    }

    public Browsers getBrowser() {
        return this._browser;
    }

    public Browsers setBrowser(Browsers browser) {
        this._browser = browser;
        return this.getBrowser();
    }

    public Browsers getDevice() {
        return this._browser;
    }

    public Browsers setDevice(Devices device) {
        this._device = device;
        return this.getDevice();
    }

    public Set<String> getAllBrowserWindows() {
        if (this.getWebDriver() != null) {
            return this.getWebDriver().getWindowHandles();
        }
        throw new RuntimeException("Cannot get Browser windows handles as WebDriver null!");
    }

    public void setBrowserWindow(String handle) {
        if (this.getWebDriver() == null) {
            throw new RuntimeException("Cannot set Browser window as WebDriver null!");
        }
        this.getWebDriver().switchTo().window(handle);
    }

    public void setIFrame(HTMLElement htmlElement) {
        WebElement webElement = (WebElement)htmlElement.getUnderlyingWebElement();
        String tag = webElement.getTagName();
        if (tag.equalsIgnoreCase("iframe")) {
            try {
                this.webDriver.switchTo().frame(webElement);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error setting element [%s] ([%s]) as iframe window in Selenium.", htmlElement.getMappingDetails().getOriginalFindLogic(), htmlElement.getMappingDetails().getFriendlyName()), e);
            }
        } else {
            throw new RuntimeException(String.format("Element [%s] ([%s)] is [%s].  Must be an iframe!", htmlElement.getMappingDetails().getOriginalFindLogic(), htmlElement.getMappingDetails().getFriendlyName(), tag));
        }
    }

    public HTMLElement findElement(ObjectMapping objectMapping) {
        return this.findElement(null, objectMapping, false, false, this.getElementFindTimeout(), this.getPollInterval(), false);
    }

    public HTMLElement findElement(ObjectMapping objectMapping, boolean waitUntilStable) {
        return this.findElement(null, objectMapping, false, false, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElement(ObjectMapping objectMapping, Duration timeout) {
        return this.findElement(null, objectMapping, false, false, timeout, this.getPollInterval(), false);
    }

    public HTMLElement findElement(ObjectMapping objectMapping, Duration timeout, boolean waitUntilStable) {
        return this.findElement(null, objectMapping, false, false, timeout, this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElement(ObjectMapping objectMapping, Duration timeout, Duration pollInterval) {
        return this.findElement(null, objectMapping, false, false, timeout, pollInterval, false);
    }

    public HTMLElement findElement(ObjectMapping objectMapping, Duration timeout, Duration pollInterval, boolean waitUntilStable) {
        return this.findElement(null, objectMapping, false, false, timeout, pollInterval, waitUntilStable);
    }

    public HTMLElement findElement(ObjectMapping objectMapping, boolean waitUntilSingle, boolean waitUntilStable) {
        return this.findElement(null, objectMapping, false, waitUntilSingle, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElement(ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, boolean waitUntilStable) {
        return this.findElement(null, objectMapping, allowMultipleMatches, waitUntilSingle, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElement(ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout) {
        return this.findElement(null, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, this.getPollInterval(), false);
    }

    public HTMLElement findElement(ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, boolean waitUntilStable) {
        return this.findElement(null, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElement(ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, Duration pollInterval) {
        return this.findElement(null, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, pollInterval, false);
    }

    public HTMLElement findElement(ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, Duration pollInterval, boolean waitUntilStable) {
        return this.findElement(null, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, pollInterval, waitUntilStable);
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping) {
        return this.findElement(parentElement, objectMapping, false, false, this.getElementFindTimeout(), this.getPollInterval(), false);
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping, boolean waitUntilStable) {
        return this.findElement(parentElement, objectMapping, false, false, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping, boolean waitUntilSingle, boolean waitUntilStable) {
        return this.findElement(parentElement, objectMapping, false, waitUntilSingle, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping, Duration timeout) {
        return this.findElement(parentElement, objectMapping, false, false, timeout, this.getPollInterval(), false);
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping, Duration timeout, boolean waitUntilStable) {
        return this.findElement(parentElement, objectMapping, false, false, timeout, this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping, Duration timeout, Duration pollInterval) {
        return this.findElement(parentElement, objectMapping, false, false, timeout, pollInterval, false);
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping, Duration timeout, Duration pollInterval, boolean waitUntilStable) {
        return this.findElement(parentElement, objectMapping, false, false, timeout, pollInterval, waitUntilStable);
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, boolean waitUntilStable) {
        return this.findElement(parentElement, objectMapping, allowMultipleMatches, waitUntilSingle, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout) {
        return this.findElement(parentElement, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, this.getPollInterval(), false);
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, boolean waitUntilStable) {
        return this.findElement(parentElement, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, Duration pollInterval) {
        return this.findElement(parentElement, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, pollInterval, false);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping) {
        return this.findElementOrNull(null, objectMapping, false, false, this.getElementFindTimeout(), this.getPollInterval(), false);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping, boolean waitUntilStable) {
        return this.findElementOrNull(null, objectMapping, false, false, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping, Duration timeout) {
        return this.findElementOrNull(null, objectMapping, false, false, timeout, this.getPollInterval(), false);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping, Duration timeout, boolean waitUntilStable) {
        return this.findElementOrNull(null, objectMapping, false, false, timeout, this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping, Duration timeout, Duration pollInterval) {
        return this.findElementOrNull(null, objectMapping, false, false, timeout, pollInterval, false);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping, Duration timeout, Duration pollInterval, boolean waitUntilStable) {
        return this.findElementOrNull(null, objectMapping, false, false, timeout, pollInterval, waitUntilStable);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping, boolean waitUntilSingle, boolean waitUntilStable) {
        return this.findElementOrNull(null, objectMapping, false, waitUntilSingle, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, boolean waitUntilStable) {
        return this.findElementOrNull(null, objectMapping, allowMultipleMatches, waitUntilSingle, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout) {
        return this.findElementOrNull(null, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, this.getPollInterval(), false);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, boolean waitUntilStable) {
        return this.findElementOrNull(null, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, Duration pollInterval) {
        return this.findElementOrNull(null, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, pollInterval, false);
    }

    public HTMLElement findElementOrNull(ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, Duration pollInterval, boolean waitUntilStable) {
        return this.findElementOrNull(null, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, pollInterval, waitUntilStable);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping) {
        return this.findElementOrNull(parentElement, objectMapping, false, false, this.getElementFindTimeout(), this.getPollInterval(), false);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping, boolean waitUntilStable) {
        return this.findElementOrNull(parentElement, objectMapping, false, false, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping, boolean waitUntilSingle, boolean waitUntilStable) {
        return this.findElementOrNull(parentElement, objectMapping, false, waitUntilSingle, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping, Duration timeout) {
        return this.findElementOrNull(parentElement, objectMapping, false, false, timeout, this.getPollInterval(), false);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping, Duration timeout, boolean waitUntilStable) {
        return this.findElementOrNull(parentElement, objectMapping, false, false, timeout, this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping, Duration timeout, Duration pollInterval) {
        return this.findElementOrNull(parentElement, objectMapping, false, false, timeout, pollInterval, false);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping, Duration timeout, Duration pollInterval, boolean waitUntilStable) {
        return this.findElementOrNull(parentElement, objectMapping, false, false, timeout, pollInterval, waitUntilStable);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, boolean waitUntilStable) {
        return this.findElementOrNull(parentElement, objectMapping, allowMultipleMatches, waitUntilSingle, this.getElementFindTimeout(), this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout) {
        return this.findElementOrNull(parentElement, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, this.getPollInterval(), false);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, boolean waitUntilStable) {
        return this.findElementOrNull(parentElement, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, this.getPollInterval(), waitUntilStable);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, Duration pollInterval) {
        return this.findElementOrNull(parentElement, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, pollInterval, false);
    }

    public HTMLElement findElementOrNull(HTMLElement parentElement, ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, Duration pollInterval, boolean waitUntilStable) {
        try {
            return this.findElement(parentElement, objectMapping, allowMultipleMatches, waitUntilSingle, timeout, pollInterval, waitUntilStable);
        }
        catch (Exception e) {
            this._lastException = e;
            return null;
        }
    }

    public HTMLElement findElement(HTMLElement parentElement, ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, Duration timeout, Duration pollInterval, boolean waitUntilStable) {
        List<HTMLElement> clauseResults = null;
        boolean multiLogShown = false;
        boolean showMultiMatches = true;
        boolean isStable = false;
        long totalTimeoutMillis = timeout.toMillis();
        long pollIntervalMillis = pollInterval.toMillis();
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Timeout - %s", (Object[])new Object[]{this.durationFormatted(timeout)});
        StopWatch timer = StopWatch.createStarted();
        while (true) {
            clauseResults = this.getHtmlElements(parentElement, objectMapping, allowMultipleMatches, waitUntilSingle, clauseResults == null || clauseResults.size() < 2, totalTimeoutMillis, pollIntervalMillis, timer);
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Got [%s] elements", (Object[])new Object[]{clauseResults == null ? "Null!" : Integer.toString(clauseResults.size())});
            if (clauseResults.size() == 0) {
                String errorText = String.format("Time reached and found 0 matching elements using ([%s] - %s) from [%s] (Waited upto %dmS).", objectMapping.getActualFindLogic(), objectMapping.getFriendlyName(), parentElement == null ? "DOM Top Level" : parentElement.getMappingDetails().getFriendlyName(), timer.getTime());
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)errorText, (Object[])new Object[0]);
                throw new RuntimeException(errorText);
            }
            if (clauseResults.size() > 1 && !allowMultipleMatches) {
                String errorText = String.format("Found %d matching elements using [%s] ([%s]) from [%s]. Not allowing mutiple matches and timeout reached after [%dmS]", clauseResults.size(), objectMapping.getActualFindLogic(), objectMapping.getFriendlyName(), parentElement == null ? "DOM Top Level" : parentElement.getMappingDetails().getFriendlyName(), timer.getTime());
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)errorText, (Object[])new Object[0]);
                throw new RuntimeException(errorText);
            }
            if (showMultiMatches && !waitUntilSingle) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"From [%s], find [%s (%s)] returned %d matches (%s multiple matches).", (Object[])new Object[]{parentElement == null ? "DOM Top Level" : parentElement.getMappingDetails().getFriendlyName(), objectMapping.getActualFindLogic(), objectMapping.getFriendlyName(), clauseResults.size(), allowMultipleMatches ? "Allowing" : "Not"});
                showMultiMatches = false;
            }
            if (!waitUntilStable) break;
            if (clauseResults.get(0).isPositionStable()) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"From [%s], find [%s (%s)] returned %d matches (%s multiple matches.  Element 0 is stable, so returning...).", (Object[])new Object[]{parentElement == null ? "DOM Top Level" : parentElement.getMappingDetails().getFriendlyName(), objectMapping.getActualFindLogic(), objectMapping.getFriendlyName(), clauseResults.size(), allowMultipleMatches ? "Allowing" : "Not"});
                break;
            }
            if (timer.getTime() >= totalTimeoutMillis) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"From [%s], find [%s (%s)] returned %d matches (%sllowing multiple matches). Element NOT stable after timeout reached so throwing", (Object[])new Object[]{parentElement == null ? "DOM Top Level" : parentElement.getMappingDetails().getFriendlyName(), objectMapping.getActualFindLogic(), objectMapping.getFriendlyName(), clauseResults.size(), allowMultipleMatches ? "A" : "Not A"});
                throw new RuntimeException(String.format("From [%s], find [%s (%s)] returned %d matches (%sllowing multiple matches). Element NOT stable after timeout reached ([%dmS]).", parentElement == null ? "DOM Top Level" : parentElement.getMappingDetails().getFriendlyName(), objectMapping.getActualFindLogic(), objectMapping.getFriendlyName(), clauseResults.size(), allowMultipleMatches ? "A" : "Not A", timer.getTime()));
            }
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"From [%s], find [%s (%s)] returned %d matches (%s multiple matches).  Element 0 is NOT stable and we must wait until stable...", (Object[])new Object[]{parentElement == null ? "DOM Top Level" : parentElement.getMappingDetails().getFriendlyName(), objectMapping.getActualFindLogic(), objectMapping.getFriendlyName(), clauseResults.size(), allowMultipleMatches ? "Allowing" : "Not"});
        }
        return clauseResults.get(0);
    }

    public List<HTMLElement> findElements(HTMLElement parentElement, ObjectMapping mapping) {
        List foundElements = null;
        ArrayList<HTMLElement> returnElements = new ArrayList<HTMLElement>();
        if (mapping == null) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"ObjectMapping = null!", (Object[])new Object[0]);
            throw new RuntimeException("SeleniumDriver.FindElements called with mapping null!");
        }
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"webDriver hash [%s], ObjectMapping = [%s] (%s)", (Object[])new Object[]{this.webDriver == null ? "Null!" : Integer.toString(this.webDriver.hashCode()), mapping.getOriginalFindLogic(), mapping.getFriendlyName()});
        By seleniumFindBy = mapping.getSeleniumBy();
        try {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Calling Selenium WebDriver findElements with By = [%s]", (Object[])new Object[]{seleniumFindBy.toString()});
            foundElements = parentElement == null ? this.webDriver.findElements(seleniumFindBy) : ((WebElement)parentElement.getUnderlyingWebElement()).findElements(seleniumFindBy);
        }
        catch (InvalidSelectorException e) {
            throw new RuntimeException(String.format("Selenium Driver error. Find Logic [%s] for [%s] is invalid!", new Object[]{mapping.getActualFindLogic(), mapping.getFriendlyName(), e}));
        }
        catch (WebDriverException e) {
            this.checkIfConnectionIssue((Exception)((Object)e));
            throw new RuntimeException("Selenium Driver error finding elements.  See inner exception.", e);
        }
        catch (Exception e) {
            if (parentElement == null) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Selenium error finding elements using find logic [%s] ([%s)]: %s", (Object[])new Object[]{seleniumFindBy.toString(), mapping.getFriendlyName(), e.toString()});
                throw new RuntimeException(String.format("Selenium error finding elements using find logic [%s] ([%s)]", seleniumFindBy.toString(), mapping.getFriendlyName()), e);
            }
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Selenium error finding elements offset from [%s (%s)] using find logic [%s] ([%s)]: %s", (Object[])new Object[]{parentElement.getMappingDetails().getFriendlyName(), parentElement.getMappingDetails().getActualFindLogic(), seleniumFindBy.toString(), mapping.getFriendlyName(), e.toString()});
            throw new RuntimeException(String.format("Selenium error finding elements offset from [%s (%s)] using find logic [%s] ([%s)]: %s", parentElement.getMappingDetails().getFriendlyName(), parentElement.getMappingDetails().getActualFindLogic(), seleniumFindBy.toString(), mapping.getFriendlyName()));
        }
        if (parentElement == null) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Found [%d] elements matching [%s] (%s)", (Object[])new Object[]{foundElements.size(), mapping.getOriginalFindLogic(), mapping.getFriendlyName()});
        } else {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Found [%d] elements matching [%s] (%s) offset from [%s]", (Object[])new Object[]{foundElements.size(), mapping.getOriginalFindLogic(), mapping.getFriendlyName(), parentElement.getMappingDetails().getFriendlyName()});
        }
        for (int index = 0; index < foundElements.size(); ++index) {
            ObjectMapping actualMapping = mapping.copy();
            if (actualMapping.getMappingType() == ObjectMapping.ByType.XPath) {
                actualMapping.setActualFindLogic(String.format("(%s)[%s]", actualMapping.getOriginalFindLogic(), Integer.toString(index + 1)));
            }
            HTMLElement htmlElement = new HTMLElement(this, foundElements.get(index), actualMapping);
            returnElements.add(htmlElement);
        }
        return returnElements;
    }

    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    public void setBrowserSize(int x, int y) {
        if (this.webDriver == null) {
            throw new RuntimeException("Selenium web driver has not been started!");
        }
        this.webDriver.manage().window().setSize(new Dimension(x, y));
    }

    public void setBrowserFullScreen() {
        if (this.webDriver == null) {
            throw new RuntimeException("Selenium web driver has not been started!");
        }
        this.webDriver.manage().window().fullscreen();
    }

    public void gotoURL(String fullURLPath) {
        try {
            this.webDriver.navigate().to(fullURLPath);
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Error browsing to [%s]: %s", (Object[])new Object[]{fullURLPath == null || fullURLPath.isEmpty() ? "NO URL!!" : fullURLPath, e.getMessage()});
            this.checkIfConnectionIssue(e);
            throw e;
        }
    }

    public String getPageTitle() {
        try {
            String title = this.webDriver.getTitle();
            return title == null ? "" : title;
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Error getting window title: %s", (Object[])new Object[]{e.getMessage()});
            this.checkIfConnectionIssue(e);
            throw e;
        }
    }

    public boolean isDisplayed(Object webElement) {
        if (webElement == null) {
            throw new RuntimeException("webElement null!");
        }
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Get element displayed status using Selenium IWebElement.isDisplayed", (Object[])new Object[0]);
        try {
            return ((WebElement)webElement).isDisplayed();
        }
        catch (InvalidElementStateException e) {
            throw new InvalidElementState("Unable to get element visibility.  See underlying cause.", (RuntimeException)((Object)e));
        }
    }

    public boolean isEnabled(Object webElement) {
        if (webElement == null) {
            throw new RuntimeException("webElement null!");
        }
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Get element enabled status using Selenium IWebElement.isEnabled", (Object[])new Object[0]);
        try {
            return ((WebElement)webElement).isEnabled();
        }
        catch (InvalidElementStateException e) {
            throw new InvalidElementState("Unable to get element enabled status.  See underlying cause.", (RuntimeException)((Object)e));
        }
    }

    public void clear(Object webElement) {
        if (webElement == null) {
            throw new RuntimeException("webElement null!");
        }
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Clearing element using Selenium IWebElement.Clear", (Object[])new Object[0]);
        try {
            ((WebElement)webElement).clear();
        }
        catch (InvalidElementStateException e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Unable to clear element.  See underlying cause: %s", (Object[])new Object[]{e});
            throw new InvalidElementState(String.format("Unable to clear element.  See underlying cause: %s", new Object[]{e}), (RuntimeException)((Object)e));
        }
    }

    public void setText(Object webElement, String text) {
        if (webElement == null) {
            throw new RuntimeException("webElement null!");
        }
        text = text == null ? "" : text;
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Entering text using Selenium IWebElement SendKeys: [%s].", (Object[])new Object[]{text});
        try {
            ((WebElement)webElement).sendKeys(new CharSequence[]{text});
        }
        catch (InvalidElementStateException e) {
            throw new InvalidElementState("Unable to set element text.  See underlying cause.", (RuntimeException)((Object)e));
        }
    }

    public String getText(Object webElement, boolean includeDescendantsText, boolean scrollIntoViewFirst, boolean useInnerTextAttribute) {
        if (webElement == null) {
            throw new RuntimeException("webElement null!");
        }
        if (scrollIntoViewFirst) {
            this.scrollIntoView(webElement);
        }
        StringBuilder text = new StringBuilder();
        if (includeDescendantsText) {
            if (useInnerTextAttribute) {
                text.append(((WebElement)webElement).getAttribute("innerText"));
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Get element text using element innerText attribute: [{0}]", (Object[])new Object[]{text});
            } else {
                text.append(((WebElement)webElement).getText());
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Get element text using Selenium Text property: [{0}]", (Object[])new Object[]{text});
            }
        } else {
            StringReader stringReader = new StringReader(((WebElement)webElement).getAttribute("outerHTML"));
            HTMLEditorKit htmlKit = new HTMLEditorKit();
            HTMLDocument htmlDoc = (HTMLDocument)htmlKit.createDefaultDocument();
            ParserDelegator parser = new ParserDelegator();
            try {
                ((HTMLEditorKit.Parser)parser).parse(stringReader, htmlDoc.getReader(0), true);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error parsing HTML from element outerHTML!", new Object[0]), e);
            }
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nl = null;
            try {
                XPathExpression exp = xPath.compile("/*/text()");
                nl = (NodeList)exp.evaluate(htmlDoc, XPathConstants.NODESET);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error with XPath!", new Object[0]), e);
            }
            for (int index = 0; index < nl.getLength(); ++index) {
                text.append(nl.item(index).getTextContent());
            }
        }
        return text.toString();
    }

    public void click(Object webElement) {
        if (webElement == null) {
            throw new RuntimeException("webElement null!");
        }
        try {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Click using WebDriver hash [%s]", (Object[])new Object[]{((WrapsDriver)webElement).getWrappedDriver() == null ? "null!!" : Integer.toString(((WrapsDriver)webElement).getWrappedDriver().hashCode())});
            ((WebElement)webElement).click();
        }
        catch (WebDriverException wde) {
            String errorMessage = wde.getMessage();
            if (errorMessage.toLowerCase().contains("other element would receive the click")) {
                WebElement offendingElement;
                try {
                    String[] xy = errorMessage.split("point [(]", 2)[1].split("[)]", 2)[0].replaceAll("\\s+", "").split("[,]", 2);
                    offendingElement = this.executeJavaScript(WebElement.class, "return document.elementFromPoint(arguments[0],arguments[1]);", xy[0], xy[1]);
                    if (offendingElement == null) {
                        throw new RuntimeException("No element returned from javascript!");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Error determining click coordinates for click from WebDriverException message: %s", e.getMessage()), wde);
                }
                throw new InvalidElementState(String.format("Element could not be clicked as another element would get the click.  Offending element (Element and all descendants shown):\r\n%s", offendingElement.getAttribute("outerHTML")), (RuntimeException)((Object)wde));
            }
            throw wde;
        }
    }

    public String getAttribute(Object webElement, String attribute) {
        if (webElement == null) {
            throw new RuntimeException("webElement null!");
        }
        try {
            String attrib = ((WebElement)webElement).getAttribute(attribute);
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Got attribute [%s]: [%s]", (Object[])new Object[]{attribute, attrib == null ? "Null" : attrib});
            return attrib == null ? "" : attrib;
        }
        catch (InvalidElementStateException e) {
            throw new InvalidElementState(String.format("Unable to get element attribute [%s].  See underlying cause.", attribute == null ? "Null!!" : attribute), (RuntimeException)((Object)e));
        }
    }

    public boolean hasAttribute(Object webElement, String attribute) {
        if (webElement == null) {
            throw new RuntimeException("webElement null!");
        }
        try {
            WebElement element = ((WebElement)webElement).findElement(By.xpath((String)String.format(".[@%s]", attribute)));
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Element [%s] have attribute: [%s]", (Object[])new Object[]{element == null ? "does not" : "does", attribute});
            return element != null;
        }
        catch (InvalidElementStateException e) {
            throw new InvalidElementState(String.format("Unable to get element attribute [%s].  See underlying cause.", attribute == null ? "Null!!" : attribute), (RuntimeException)((Object)e));
        }
    }

    public String getCssValue(Object webElement, String valueName) {
        if (webElement == null) {
            throw new RuntimeException("webElement null!");
        }
        try {
            String cssValue = ((WebElement)webElement).getCssValue(valueName);
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Got CSS Value [%s]: [%s]", (Object[])new Object[]{valueName, cssValue == null ? "Null" : cssValue});
            return cssValue == null ? "" : cssValue;
        }
        catch (InvalidElementStateException e) {
            throw new InvalidElementState(String.format("Unable to get element CSS Value [%s].  See underlying cause.", valueName == null ? "Null!!" : valueName), (RuntimeException)((Object)e));
        }
    }

    public boolean hasCssValue(Object webElement, String valueName) {
        if (webElement == null) {
            throw new RuntimeException("webElement null!");
        }
        return !this.getCssValue(webElement, valueName).isEmpty();
    }

    public void scrollIntoView(Object webElement) {
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Scrolling element in to view using JavaScript injection - [Element].scrollIntoView()", (Object[])new Object[0]);
        this.executeJavaScriptNoReturnData("arguments[0].scrollIntoView();", webElement);
    }

    public <T> T executeJavaScript(Class<T> type, String script, Object ... args) {
        Object result = null;
        try {
            result = ((JavascriptExecutor)this.webDriver).executeScript(script, args);
        }
        catch (WebDriverException e) {
            this.checkIfConnectionIssue((Exception)((Object)e));
            throw new RuntimeException("Selenium Driver error executing javascript.  See inner exception.", e);
        }
        catch (Exception ex) {
            String exceptionString = "";
            for (Object arg : args) {
                exceptionString = exceptionString.isEmpty() ? String.format("executeJavaScript(\"%s\")-(Args: \"%s\"", script, arg.getClass().getName()) : String.format("%s, \"%s\"", exceptionString, arg.getClass().getName());
            }
            if (exceptionString.isEmpty()) {
                exceptionString = String.format("executeJavaScript(\"%s\"): %s", script, exceptionString);
            }
            throw new RuntimeException(exceptionString, ex);
        }
        return type.cast(result);
    }

    public void executeJavaScriptNoReturnData(String script, Object ... args) {
        Object dummy = this.executeJavaScript(Object.class, script, args);
    }

    public String TakeScreenshot() {
        return this.TakeScreenshot(null);
    }

    public String TakeScreenshot(String fileName) {
        String filename = null;
        String filepath = null;
        try {
            if (this.webDriver != null) {
                if (this.webDriver instanceof TakesScreenshot) {
                    try {
                        fileName = (String)TestData.getItem(String.class, (String)"Screenshot", (String)"Filename");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        filepath = (String)TestData.getItem(String.class, (String)"Screenshot", (String)"Filepath");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (filename == null) {
                        filename = fileName == null ? "Screenshot" : fileName;
                    }
                    filename = filepath == null ? Paths.get(System.getProperty("user.dir"), "images", filename + ".jpg").toString() : Paths.get(filepath, filename + ".jpg").toString();
                    File screenshot = null;
                    try {
                        screenshot = (File)((TakesScreenshot)this.webDriver).getScreenshotAs(OutputType.FILE);
                        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Screenshot - {0}", (Object[])new Object[]{filename});
                    }
                    catch (Exception e) {
                        this.checkIfConnectionIssue(e);
                        throw new RuntimeException("Selenium Driver error taking screenshot.  See inner exception.", e);
                    }
                    try {
                        FileUtils.copyFile((File)screenshot, (File)new File(filename));
                    }
                    catch (Exception e) {
                        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Saving Screenshot - %s: %s", (Object[])new Object[]{filename, e});
                    }
                    return filename;
                }
                throw new RuntimeException("Error taking webDriver does not implement TakesScreenshot!  Is it RemoteWebDriver?");
            }
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"webDriver is null!  Unable to take screenshot.", (Object[])new Object[0]);
        }
        catch (Exception ex) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"Exception saving screenshot [{0}]", (Object[])new Object[]{filename == null ? "filename null!" : filename});
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"> {0}", (Object[])new Object[]{ex});
        }
        return "";
    }

    public void CloseDriver() {
        boolean TakeScreenshotOption = false;
        try {
            try {
                TakeScreenshotOption = General.IsValueTrue((String)((String)TestData.getItem(String.class, (String)"Debug", (String)"TakeScreenshot")));
            }
            catch (Exception ex) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"RunCategory Option [Debug, TakeScreenshot] Exception ignored, defaults to false: %s", (Object[])new Object[]{ex});
            }
            if (TakeScreenshotOption) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Debug.TakeScreenshot = {0} - Taking screenshot...", (Object[])new Object[]{TakeScreenshotOption});
                this.TakeScreenshot(Detokenizer.ProcessTokensInString((String)"{Date;today;yy-MM-dd_HH-mm-ssFFF}"));
            } else {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Debug.TakeScreenshot = {0} - NOT Taking screenshot...", (Object[])new Object[]{TakeScreenshotOption});
            }
            try {
                if (this.webDriver != null) {
                    this.webDriver.quit();
                }
                this.webDriver = null;
            }
            catch (Exception e) {
                try {
                    this.checkIfConnectionIssue(e);
                    throw new RuntimeException("Selenium Driver error closing Selenium.  See inner exception.", e);
                }
                catch (Exception ex) {
                    Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Ignoring Error: %s", (Object[])new Object[]{ex});
                    this.webDriver = null;
                }
            }
        }
        catch (Exception e) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)String.format("Error closing selenium driver: %s", e.getMessage()), (Object[])new Object[0]);
        }
    }

    private void startOrConnectToSeleniumServer(boolean killFirst) {
        if (!this.isLocalSelenium) {
            throw new RuntimeException("Remote server execution mot yet implemented!");
        }
        this.setupLocalRun(killFirst);
    }

    private void setSeleniumHost(String host) {
        this.seleniumHost = host;
        try {
            String seleniumHostFromTestData = (String)TestData.getItem(String.class, (String)this.ConfigHost[0], (String)this.ConfigHost[1]);
            if (!seleniumHostFromTestData.isEmpty()) {
                if (host != null && !host.isEmpty()) {
                    Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)String.format("Selenium Host set in Test Data.  Overriding passed host with [%s] (Test data [%s.%s])", seleniumHostFromTestData, this.ConfigHost[0], this.ConfigHost[1]), (Object[])new Object[0]);
                }
                this.seleniumHost = seleniumHostFromTestData;
            }
        }
        catch (Exception e) {
            if (this.seleniumHost == null || this.seleniumHost.isEmpty()) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)String.format("Selenium Host not set in Test data ([%s.%s]). Default to local.)", this.ConfigHost[0], this.ConfigHost[1]), (Object[])new Object[0]);
            }
            this.seleniumHost = "localhost";
        }
        this.isLocalSelenium = this.seleniumHost.equalsIgnoreCase("localhost") || this.seleniumHost.equals("127.0.0.1");
    }

    private void setupLocalRun(boolean killFirst) {
        block15: {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Running Selenium locally", (Object[])new Object[0]);
            try {
                if (Browsers.isInternetExplorer()) {
                    String executable = "IEDriver.exe";
                    InternetExplorerOptions IEO = new InternetExplorerOptions();
                    IEO.destructivelyEnsureCleanSession();
                    this.setPathToDriverIfExistsAndIsExecutable(this.seleniumServerFolder, "webdriver.ie.driver", executable);
                    if (this.seleniumDebugMode) {
                        System.setProperty("webdriver.ie.driver.loglevel", "TRACE");
                    }
                    if (this.seleniumLogFilename != null) {
                        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Writing Selenium Server Output to: %s", (Object[])new Object[]{this.seleniumLogFilename});
                        System.setProperty("webdriver.ie.driver.logfile", this.CheckAndPreparSeleniumLogFile(this.seleniumLogFilename));
                    } else {
                        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Writing Selenium Server Output to console", (Object[])new Object[0]);
                    }
                    InternetExplorerDriverService service = InternetExplorerDriverService.createDefaultService();
                    IEO.setCapability("INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS", true);
                    Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestInformation, (String)"IE Browser being used.  Setting INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS active. #ITSD1-1126", (Object[])new Object[0]);
                    this.webDriver = new InternetExplorerDriver(service, IEO);
                    break block15;
                }
                if (Browsers.isChrome()) {
                    String executable = "ChromeDriver.exe";
                    ChromeOptions options = new ChromeOptions();
                    this.setPathToDriverIfExistsAndIsExecutable(this.seleniumServerFolder, "webdriver.chrome.driver", executable);
                    if (this.seleniumDebugMode) {
                        System.setProperty("webdriver.chrome.verboseLogging", "true");
                    }
                    if (this.seleniumLogFilename != null) {
                        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Writing Selenium Server Output to: %s", (Object[])new Object[]{this.seleniumLogFilename});
                        System.setProperty("webdriver.chrome.logfile", this.CheckAndPreparSeleniumLogFile(this.seleniumLogFilename));
                    } else {
                        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Writing Selenium Server Output to console", (Object[])new Object[0]);
                    }
                    if (killFirst) {
                        this.killAllProcesses(executable);
                    }
                    this.webDriver = new ChromeDriver(ChromeDriverService.createDefaultService(), options);
                    Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Chrome driver created. Hash [%d]", (Object[])new Object[]{this.webDriver.hashCode()});
                    break block15;
                }
                if (Browsers.isEdge()) {
                    String executable = "EdgeDriver.exe";
                    EdgeOptions options = new EdgeOptions();
                    this.setPathToDriverIfExistsAndIsExecutable(this.seleniumServerFolder, "webdriver.edge.driver", executable);
                    if (this.seleniumDebugMode) {
                        System.setProperty("webdriver.edge.verboseLogging", "true");
                    }
                    if (this.seleniumLogFilename != null) {
                        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Writing Selenium Server Output to: %s", (Object[])new Object[]{this.seleniumLogFilename});
                        System.setProperty("webdriver.edge.logfile", this.CheckAndPreparSeleniumLogFile(this.seleniumLogFilename));
                    } else {
                        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkInformation, (String)"Writing Selenium Server Output to console", (Object[])new Object[0]);
                    }
                    this.webDriver = new EdgeDriver(EdgeDriverService.createDefaultService(), options);
                    break block15;
                }
                throw new RuntimeException(String.format("Browser [%s] not yet implemented!", Browsers.getBrowserType().name()));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error instantiating [%s] (%s)", Browsers.isChrome() ? "Chrome" : (Browsers.isEdge() ? "Edge" : (Browsers.isInternetExplorer() ? "Internet Explorer" : (Browsers.isSafari() ? "Safari" : "UNKNOWN!"))), this.seleniumServerFolder));
            }
        }
    }

    private List<HTMLElement> getHtmlElements(HTMLElement parentElement, ObjectMapping objectMapping, boolean allowMultipleMatches, boolean waitUntilSingle, boolean showMultiFound, long totalTimeoutMillis, long pollIntervalMillis, StopWatch timer) {
        List<HTMLElement> clauseResults = new ArrayList<HTMLElement>();
        while (clauseResults.size() == 0 || clauseResults.size() != 1 && !allowMultipleMatches && waitUntilSingle) {
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Allow Multiple Matches [%s], Wait until single match [%s].", (Object[])new Object[]{allowMultipleMatches ? "true" : "false", waitUntilSingle ? "true" : "false"});
            clauseResults = this.findElements(parentElement, objectMapping);
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.TestDebug, (String)"Found %s elements matching [%s].", (Object[])new Object[]{clauseResults == null ? "Null!" : Integer.toString(clauseResults.size()), objectMapping.getActualFindLogic()});
            if (clauseResults.size() != 0 && (clauseResults.size() == 1 || allowMultipleMatches || !waitUntilSingle)) continue;
            if (clauseResults.size() > 0 && showMultiFound) {
                showMultiFound = false;
            }
            try {
                Thread.sleep(pollIntervalMillis);
            }
            catch (Exception e) {
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.Error, (String)"Thread.sleep threw an exception after %s so aborting", (Object[])new Object[]{this.durationFormatted(timer.getTime())});
                throw new RuntimeException(String.format("Exception thrown while thread sleeping during Find Element (for [%s]) poll interval!", objectMapping.getFriendlyName()));
            }
            if (timer.getTime() < totalTimeoutMillis) continue;
            break;
        }
        return clauseResults;
    }

    private void setPathToDriverIfExistsAndIsExecutable(String pathToDriver, String driverExeProperty, String executable) {
        File driver = new File(pathToDriver, executable);
        if (!driver.exists() || !driver.canExecute()) {
            throw new IllegalArgumentException(String.format("Driver not found or is not executable in %s", pathToDriver));
        }
        System.setProperty(driverExeProperty, driver.getAbsolutePath());
    }

    private String CheckAndPreparSeleniumLogFile(String SeleniumDebugFile) {
        String seleniumDebugFile = "";
        String pathAndFile = "";
        if (SeleniumDebugFile == null || SeleniumDebugFile.isEmpty()) {
            return null;
        }
        seleniumDebugFile = new File(SeleniumDebugFile).getAbsolutePath();
        String seleniumDebugFileFolder = FilenameUtils.getFullPath((String)seleniumDebugFile);
        String seleniumDebugFileName = FilenameUtils.getBaseName((String)seleniumDebugFile);
        String seleniumDebugFileExt = FilenameUtils.getExtension((String)seleniumDebugFile);
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"SeleniumDebug File: [%s]", (Object[])new Object[]{seleniumDebugFile});
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"seleniumDebug FileFolder: [%s]", (Object[])new Object[]{seleniumDebugFileFolder});
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"seleniumDebug FileName: [%s]", (Object[])new Object[]{seleniumDebugFileName});
        Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"seleniumDebug FileExt: [%s]", (Object[])new Object[]{seleniumDebugFileExt});
        if (seleniumDebugFileFolder == null || seleniumDebugFileFolder.isEmpty()) {
            seleniumDebugFileFolder = System.getProperty("user.dir");
        }
        try {
            int TotalPathLength = seleniumDebugFileFolder.length() + seleniumDebugFileName.length() + seleniumDebugFileExt.length() + 2;
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Selenium Debug File - [%s %s.%s]", (Object[])new Object[]{seleniumDebugFileFolder, seleniumDebugFileName, seleniumDebugFileExt});
            Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Selenium Debug File TotalPathLength = %d", (Object[])new Object[]{TotalPathLength});
            if (TotalPathLength > 248) {
                if (seleniumDebugFileFolder.length() - seleniumDebugFileName.length() - seleniumDebugFileExt.length() - 2 > 248) {
                    Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"seleniumDebugFileFolder length %d so cannot fix path length by truncating seleniumDebugFileName", (Object[])new Object[]{seleniumDebugFileFolder.length()});
                    throw new RuntimeException(String.format("Cannot Selenium Debug file.  Full path [%d] would have been too long (Max 248 chars)", TotalPathLength));
                }
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Reducing path length by truncating seleniumDebugFileName (length currently %d)", (Object[])new Object[]{seleniumDebugFileName.length()});
                seleniumDebugFileName = seleniumDebugFileName.substring(0, seleniumDebugFileName.length() - (TotalPathLength - 248));
                Logger.WriteLine((Logger.LogLevels)Logger.LogLevels.FrameworkDebug, (String)"Reduced to length %d", (Object[])new Object[]{seleniumDebugFileName.length()});
            }
            pathAndFile = Paths.get(seleniumDebugFileFolder, seleniumDebugFileName + "." + seleniumDebugFileExt).toString();
            new File(seleniumDebugFileFolder).mkdirs();
            Files.write(Paths.get(pathAndFile, new String[0]), Arrays.asList("TeamControlium Selenium Debug File"), new OpenOption[0]);
            return pathAndFile;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Error creating Selenium Debug information file (%s): %s", pathAndFile, ex.getMessage()));
        }
    }

    private String durationFormatted(Duration duration) {
        return this.durationFormatted(duration.toMillis());
    }

    private String durationFormatted(long millis) {
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) - hours * 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) - hours * 3600L - minutes * 60L;
        long milliseconds = millis - seconds * 1000L - minutes * 60000L - hours * 3600000L;
        return String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, milliseconds);
    }

    private void killAllProcesses(String name) {
        int matchingProcessCount = this.getProcessCount(name);
        int newProcessCount = 0;
        while (matchingProcessCount > 0) {
            try {
                if (matchingProcessCount >= 0) {
                    String line;
                    Process p = Runtime.getRuntime().exec(System.getenv("windir") + String.format("\\system32\\taskkill.exe /F /IM %s", name));
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        int n = 99;
                    }
                    input.close();
                }
            }
            catch (Exception err) {
                Assertions.fail((String)String.format("Error killing [%s] processes ", name), (Throwable)err);
            }
            newProcessCount = this.getProcessCount(name);
            if (newProcessCount == matchingProcessCount) {
                Assertions.fail((String)String.format("Error killing [%s] processes.  Did not kill processes! ", name));
            }
            matchingProcessCount = newProcessCount;
        }
    }

    private int getProcessCount(String name) {
        int count = 0;
        List<String[]> processInstanceCount = this.getProcessList();
        for (String[] line : this.getProcessList()) {
            if (!line[0].equalsIgnoreCase(name)) continue;
            ++count;
        }
        return count;
    }

    private List<String[]> getProcessList() {
        boolean startLogging = false;
        ArrayList<String[]> list = new ArrayList<String[]>();
        try {
            String line;
            Process p = Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\tasklist.exe");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                String[] arrayLine = line.split("\\s+");
                if (startLogging) {
                    list.add(arrayLine);
                }
                if (!line.contains("=======")) continue;
                startLogging = true;
            }
            input.close();
        }
        catch (Exception err) {
            Assertions.fail((String)"Error getting process list: ", (Throwable)err);
        }
        return list;
    }

    private String CallingMethodDetails(StackTraceElement methodBase) {
        String methodName = "";
        if (methodBase != null && (methodName = methodBase.getMethodName()) == null) {
            methodName = "<Unknown>";
        }
        return String.format("%s", methodName);
    }

    private void checkIfConnectionIssue(Exception e) throws RuntimeException {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTraceElements[2];
        if (e.getClass() == ConnectException.class) {
            throw new RuntimeException(String.format("Selenium Driver method [%s] called but Selenium WebDriver not connected!", this.CallingMethodDetails(caller)), e);
        }
    }
}

