/*
 * Decompiled with CFR 0.152.
 */
package TeamControlium.Utilities;

import TeamControlium.Utilities.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Detokenizer {
    private static final char tokenStartChar = '{';
    private static final char tokenEndChar = '}';
    private static BiFunction<String, String[], String> _CustomTokenProcessor = null;

    public static void setCustomTokenProcessor(BiFunction<String, String[], String> customProcessor) {
        _CustomTokenProcessor = customProcessor;
    }

    public static String ProcessTokensInString(String stringWithTokens) {
        int startIndex;
        String detokenizedString = "";
        boolean foundTokenStart = false;
        for (startIndex = 0; !foundTokenStart && startIndex < stringWithTokens.length(); ++startIndex) {
            if (stringWithTokens.charAt(startIndex) != '{') continue;
            if (startIndex < stringWithTokens.length() - 1 && stringWithTokens.charAt(startIndex + 1) == '{') {
                ++startIndex;
                continue;
            }
            foundTokenStart = true;
        }
        if (foundTokenStart) {
            int endIndex;
            boolean foundTokenEnd = false;
            for (endIndex = startIndex; !foundTokenEnd && endIndex < stringWithTokens.length(); ++endIndex) {
                if (stringWithTokens.charAt(endIndex) == '{' && (startIndex >= stringWithTokens.length() - 1 || stringWithTokens.charAt(startIndex + 1) != '{')) {
                    startIndex = endIndex + 1;
                    continue;
                }
                if (stringWithTokens.charAt(endIndex) != '}') continue;
                if (endIndex < stringWithTokens.length() - 1 && stringWithTokens.charAt(endIndex + 1) == '}') {
                    ++endIndex;
                    continue;
                }
                foundTokenEnd = true;
            }
            if (foundTokenEnd) {
                detokenizedString = detokenizedString + stringWithTokens.substring(0, startIndex - 1);
                String token = stringWithTokens.substring(startIndex, endIndex - 1);
                try {
                    detokenizedString = detokenizedString + Detokenizer.ProcessToken(token);
                }
                catch (Exception ex) {
                    Logger.WriteLine(Logger.LogLevels.Error, String.format("Error processing token {%s}: %s", token, ex), new Object[0]);
                    detokenizedString = detokenizedString + String.format("<Token [%s] Not processed.  See log>", token);
                }
                detokenizedString = detokenizedString + stringWithTokens.substring(endIndex, stringWithTokens.length());
            } else {
                Logger.WriteLine(Logger.LogLevels.Error, String.format("Found token start {{ found at index {%d} but no closing }} found: [%s]", startIndex, stringWithTokens), new Object[0]);
            }
            detokenizedString = Detokenizer.ProcessTokensInString(detokenizedString);
        } else {
            detokenizedString = detokenizedString + stringWithTokens.replace("{{", "{").replace("}}", "}");
        }
        return detokenizedString;
    }

    private static String ProcessToken(String token) throws Exception {
        String delimiter = ";";
        String processedToken = null;
        if (StringUtils.isEmpty((String)token)) {
            throw new Exception("Empty token!");
        }
        String[] splitToken = token.split(delimiter, 2);
        if (_CustomTokenProcessor != null) {
            try {
                processedToken = _CustomTokenProcessor.apply(delimiter, splitToken);
            }
            catch (Exception ex) {
                throw new Exception("Error thrown by custom token processor.", ex);
            }
        }
        if (processedToken == null) {
            switch (splitToken[0].toLowerCase().trim()) {
                case "random": {
                    if (splitToken.length < 2) {
                        throw new Exception("Random token [" + token + "] needs 3 parts {{random;<type>;<length>}}");
                    }
                    processedToken = Detokenizer.DoRandomToken(delimiter, splitToken[1]);
                    break;
                }
                case "date": {
                    if (splitToken.length < 2) {
                        throw new Exception("Date token [" + token + "] needs 3 parts {{date;<offset>;<format>}}");
                    }
                    processedToken = Detokenizer.DoDateToken(delimiter, splitToken[1]);
                    break;
                }
                case "financialyearstart": {
                    if (splitToken.length < 2) {
                        throw new Exception("FinancialYearStart token [" + token + "] needs 3 parts {{FinancialYearStart;<date>;<format>}}");
                    }
                    processedToken = Detokenizer.DoFinancialYearToken(delimiter, splitToken[1], true);
                    break;
                }
                case "financialyearend": {
                    if (splitToken.length < 2) {
                        throw new Exception("FinancialYearEnd token [" + token + "] needs 3 parts {{FinancialYearEnd;<date>;<format>}}");
                    }
                    processedToken = Detokenizer.DoFinancialYearToken(delimiter, splitToken[1], false);
                    break;
                }
                default: {
                    throw new Exception("Unsupported token [" + splitToken[0] + "] in [" + token + "]");
                }
            }
        }
        return processedToken;
    }

    private static String DoRandomToken(String delimiter, String TypeAndLength) throws Exception {
        String[] typeAndLengthOrFormat = TypeAndLength.split(delimiter, 2);
        String result = "";
        String select = "";
        String verb = typeAndLengthOrFormat[0].toLowerCase().trim();
        if (verb.startsWith("date(")) {
            Date dt = Detokenizer.DoRandomDate(verb.substring(verb.indexOf(40) + 1, verb.length() - 1));
            result = typeAndLengthOrFormat[1].trim().equalsIgnoreCase("epoch") ? Long.toString(dt.getTime()) : new SimpleDateFormat(typeAndLengthOrFormat[1]).format(dt);
        } else if (verb.startsWith("float(")) {
            result = String.format(typeAndLengthOrFormat[1], Float.valueOf(Detokenizer.DoRandomFloat(verb.substring(verb.indexOf(40) + 1, verb.length() - 1))));
        } else {
            int number;
            if (verb.startsWith("from(")) {
                select = typeAndLengthOrFormat[0].trim().substring(verb.indexOf(40) + 1, verb.length() - 2);
            } else {
                switch (verb) {
                    case "letters": {
                        select = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                        break;
                    }
                    case "lowercaseletters": {
                        select = "abcdefghijklmnopqrstuvwxyz";
                        break;
                    }
                    case "uppercaseletters": {
                        select = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                        break;
                    }
                    case "digits": {
                        select = "01234567890";
                        break;
                    }
                    case "alphanumerics": {
                        select = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890";
                        break;
                    }
                    default: {
                        throw new Exception("Unrecognised random Type [" + typeAndLengthOrFormat[0] + "] - Expect letters, lowercaseletters, uppercaseletters digits or alphanumerics");
                    }
                }
            }
            try {
                int lastDigit;
                for (lastDigit = 0; lastDigit < typeAndLengthOrFormat[1].length() && Character.isDigit(typeAndLengthOrFormat[1].charAt(lastDigit)); ++lastDigit) {
                }
                number = Integer.parseInt(typeAndLengthOrFormat[1].substring(0, lastDigit));
            }
            catch (Exception ex) {
                throw new Exception("Invalid number of characters in Random token {{random;<type>;<length>}}");
            }
            for (int index = 0; index < number; ++index) {
                int selectIndex = ThreadLocalRandom.current().nextInt(0, select.length());
                result = result + select.charAt(selectIndex);
            }
        }
        return result;
    }

    private static float DoRandomFloat(String MaxAndMinFloats) throws Exception {
        float Max;
        float Min;
        String delimiter = ",";
        String[] MaxAndMin = MaxAndMinFloats.split(delimiter);
        if (MaxAndMin.length != 2) {
            throw new Exception("Invalid Maximum and Minimum floats. Expect {{random.float(min;max),<format>}}. Max/min was: [" + MaxAndMinFloats + "]");
        }
        try {
            Min = Float.parseFloat(MaxAndMin[0]);
        }
        catch (Exception ex) {
            throw new Exception("Invalid Minimum float. Expect {{random.float(min;max),<format>}}. Max/min was: [" + MaxAndMinFloats + "]");
        }
        try {
            Max = Float.parseFloat(MaxAndMin[1]);
        }
        catch (Exception ex) {
            throw new Exception("Invalid Maximum float. Expect {{random.float(min;max),<format>}}. Max/min was: [" + MaxAndMinFloats + "]");
        }
        return Detokenizer.DoRandomFloat(Min, Max);
    }

    private static float DoRandomFloat(float MinFloat, float MaxFloat) throws Exception {
        if (MinFloat >= MaxFloat) {
            throw new Exception("Maximum float less than Minimum float! Expect {{random.float(min,max),<format>}} Min = " + Float.toString(MinFloat) + ", Max = " + Float.toString(MaxFloat));
        }
        return ThreadLocalRandom.current().nextFloat() * (MaxFloat - MinFloat) + MinFloat;
    }

    private static Date DoRandomDate(String MaxAndMinDates) throws Exception {
        Date Max;
        Date Min;
        String delimiter = ",";
        String[] MaxAndMin = MaxAndMinDates.split(delimiter);
        if (MaxAndMin.length != 2) {
            throw new Exception("Invalid Maximum and Minimum dates. Expect {{random;date(dd-MM-yyyy,dd-MM-yyyy);<format>}}. Max/min was: [" + MaxAndMinDates + "]");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("d-M-yyyy");
        try {
            Min = dateFormat.parse(MaxAndMin[0]);
        }
        catch (Exception ex) {
            throw new Exception("Invalid Minimum date. Expect {{random;date(dd-MM-yyyy,dd-MM-yyyy);<format>}}. Max/min was: [" + MaxAndMinDates + "]");
        }
        try {
            Max = dateFormat.parse(MaxAndMin[1]);
        }
        catch (Exception ex) {
            throw new Exception("Invalid Maximum date. Expect {{random;date(dd-MM-yyyy,dd-MM-yyyy);<format>}}. Max/min was: [" + MaxAndMinDates + "]");
        }
        return Detokenizer.DoRandomDate(Min, Max);
    }

    private static Date DoRandomDate(Date MinDate, Date MaxDate) throws Exception {
        if (MinDate.after(MaxDate)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("d-M-yyyy");
            throw new Exception("Maximum date earlier than Maximum date! Expect {{random;date(dd-MM-yyyy,dd-MM-yyyy);<format>}} Mindate = " + dateFormat.format(MinDate) + ", Maxdate = " + dateFormat.format(MaxDate));
        }
        return new Date(ThreadLocalRandom.current().nextLong(MinDate.getTime(), MaxDate.getTime()));
    }

    private static String DoDateToken(String delimiter, String OffsetAndFormat) throws Exception {
        Date dt;
        String[] offsetAndFormat = OffsetAndFormat.split(delimiter, 2);
        if (offsetAndFormat.length != 2) {
            throw new Exception("Date token does not have a format parameter; example: {date" + delimiter + "today" + delimiter + "dd-MM-yyyy}");
        }
        String verb = offsetAndFormat[0].toLowerCase().trim();
        if (verb.startsWith("random(")) {
            dt = Detokenizer.DoRandomDate(verb.substring(verb.indexOf(40) + 1, verb.length() - 2 - verb.indexOf(40)));
        } else {
            block6 : switch (verb) {
                case "today": {
                    dt = new Date();
                    break;
                }
                case "yesterday": {
                    dt = Detokenizer.getDateOffset(5, -1);
                    break;
                }
                case "tomorrow": {
                    dt = Detokenizer.getDateOffset(5, 1);
                    break;
                }
                default: {
                    String[] activeOffset = verb.substring(0, verb.length() - 1).split(Pattern.quote("("), 2);
                    if (offsetAndFormat[0].contains("(") && offsetAndFormat[0].endsWith(")")) {
                        int offset;
                        try {
                            offset = Integer.parseInt(activeOffset[1]);
                        }
                        catch (Exception ex) {
                            throw new Exception("Invalid Active Date offset.  Expect AddYears(n) AddMonths(n) or AddDays(n). Got [" + activeOffset[0].trim() + "]");
                        }
                        switch (activeOffset[0].trim()) {
                            case "addyears": {
                                dt = Detokenizer.getDateOffset(1, offset);
                                break block6;
                            }
                            case "addmonths": {
                                dt = Detokenizer.getDateOffset(2, offset);
                                break block6;
                            }
                            case "adddays": {
                                dt = Detokenizer.getDateOffset(5, offset);
                                break block6;
                            }
                        }
                        throw new Exception("Invalid Active Date offset.  Expect AddYears(n) AddMonths(n) or AddDays(n). Got [" + activeOffset[0].trim() + "]");
                    }
                    throw new Exception("Invalid Active Date offset.  Expect AddYears(n) AddMonths(n) or AddDays(n). Got [" + activeOffset[0].trim() + "]");
                }
            }
        }
        if (offsetAndFormat[1].trim().equalsIgnoreCase("epoch")) {
            return Long.toString(dt.getTime());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(offsetAndFormat[1]);
        return dateFormat.format(dt);
    }

    private static String DoFinancialYearToken(String delimiter, String DateToWorkFromAndFormat, boolean Start2) throws Exception {
        String financialYearStart = "01/07";
        String financialYearEnd = "01/07";
        String[] dateToWorkFromAndFormat = DateToWorkFromAndFormat.split(delimiter, 2);
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        Date dateToWorkFrom = Detokenizer.tryParseDate(dateToWorkFromAndFormat[0], Arrays.asList("dd/MM/yyyy", "d/MM/yyyy", "dd/M/yyyy", "d/M/yyyy", "dd/MM/yy", "d/MM/yy", "dd/M/yy", "d/M/yy"));
        if (dateToWorkFrom == null) {
            throw new Exception("Cannot parse date [" + dateToWorkFromAndFormat[0] + "].  Must be in format d/M/y.");
        }
        String year = Detokenizer.dateToCalendar(dateToWorkFrom).get(2) + 1 >= 7 ? Integer.toString(Start2 ? Detokenizer.dateToCalendar(dateToWorkFrom).get(1) : Detokenizer.dateToCalendar(dateToWorkFrom).get(1)) : Integer.toString(Start2 ? Detokenizer.dateToCalendar(dateToWorkFrom).get(1) - 1 : Detokenizer.dateToCalendar(dateToWorkFrom).get(1));
        Date returnDate = Detokenizer.tryParseDate((Start2 ? financialYearStart : financialYearEnd) + "/" + year, Arrays.asList("dd/MM/yyyy"));
        return new SimpleDateFormat(dateToWorkFromAndFormat[1]).format(returnDate);
    }

    private static Date getDateOffset(int offsetType, int offset) {
        Calendar cal = Calendar.getInstance();
        cal.add(offsetType, offset);
        return cal.getTime();
    }

    private static Calendar dateToCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private static Date tryParseDate(String dateString, List<String> validFormats) {
        for (String formatString : validFormats) {
            try {
                return new SimpleDateFormat(formatString).parse(dateString);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }
}

