/*
 * Decompiled with CFR 0.152.
 */
package TeamControlium.Utilities;

import TeamControlium.Utilities.Detokenizer;
import TeamControlium.Utilities.Logger;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class General {
    public static Object DetokeniseString(Object ObjectToProcess) throws Exception {
        if (ObjectToProcess instanceof String) {
            String StringToProcess = "";
            String ProcessedString = (String)ObjectToProcess;
            Logger.Write(Logger.LogLevels.FrameworkDebug, "Object is a string [{0}]. ", ProcessedString == null ? "" : ProcessedString);
            while (!Objects.equals(StringToProcess, ProcessedString)) {
                StringToProcess = ProcessedString;
                ProcessedString = Detokenizer.ProcessTokensInString(StringToProcess);
                Logger.WriteLine(Logger.LogLevels.FrameworkDebug, "Processed [{0}] to [{1}]", StringToProcess, ProcessedString == null ? "" : ProcessedString);
            }
            return ProcessedString;
        }
        Logger.WriteLine(Logger.LogLevels.FrameworkDebug, "Object [{0}] not a String. Not processed", ObjectToProcess.getClass().getTypeName());
        return ObjectToProcess;
    }

    public static boolean IsValueTrue(String Value) {
        if (Value == null || Value == "") {
            return false;
        }
        try {
            int i = Integer.parseInt(Value);
            return i > 0;
        }
        catch (Exception ex) {
            String lower = Value.toLowerCase();
            return lower.charAt(0) == 't' || lower.charAt(0) == 'y' || lower.startsWith("on");
        }
    }

    public static String CleanStringForXPath(String original) {
        if (!original.contains("'")) {
            return '\'' + original + '\'';
        }
        if (!original.contains("\"")) {
            return '\"' + original + '\"';
        }
        return "concat('" + original.replace(Pattern.quote("'"), "',\"'\",'") + "')";
    }

    public static String CleanStringForFilename(String original) {
        String processed = original.replaceAll("[^a-zA-Z0-9\\.\\-\\\\:]", "_");
        while (processed.contains("__")) {
            processed = processed.replaceAll("__", "_");
        }
        return processed;
    }

    public static String GetTextFromHTML(String HtmlData) throws Exception {
        if (HtmlData == null) {
            return null;
        }
        Document htmlDoc = Jsoup.parse((String)HtmlData);
        return htmlDoc.body().text();
    }
}

