/*
 * Decompiled with CFR 0.152.
 */
package TeamControlium.Utilities;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.io.FilenameUtils;

public final class Logger {
    private boolean errorWrittenToEventLog = false;
    private Date testTimer;
    private HashMap<Long, String> testToolStrings = new HashMap();
    private static Logger _Logger;
    private LogLevels _LoggingLevel = LogLevels.TestInformation;
    private boolean _WriteToConsole;
    public Consumer<String> _TestToolLog;

    private Logger() {
        this.ResetTimer();
    }

    public static LogLevels getLoggingLevel() {
        if (_Logger == null) {
            _Logger = new Logger();
        }
        return Logger._Logger._LoggingLevel;
    }

    public static void setLoggingLevel(LogLevels loggingLevel) {
        if (_Logger == null) {
            _Logger = new Logger();
        }
        Logger._Logger._LoggingLevel = loggingLevel;
    }

    public static void setLoggingLevel(String loggingLevel) {
        if (loggingLevel == null || loggingLevel.isEmpty()) {
            Logger.WriteLine(LogLevels.Error, "Logging level is blank or null!  Defaulting to verbose!", new Object[0]);
        } else {
            switch (loggingLevel.trim().toLowerCase()) {
                case "frameworkdebug": 
                case "verbose": {
                    Logger.setLoggingLevel(LogLevels.FrameworkDebug);
                    break;
                }
                case "frameworkinformation": 
                case "frameworkinfo": {
                    Logger.setLoggingLevel(LogLevels.FrameworkInformation);
                    break;
                }
                case "testdebug": {
                    Logger.setLoggingLevel(LogLevels.TestDebug);
                    break;
                }
                case "testinformation": 
                case "testinfo": {
                    Logger.setLoggingLevel(LogLevels.TestInformation);
                    break;
                }
                case "error": 
                case "minimum": {
                    Logger.setLoggingLevel(LogLevels.Error);
                    break;
                }
                default: {
                    Logger.setLoggingLevel(LogLevels.FrameworkDebug);
                    Logger.WriteLine(LogLevels.Error, String.format("Unknown logging level [%s].  Defaulting to verbose!", loggingLevel), new Object[0]);
                }
            }
        }
    }

    public static boolean getWriteToConsole() {
        if (_Logger == null) {
            _Logger = new Logger();
        }
        return Logger._Logger._WriteToConsole;
    }

    public static void setWriteToConsole(boolean writeToConsole) {
        if (_Logger == null) {
            _Logger = new Logger();
        }
        Logger._Logger._WriteToConsole = writeToConsole;
    }

    public static Consumer<String> getTestToolLog() {
        if (_Logger == null) {
            _Logger = new Logger();
        }
        return Logger._Logger._TestToolLog;
    }

    public static void setTestToolLog(Consumer<String> testToolLog) {
        if (_Logger == null) {
            _Logger = new Logger();
        }
        Logger._Logger._TestToolLog = testToolLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DoWriteLine(StackTraceElement methodBase, LogLevels TypeOfWrite, String textString) {
        if (TypeOfWrite.getVal() >= Logger.getLoggingLevel().getVal()) {
            String textToWrite = textString;
            long threadID = Thread.currentThread().getId();
            if (this.testToolStrings.containsKey(threadID)) {
                try {
                    this.testToolStrings.put(threadID, this.testToolStrings.get(threadID).endsWith(" ") ? "" : " " + textToWrite);
                    textToWrite = this.testToolStrings.get(threadID);
                }
                finally {
                    this.testToolStrings.remove(threadID);
                }
            } else {
                String preAmble = this.GetPreAmble(methodBase, TypeOfWrite);
                textToWrite = preAmble + (textString == null ? "" : textString);
            }
            try {
                Consumer<String> d = Logger.getTestToolLog();
                if (Logger.getWriteToConsole() || Logger.getTestToolLog() == null) {
                    System.out.println(textToWrite);
                } else {
                    this._TestToolLog.accept(textToWrite);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DoWrite(StackTraceElement methodBase, LogLevels TypeOfWrite, String textString) {
        if (TypeOfWrite.getVal() >= Logger.getLoggingLevel().getVal()) {
            Logger logger = this;
            synchronized (logger) {
                long threadID = Thread.currentThread().getId();
                if (this.testToolStrings.containsKey(threadID)) {
                    this.testToolStrings.put(threadID, this.GetPreAmble(methodBase, TypeOfWrite));
                }
                this.testToolStrings.put(threadID, this.testToolStrings.get(threadID).endsWith(" ") ? "" : " " + textString);
            }
        }
    }

    private String CallingMethodDetails(StackTraceElement methodBase) {
        String methodName = "";
        String typeName = "";
        if (methodBase != null) {
            methodName = methodBase.getMethodName();
            if (methodName == null) {
                methodName = "<Unknown>";
            }
            if ((typeName = methodBase.getClassName()) == null) {
                typeName = "<Unknown>";
            }
        }
        return String.format("%s.%s", typeName, methodName);
    }

    private String GetPreAmble(StackTraceElement methodBase, LogLevels TypeOfWrite) {
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SS");
        String time = String.format("[%s}][%s]", timeFormat.format(Calendar.getInstance().getTime()), this.elapsedTime());
        int totalTimeLength = time.length() + (8 - TypeOfWrite.getNumVal());
        String preAmble = String.format("%s %s [%s]: ", TypeOfWrite.toString(), time, this.CallingMethodDetails(methodBase));
        return preAmble;
    }

    private boolean FileExists(String fullPathAndFilename) {
        File f = new File(fullPathAndFilename);
        return f.exists() && !f.isDirectory();
    }

    public String elapsedTime() {
        long diffInMilliSeconds = Calendar.getInstance().getTime().getTime() - this.testTimer.getTime();
        List<TimeUnit> units = Arrays.asList(TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
        String result = "";
        long milliSecondsRest = diffInMilliSeconds;
        for (TimeUnit unit : units) {
            long diff = unit.convert(milliSecondsRest, TimeUnit.MILLISECONDS);
            milliSecondsRest -= unit.toMillis(diff);
            switch (unit) {
                case HOURS: {
                    result = result + String.format("%02d:", diff);
                    break;
                }
                case MINUTES: {
                    result = result + String.format("%02d:", diff);
                    break;
                }
                case SECONDS: {
                    result = result + String.format("%02d:", diff);
                    break;
                }
                case MILLISECONDS: {
                    result = result + String.format("%03d", diff);
                }
            }
        }
        return result;
    }

    public void ResetTimer() {
        this.testTimer = Calendar.getInstance().getTime();
    }

    public static void LogException(Exception ex) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTraceElements[2];
        if (_Logger == null) {
            _Logger = new Logger();
        }
        if (_Logger.getLoggingLevel() == LogLevels.FrameworkDebug) {
            _Logger.DoWriteLine(caller, LogLevels.Error, String.format("Exception thrown: %s", ex.toString()));
        } else {
            _Logger.DoWriteLine(caller, LogLevels.Error, String.format("Exception thrown: %s", ex.getMessage()));
        }
    }

    public static void LogException(Exception ex, String text, Object ... args) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTraceElements[2];
        if (_Logger == null) {
            _Logger = new Logger();
        }
        _Logger.DoWrite(caller, LogLevels.Error, String.format(text, args));
        if (_Logger.getLoggingLevel() == LogLevels.FrameworkDebug) {
            _Logger.DoWriteLine(caller, LogLevels.Error, String.format("Exception thrown: %s", ex.toString()));
        } else {
            _Logger.DoWriteLine(caller, LogLevels.Error, String.format("Exception thrown: %s", ex.getMessage()));
        }
    }

    public static void Write(LogLevels logLevel, String textString, Object ... args) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTraceElements[2];
        if (_Logger == null) {
            _Logger = new Logger();
        }
        _Logger.DoWrite(caller, logLevel, String.format(textString, args));
    }

    public static void WriteLine(LogLevels logLevel, String textString, Object ... args) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTraceElements[2];
        if (_Logger == null) {
            _Logger = new Logger();
        }
        _Logger.DoWriteLine(caller, logLevel, String.format(textString, args));
    }

    public static void WriteTextToFile(String Filename, boolean AutoVersion, String Text) {
        if (_Logger == null) {
            _Logger = new Logger();
        }
        try {
            String FilenameToUse = Filename;
            if (AutoVersion) {
                int count = 1;
                String fileNameOnly = FilenameUtils.removeExtension((String)Filename);
                String extension = FilenameUtils.getExtension((String)Filename);
                String path = Paths.get(Filename, new String[0]).getParent().toString();
                FilenameToUse = Filename;
                while (_Logger.FileExists(FilenameToUse)) {
                    String tempFileName = String.format("%s(%d)", fileNameOnly, count++);
                    File preAmble = new File(path);
                    File combined = new File(preAmble, tempFileName + extension);
                    FilenameToUse = combined.getPath();
                }
            }
            List<String> lines = Arrays.asList(Text.split("\\r?\\n"));
            Path file = Paths.get(FilenameToUse, new String[0]);
            Files.write(file, lines, Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (Exception ex) {
            Logger.LogException(ex, String.format("Cannot write data to file [%s] (AutoVersion=[%s])", Filename == null ? "Null Filename!" : Filename, AutoVersion ? "Yes" : "No"), new Object[0]);
        }
    }

    public static enum LogLevels {
        FrameworkDebug(0),
        FrameworkInformation(1),
        TestDebug(2),
        TestInformation(3),
        Error(4);

        private int numVal;

        public int getVal() {
            return this.numVal;
        }

        private LogLevels(int numVal) {
            this.numVal = numVal;
        }

        public int getNumVal() {
            return this.numVal;
        }
    }
}

