/*
 * Copyright 2016-2020 the original author.All rights reserved.
 * Kingstar(honeysoft@126.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.teasoft.bee.osql.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 用于表连接的注解.Annotation for tables join.
 * @author Kingstar
 * @since  1.7
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface JoinTable {

	JoinType joinType() default JoinType.JOIN; //join type: left join,right join,join (full join)
	//	String mainEntity();
	//	String subEntity();

	/**
	 * 主表关联的字段.The join on field of main table.
	 * @return main table's join field name.
	 */
	String mainField() default ""; 

	/**
	 * 从表关联的字段.The join on field of subtable.
	 * @return subtable's join field name.
	 */
	String subField() default ""; 

	/**
	 * 从表别名.Subtable alias.
	 * @return subtable alias.
	 */
	String subAlias() default ""; 

}
