/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.bee.mongodb;

import java.io.Serializable;

public class MongoSqlStruct
implements Serializable {
    private static final long serialVersionUID = 1592803913614L;
    private String returnType;
    private Class entityClass;
    private String tableName;
    private Object filter;
    private Object sortBson;
    private Integer start;
    private Integer size;
    private String[] selectFields;
    private boolean hasId;
    private Object updateSet;
    private String sql;

    public MongoSqlStruct(String returnType, String tableName, Object filter, Object sortBson, Integer start, Integer size, String[] selectFields, boolean hasId, Class entityClass) {
        this.returnType = returnType;
        this.tableName = tableName;
        this.filter = filter;
        this.sortBson = sortBson;
        this.start = start;
        this.size = size;
        this.selectFields = selectFields;
        this.hasId = hasId;
        this.entityClass = entityClass;
    }

    public MongoSqlStruct(String returnType, String tableName, Object filter, Object sortBson, Integer start, Integer size, String[] selectFields, boolean hasId, Class entityClass, Object updateSet) {
        this(returnType, tableName, filter, sortBson, start, size, selectFields, hasId, entityClass);
        this.updateSet = updateSet;
    }

    public String getSql() {
        if (this.sql == null) {
            this.sql = this.toSql();
        }
        return this.sql;
    }

    private String toSql() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("[table]: ");
        strBuf.append(this.tableName);
        strBuf.append(" , [where/filter]: ");
        if (this.filter != null) {
            strBuf.append(this.filter.toString());
        }
        strBuf.append(" , [orderyBy/sort]: ");
        if (this.sortBson != null) {
            strBuf.append(this.sortBson.toString());
        }
        strBuf.append(" , [skip]: ");
        strBuf.append(this.start);
        strBuf.append(" , [limit]: ");
        strBuf.append(this.size);
        strBuf.append(" , [selectFields]: ");
        if (this.selectFields != null) {
            for (int i = 0; i < this.selectFields.length; ++i) {
                if (i != 0) {
                    strBuf.append(",");
                }
                strBuf.append(this.selectFields[i]);
            }
        }
        strBuf.append(" , [returnType]: ");
        strBuf.append(this.returnType);
        strBuf.append(" , [entityClass]: ");
        if (this.entityClass != null) {
            strBuf.append(this.entityClass.getName());
        }
        if (this.updateSet != null) {
            strBuf.append(" , [updateSet/insert/fun]: ");
            strBuf.append(this.updateSet.toString());
        }
        return strBuf.toString();
    }

    public MongoSqlStruct copy() {
        return new MongoSqlStruct(this.returnType, this.tableName, this.filter, this.sortBson, this.start, this.size, this.selectFields, this.hasId, this.entityClass, this.updateSet);
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Object getFilter() {
        return this.filter;
    }

    public Object getSortBson() {
        return this.sortBson;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getSize() {
        return this.size;
    }

    public String[] getSelectFields() {
        return this.selectFields;
    }

    public boolean isHasId() {
        return this.hasId;
    }

    public Object getUpdateSet() {
        return this.updateSet;
    }
}

