/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.bee.ds;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teasoft.bee.ds.DataSourceBuilder;
import org.teasoft.bee.osql.Registry;

public class DataSourceBuilderFactory
implements Registry {
    private static Map<String, DataSourceBuilder> map = null;

    private DataSourceBuilderFactory() {
    }

    public static void register(String dataSourceToolType, DataSourceBuilder builder) {
        if (map == null) {
            DataSourceBuilderFactory.initMap();
        }
        if (dataSourceToolType != null) {
            dataSourceToolType = dataSourceToolType.toLowerCase();
        }
        if (map != null) {
            map.put(dataSourceToolType, builder);
        }
    }

    private static synchronized void initMap() {
        map = new ConcurrentHashMap<String, DataSourceBuilder>();
    }

    public static DataSourceBuilder getDataSourceBuilder(String dataSourceToolType) {
        return map == null ? null : map.get(dataSourceToolType.toLowerCase());
    }
}

