/*
 * Copyright 2016-2020 the original author.All rights reserved.
 * Kingstar(honeysoft@126.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.teasoft.bee.osql;

import org.teasoft.bee.osql.api.Condition;

/**
 * Select of More Objects to SQL.
 * @author Kingstar
 * @since  1.7
 */
public interface MoreObjToSQL {

	/**
	 *  Convert to SQL statement according to entity.
	 * @param entity table's entity(do not allow null).
	 * @return the sql String.
	 */
	public <T> String toSelectSQL(T entity);

	/**
	 *  Convert to SQL statement according to entity and paging parameters.
	 * @param entity table's entity(do not allow null).
	 * @param start
	 * @param size
	 * @return the sql String.
	 */
	public <T> String toSelectSQL(T entity, int start, int size);

	/**
	 * Convert to SQL statement according to entity and condition.
	 * @param entity table's entity(do not allow null).
	 * @param condition if the field is not null or empty, it will be translate to field=value.Other can define with condition. 
	 * @return the sql String.
	 */
	public <T> String toSelectSQL(T entity, Condition condition);

}
