/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.logging;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.teasoft.bee.logging.Log;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.StringUtils;

public class LoggerFactory {
    private static Constructor<? extends Log> logConstructor;
    private static Constructor<? extends Log> logNoArgConstructor;
    private static ThreadLocal<Map<String, Log>> logLocal;
    private static boolean isNoArgInConstructor;

    private LoggerFactory() {
    }

    private static void init() {
        String loggerType = HoneyConfig.getHoneyConfig().loggerType;
        if (loggerType != null && !"".equals(loggerType.trim())) {
            boolean f;
            loggerType = loggerType.trim();
            String LOGGER_UNSUCCESSFULLY = "[Bee] [WARN] the loggerType: " + loggerType + " , set unsuccessfully!";
            String LOGGER_UNSUCCESSFULLY_MAYBE_DONOT_SET_JAR = "[Bee] [WARN] the loggerType: " + loggerType + " , set unsuccessfully! Maybe do not set the jar!";
            if (loggerType.equalsIgnoreCase("log4j")) {
                boolean f2 = LoggerFactory.tryImplementation("org.apache.log4j.Logger", "org.teasoft.beex.logging.Log4jImpl");
                if (!f2) {
                    System.err.println(LOGGER_UNSUCCESSFULLY_MAYBE_DONOT_SET_JAR);
                }
            } else if (loggerType.equalsIgnoreCase("slf4j")) {
                boolean f3 = LoggerFactory.tryImplementation("org.slf4j.Logger", "org.teasoft.beex.logging.Slf4jImpl");
                if (!f3) {
                    System.err.println(LOGGER_UNSUCCESSFULLY_MAYBE_DONOT_SET_JAR);
                }
            } else if (loggerType.equalsIgnoreCase("log4j2")) {
                boolean f4 = LoggerFactory.tryImplementation("org.apache.logging.log4j.Logger", "org.teasoft.beex.logging.Log4j2Impl");
                if (!f4) {
                    System.err.println(LOGGER_UNSUCCESSFULLY_MAYBE_DONOT_SET_JAR);
                }
            } else if (loggerType.equalsIgnoreCase("systemLogger")) {
                boolean f5 = LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.SystemLogger");
                if (!f5) {
                    System.err.println(LOGGER_UNSUCCESSFULLY);
                }
            } else if (loggerType.equalsIgnoreCase("fileLogger")) {
                boolean f6 = LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.FileLogger");
                if (!f6) {
                    System.err.println(LOGGER_UNSUCCESSFULLY);
                }
            } else if (loggerType.equalsIgnoreCase("noLogging")) {
                boolean f7 = LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.NoLogging");
                if (!f7) {
                    System.err.println(LOGGER_UNSUCCESSFULLY);
                }
            } else if (loggerType.equalsIgnoreCase("jdkLog")) {
                boolean f8 = LoggerFactory.tryImplementation("java.util.logging.Logger", "org.teasoft.honey.logging.Jdk14LoggingImpl");
                if (!f8) {
                    System.err.println(LOGGER_UNSUCCESSFULLY);
                }
            } else if (loggerType.equalsIgnoreCase("commonsLog") && !(f = LoggerFactory.tryImplementation("org.apache.commons.logging.LogFactory", "org.teasoft.beex.logging.JakartaCommonsLoggingImpl"))) {
                System.err.println(LOGGER_UNSUCCESSFULLY_MAYBE_DONOT_SET_JAR);
            }
        }
        LoggerFactory.tryImplementation("org.apache.log4j.Logger", "org.teasoft.beex.logging.Log4jImpl");
        LoggerFactory.tryImplementation("org.slf4j.Logger", "org.teasoft.beex.logging.Slf4jImpl");
        LoggerFactory.tryImplementation("org.apache.logging.log4j.Logger", "org.teasoft.beex.logging.Log4j2Impl");
        LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.SystemLogger");
        LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.FileLogger");
        LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.NoLogging");
        LoggerFactory.tryImplementation("java.util.logging.Logger", "org.teasoft.honey.logging.Jdk14LoggingImpl");
        LoggerFactory.tryImplementation("org.apache.commons.logging.LogFactory", "org.teasoft.beex.logging.JakartaCommonsLoggingImpl");
    }

    private static boolean tryImplementation(String testClassName, String implClassName) {
        if (logConstructor != null) {
            return true;
        }
        if (isNoArgInConstructor && logNoArgConstructor != null) {
            return true;
        }
        try {
            if (implClassName != null && (implClassName.endsWith(".Log4jImpl") || implClassName.endsWith(".Slf4jImpl") || implClassName.endsWith(".SystemLogger") || implClassName.endsWith(".NoLogging") || implClassName.endsWith(".FileLogger"))) {
                try {
                    if (testClassName != null && !"".equals(testClassName)) {
                        LoggerFactory.genClassByName(testClassName);
                    }
                    Class<?> implClassNoArg = LoggerFactory.genClassByName(implClassName);
                    logNoArgConstructor = implClassNoArg.getConstructor(new Class[0]);
                    isNoArgInConstructor = true;
                    String s1 = "[Bee] LoggerFactory Use the Logger is : " + implClassName;
                    if (StringUtils.isNotBlank(testClassName)) {
                        s1 = s1 + " , Logger adapt from : " + testClassName;
                    }
                    System.out.println(s1);
                    return true;
                }
                catch (ClassNotFoundException implClassNoArg) {
                }
                catch (Exception implClassNoArg) {
                    // empty catch block
                }
            }
            if (testClassName != null && !"".equals(testClassName)) {
                LoggerFactory.genClassByName(testClassName);
            }
            Class<?> implClass = LoggerFactory.genClassByName(implClassName);
            logConstructor = implClass.getConstructor(String.class);
            String s2 = "[Bee] LoggerFactory Use the Logger is : " + implClassName;
            if (StringUtils.isNotBlank(testClassName)) {
                s2 = s2 + " , Logger adapt from : " + testClassName;
            }
            System.out.println(s2);
            return true;
        }
        catch (ClassNotFoundException e) {}
        finally {
            return false;
        }
    }

    public static Log getLog() {
        Log cacheLog = LoggerFactory.getCacheInfo("NoArg");
        if (cacheLog != null) {
            return cacheLog;
        }
        Log log = null;
        try {
            if (isNoArgInConstructor) {
                log = logNoArgConstructor.newInstance(new Object[0]);
                LoggerFactory.setCacheInfo("NoArg", log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (log != null) {
            return log;
        }
        log = LoggerFactory.getLog(LoggerFactory.class.getName());
        return log;
    }

    public static Log getLog(Class clazz) {
        return LoggerFactory.getLog(clazz.getName());
    }

    public static Log getLog(String loggerName) {
        Log cacheLog;
        if (loggerName == null || "".equals(loggerName.trim())) {
            loggerName = LoggerFactory.class.getName();
        }
        if ((cacheLog = LoggerFactory.getCacheInfo(loggerName)) != null) {
            return cacheLog;
        }
        try {
            Log log = logConstructor.newInstance(loggerName);
            LoggerFactory.setCacheInfo(loggerName, log);
            return log;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error creating logger'" + loggerName + "'.  Cause by: " + t, t);
        }
    }

    private static Class<?> genClassByName(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Exception e) {
            Logger.warn(e.getMessage(), e);
        }
        catch (Error e) {
            Logger.warn(e.getMessage(), e);
        }
        if (clazz == null) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public static boolean isNoArgInConstructor() {
        return isNoArgInConstructor;
    }

    private static void setCacheInfo(String key, Log logger) {
        if (logger == null) {
            return;
        }
        if (key == null || "".equals(key.trim())) {
            return;
        }
        Map<String, Log> map = logLocal.get();
        if (null == map) {
            map = new HashMap<String, Log>();
        }
        map.put(key, logger);
        logLocal.set(map);
    }

    private static Log getCacheInfo(String key) {
        Map<String, Log> map = logLocal.get();
        if (null == map) {
            return null;
        }
        return map.get(key);
    }

    static {
        logLocal = new ThreadLocal();
        LoggerFactory.init();
    }
}

