/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.autogen;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.teasoft.bee.osql.PreparedSql;
import org.teasoft.bee.osql.annotation.PrimaryKey;
import org.teasoft.honey.osql.autogen.Java2DbType;
import org.teasoft.honey.osql.core.BeeFactoryHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.util.EntityUtil;
import org.teasoft.honey.util.SqlKeyCheck;

public class Ddl {
    private static final String BE_REPLACE_WITH_TYPE = "It will be replace with type: ";
    private static final String NOT_RELATIVE_COLUMN = " has not the relative database column type!";
    private static final String THE_JAVA_TYPE = "The java type:";
    private static final String CREATE_TABLE = "CREATE TABLE ";
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static PreparedSql preparedSql = BeeFactoryHelper.getPreparedSql();
    private static Map<String, String> pkStatement = new HashMap<String, String>();
    private static String java_lang_String = "java.lang.String";

    private Ddl() {
    }

    private static Map<String, String> getJava2DbType() {
        return Java2DbType.getJava2DbType(HoneyContext.getDbDialect());
    }

    public static <T> boolean createTable(T entity, boolean isDropExistTable) {
        if (isDropExistTable) {
            String tableName;
            block7: {
                tableName = Ddl._toTableName(entity);
                boolean second = false;
                try {
                    String sql0 = "";
                    if (HoneyUtil.isOracle() || HoneyUtil.isSqlServer()) {
                        sql0 = "DROP TABLE " + tableName;
                    } else {
                        sql0 = " DROP TABLE IF EXISTS " + tableName;
                        second = true;
                    }
                    preparedSql.modify(sql0);
                }
                catch (Exception e) {
                    if (!second) break block7;
                    try {
                        preparedSql.modify("DROP TABLE " + tableName);
                    }
                    catch (Exception e2) {
                        Logger.warn(e2.getMessage());
                    }
                }
            }
            return Ddl.createTable(entity, tableName);
        }
        return Ddl.createTable(entity);
    }

    public static <T> boolean createTable(T entity) {
        return Ddl.createTable(entity, null);
    }

    private static <T> boolean createTable(T entity, String tableName) {
        boolean result = false;
        try {
            boolean old = HoneyConfig.getHoneyConfig().showSql_showExecutableSql;
            if (old) {
                HoneyConfig.getHoneyConfig().showSql_showExecutableSql = false;
            }
            preparedSql.modify(Ddl.toCreateTableSQL(entity, tableName));
            if (old) {
                HoneyConfig.getHoneyConfig().showSql_showExecutableSql = old;
            }
            result = true;
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
            result = false;
        }
        return result;
    }

    public static <T> String toCreateTableSQL(T entity) {
        return Ddl.toCreateTableSQL(entity, null);
    }

    private static <T> String toCreateTableSQL(T entity, String tableName) {
        if (HoneyUtil.isSQLite()) {
            return Ddl.toCreateTableSQLForSQLite(entity, tableName);
        }
        if (HoneyUtil.isMysql()) {
            return Ddl.toCreateTableSQLForMySQL(entity, tableName);
        }
        if ("H2".equalsIgnoreCase(HoneyContext.getDbDialect())) {
            return Ddl.toCreateTableSQLForH2(entity, tableName);
        }
        if ("PostgreSQL".equalsIgnoreCase(HoneyContext.getDbDialect())) {
            return Ddl.toCreateTableSQLForPostgreSQL(entity, tableName);
        }
        if (HoneyUtil.isSqlServer()) {
            return Ddl.toCreateTableSQLForSQLSERVER(entity, tableName);
        }
        return Ddl._toCreateTableSQL(entity, tableName);
    }

    private static <T> String _toCreateTableSQL(T entity, String tableName) {
        if (tableName == null) {
            tableName = Ddl._toTableName(entity);
        }
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(CREATE_TABLE + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entity.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (Ddl.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(Ddl._toColumnName(fields[i].getName(), entity.getClass())).append("  ");
            String type = Ddl.getType(fields[i]);
            if (HoneyUtil.isCassandra()) {
                if (EntityUtil.isList(fields[i]) || EntityUtil.isSet(fields[i])) {
                    Class<?> clazz = EntityUtil.getGenericType(fields[i]);
                    String type0 = Ddl.getType(clazz);
                    type = type + "<" + type0 + ">";
                } else if (EntityUtil.isMap(fields[i])) {
                    Class<?>[] classes = EntityUtil.getGenericTypeArray(fields[i]);
                    String type1 = Ddl.getType(classes[0]);
                    String type2 = Ddl.getType(classes[1]);
                    type = type + "<" + type1 + "," + type2 + ">";
                }
            }
            sqlBuffer.append(type);
            if (Ddl.isPrimaryKey(fields[i])) {
                sqlBuffer.append(" PRIMARY KEY");
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static String getType(Field field) {
        String type = Ddl.getJava2DbType().get(field.getType().getName());
        if (type == null) {
            Logger.warn(THE_JAVA_TYPE + type + NOT_RELATIVE_COLUMN);
            type = Ddl.getJava2DbType().get(java_lang_String);
            Logger.warn(BE_REPLACE_WITH_TYPE + type);
        }
        return type;
    }

    private static String getType(Class<?> c) {
        String name = "";
        if (c == null) {
            Logger.warn("The Class is null,it will be replace with " + java_lang_String);
            name = java_lang_String;
        } else {
            name = c.getName();
        }
        String type = Ddl.getJava2DbType().get(name);
        if (type == null) {
            if (EntityUtil.isCustomBean(name) && c != null) {
                type = NameUtil.firstLetterToLowerCase(c.getSimpleName());
            } else {
                Logger.warn(THE_JAVA_TYPE + name + NOT_RELATIVE_COLUMN);
                type = Ddl.getJava2DbType().get(java_lang_String);
                Logger.warn(BE_REPLACE_WITH_TYPE + type);
            }
        }
        return type;
    }

    private static <T> String toCreateTableSQLForSQLite(T entity, String tableName) {
        return Ddl.toCreateTableSQLComm(entity, tableName, "SQLite");
    }

    private static <T> String toCreateTableSQLForMySQL(T entity, String tableName) {
        if (tableName == null) {
            tableName = Ddl._toTableName(entity);
        }
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(CREATE_TABLE + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entity.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (Ddl.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(Ddl._toColumnName(fields[i].getName(), entity.getClass())).append("  ");
            if (Ddl.isPrimaryKey(fields[i])) {
                sqlBuffer.append("bigint(20) PRIMARY KEY NOT NULL AUTO_INCREMENT");
            } else {
                String type = Ddl.getJava2DbType().get(fields[i].getType().getName());
                if (type == null) {
                    Logger.warn(THE_JAVA_TYPE + type + NOT_RELATIVE_COLUMN);
                    type = Ddl.getJava2DbType().get(java_lang_String);
                    Logger.warn(BE_REPLACE_WITH_TYPE + type);
                }
                sqlBuffer.append(type);
                if ("timestamp".equalsIgnoreCase(type) || "datetime".equalsIgnoreCase(type)) {
                    sqlBuffer.append(" DEFAULT CURRENT_TIMESTAMP");
                } else {
                    sqlBuffer.append(" DEFAULT NULL");
                }
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static <T> String toCreateTableSQLForH2(T entity, String tableName) {
        return Ddl.toCreateTableSQLComm(entity, tableName, "H2");
    }

    private static void initPkStatement() {
        pkStatement.put("H2".toLowerCase(), "bigint PRIMARY KEY NOT NULL");
        pkStatement.put("SQLite".toLowerCase(), " INTEGER PRIMARY KEY NOT NULL");
        pkStatement.put("PostgreSQL".toLowerCase(), "bigserial NOT NULL");
        pkStatement.put("", "");
        pkStatement.put(null, "");
    }

    private static String getPrimaryKeyStatement(String databaseName) {
        return pkStatement.get(databaseName.toLowerCase());
    }

    private static <T> String toCreateTableSQLComm(T entity, String tableName, String databaseName) {
        if (tableName == null) {
            tableName = Ddl._toTableName(entity);
        }
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(CREATE_TABLE + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entity.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (Ddl.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(Ddl._toColumnName(fields[i].getName(), entity.getClass())).append("  ");
            if (Ddl.isPrimaryKey(fields[i])) {
                sqlBuffer.append(Ddl.getPrimaryKeyStatement(databaseName));
            } else {
                String type = Ddl.getJava2DbType().get(fields[i].getType().getName());
                if (type == null) {
                    Logger.warn(THE_JAVA_TYPE + type + NOT_RELATIVE_COLUMN);
                    type = Ddl.getJava2DbType().get(java_lang_String);
                    Logger.warn(BE_REPLACE_WITH_TYPE + type);
                }
                sqlBuffer.append(type);
                if ("timestamp".equalsIgnoreCase(type) || "datetime".equalsIgnoreCase(type)) {
                    sqlBuffer.append(" DEFAULT CURRENT_TIMESTAMP");
                } else {
                    sqlBuffer.append(" DEFAULT NULL");
                }
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static <T> String toCreateTableSQLForPostgreSQL(T entity, String tableName) {
        return Ddl.toCreateTableSQLComm(entity, tableName, "PostgreSQL");
    }

    private static <T> String toCreateTableSQLForSQLSERVER(T entity, String tableName) {
        if (tableName == null) {
            tableName = Ddl._toTableName(entity);
        }
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(CREATE_TABLE + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entity.getClass().getDeclaredFields();
        boolean hasCurrentTime = false;
        for (int i = 0; i < fields.length; ++i) {
            if (Ddl.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(Ddl._toColumnName(fields[i].getName(), entity.getClass())).append("  ");
            if (Ddl.isPrimaryKey(fields[i])) {
                sqlBuffer.append("bigint PRIMARY KEY NOT NULL");
            } else {
                String type = Ddl.getJava2DbType().get(fields[i].getType().getName());
                if (type == null) {
                    Logger.warn(THE_JAVA_TYPE + type + NOT_RELATIVE_COLUMN);
                    type = Ddl.getJava2DbType().get(java_lang_String);
                    Logger.warn(BE_REPLACE_WITH_TYPE + type);
                }
                if ("timestamp".equalsIgnoreCase(type)) {
                    if (!hasCurrentTime) {
                        sqlBuffer.append(type);
                        sqlBuffer.append(" ");
                        hasCurrentTime = true;
                    } else {
                        sqlBuffer.append("datetime DEFAULT NULL");
                    }
                } else {
                    sqlBuffer.append(type);
                    sqlBuffer.append(" DEFAULT NULL");
                }
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    public static void setDynamicParameter(String para, String value) {
        BeeFactoryHelper.getSuid().setDynamicParameter(para, value);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toColumnName(String fieldName, Class entityClass) {
        String name = NameTranslateHandle.toColumnName(fieldName, entityClass);
        if (SqlKeyCheck.isKeyWord(name)) {
            Logger.warn("The '" + name + "' is Sql Keyword. Do not recommend!");
        }
        return name;
    }

    private static boolean isSkipField(Field field) {
        return HoneyUtil.isSkipField(field);
    }

    private static boolean isPrimaryKey(Field field) {
        if ("id".equalsIgnoreCase(field.getName())) {
            return true;
        }
        return field.isAnnotationPresent(PrimaryKey.class);
    }

    static {
        Ddl.initPkStatement();
    }
}

