/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teasoft.bee.osql.BeeException;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.annotation.Ignore;
import org.teasoft.bee.osql.annotation.JoinTable;
import org.teasoft.bee.osql.annotation.JoinType;
import org.teasoft.bee.osql.annotation.JustFetch;
import org.teasoft.bee.osql.annotation.PrimaryKey;
import org.teasoft.bee.osql.annotation.customizable.Json;
import org.teasoft.bee.osql.exception.BeeErrorFieldException;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeIllegalEntityException;
import org.teasoft.bee.osql.exception.BeeIllegalSQLException;
import org.teasoft.bee.osql.exception.JoinTableException;
import org.teasoft.bee.osql.exception.JoinTableParameterException;
import org.teasoft.bee.osql.type.SetParaTypeConvert;
import org.teasoft.honey.osql.core.Check;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.osql.type.CharTypeHandler;
import org.teasoft.honey.osql.type.SetParaTypeConverterRegistry;
import org.teasoft.honey.osql.type.TimestampTypeHandler;
import org.teasoft.honey.osql.type.TypeHandlerRegistry;
import org.teasoft.honey.osql.type.UtilDotDateTypeConvert;
import org.teasoft.honey.osql.type.UtilDotDateTypeToTimestampConvert;
import org.teasoft.honey.osql.util.NameCheckUtil;
import org.teasoft.honey.osql.util.PropertiesReader;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;

public final class HoneyUtil {
    private static final String STRING = "String";
    private static Map<String, String> jdbcTypeMap = new HashMap<String, String>();
    private static Map<String, Integer> javaTypeMap = new HashMap<String, Integer>();
    private static PropertiesReader jdbcTypeCustomProp = new PropertiesReader("/jdbcTypeToFieldType.properties");
    private static PropertiesReader jdbcTypeCustomProp_specificalDB = null;
    private static String SET_WRONG_VALUE_IN = "Annotation JoinTable set wrong value in ";

    static void refreshTypeMapConfig() {
        HoneyUtil.initTypeMapConfig();
    }

    private HoneyUtil() {
    }

    private static void initTypeMapConfig() {
        String proFileName = "/jdbcTypeToFieldType-{DbName}.properties";
        HoneyUtil.initJdbcTypeMap();
        HoneyUtil.appendJdbcTypeCustomProp();
        String dbName = HoneyConfig.getHoneyConfig().getDbName();
        if (dbName != null) {
            jdbcTypeCustomProp_specificalDB = new PropertiesReader(proFileName.replace("{DbName}", dbName));
            HoneyUtil.appendJdbcTypeCustomProp_specificalDB();
        }
        HoneyUtil.initJavaTypeMap();
        SetParaTypeConverterRegistry.register(java.util.Date.class, new UtilDotDateTypeToTimestampConvert(), "Oracle");
        SetParaTypeConverterRegistry.register(java.util.Date.class, new UtilDotDateTypeToTimestampConvert(), "PostgreSQL");
        SetParaTypeConverterRegistry.register(java.util.Date.class, new UtilDotDateTypeToTimestampConvert(), "H2");
        SetParaTypeConverterRegistry.register(java.util.Date.class, new UtilDotDateTypeToTimestampConvert(), "MySQL");
        SetParaTypeConverterRegistry.register(java.util.Date.class, new UtilDotDateTypeConvert());
        TypeHandlerRegistry.register(Character.TYPE, new CharTypeHandler(), true);
    }

    static String getBeanField(Field[] field, Class entityClass) {
        if (field == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        int len = field.length;
        boolean isFirst = true;
        for (int i = 0; i < len; ++i) {
            if (HoneyUtil.isSkipField(field[i])) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                s.append(",");
            }
            if (field[i].isAnnotationPresent(JustFetch.class)) {
                s.append(HoneyUtil.getJustFetchColumn(field[i]));
                continue;
            }
            s.append(NameTranslateHandle.toColumnName(field[i].getName(), entityClass));
        }
        return s.toString();
    }

    private static String getJustFetchColumn(Field field) {
        String expression = HoneyUtil.getJustFetchDefineName(field);
        String c = "";
        String fName = NameTranslateHandle.toColumnName(field.getName());
        c = HoneyUtil.isSQLite() ? expression + K.as + fName : expression + " " + fName;
        return c;
    }

    private static String getJustFetchDefineName(Field field) {
        JustFetch justFetch = field.getAnnotation(JustFetch.class);
        String expression = justFetch.value();
        HoneyUtil.checkExpression(expression);
        return expression;
    }

    private static void checkExpression(String expression) {
        if (Check.isNotValidExpressionForJustFetch(expression)) {
            throw new BeeIllegalSQLException("The expression: '" + expression + "' is invalid in JustFetch Annotation!");
        }
    }

    static <T> MoreTableStruct[] getMoreTableStructAndCheckBefore(T entity) {
        String packageAndClassName = entity.getClass().getName();
        String key = "ForMoreTable:" + packageAndClassName;
        MoreTableStruct[] moreTableStruct = null;
        if (OneTimeParameter.isTrue("_SYS_Bee_MoreStruct_to_SqlLib")) {
            moreTableStruct = HoneyUtil._getMoreTableStructAndCheckBefore(entity);
            OneTimeParameter.setAttribute(key, moreTableStruct);
            if (moreTableStruct[1] == null) {
                throw new BeeErrorGrammarException("MoreTable select on " + entity.getClass().getName() + " must own at least one JoinTable annotation!");
            }
        } else {
            moreTableStruct = (MoreTableStruct[])OneTimeParameter.getAttribute(key);
        }
        return moreTableStruct;
    }

    private static <T> MoreTableStruct[] _getMoreTableStructAndCheckBefore(T entity) {
        String useSubTableName;
        String t_subAlias;
        if (entity == null) {
            return null;
        }
        String entityFullName = entity.getClass().getName();
        Field[] field = entity.getClass().getDeclaredFields();
        MoreTableStruct[] moreTableStruct = new MoreTableStruct[3];
        moreTableStruct[0] = new MoreTableStruct();
        Field[] subField = new Field[2];
        int subEntityFieldNum = 0;
        HashSet<String> mainFieldSet = new HashSet<String>();
        HashMap<String, String> dulMap = new HashMap<String, String>();
        String tableName = (String)OneTimeParameter.getAttribute("_SYS_Bee_TableName");
        if (tableName == null) {
            tableName = HoneyUtil._toTableName(entity);
        }
        StringBuffer columns = new StringBuffer();
        List listOne = null;
        List listTwo = null;
        Class<?> list_T_classOne = null;
        Class<?> list_T_classTwo = null;
        boolean subOneIsList = false;
        boolean subTwoIsList = false;
        int len = field.length;
        boolean isFirst = true;
        String mailField = "";
        for (int i = 0; i < len; ++i) {
            if (HoneyUtil.isSkipFieldForMoreTable(field[i])) continue;
            if (field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) {
                if (++subEntityFieldNum == 1) {
                    subField[0] = field[i];
                }
                if (subEntityFieldNum == 2) {
                    subField[1] = field[i];
                }
                if (!List.class.isAssignableFrom(field[i].getType())) continue;
                try {
                    List list;
                    field[i].setAccessible(true);
                    if (subEntityFieldNum == 1) {
                        subOneIsList = true;
                        moreTableStruct[0].subOneIsList = true;
                        listOne = list = (List)field[i].get(entity);
                        if (!ObjectUtils.isNotEmpty(list)) continue;
                        list_T_classOne = list.get(0).getClass();
                        continue;
                    }
                    if (subEntityFieldNum != 2) continue;
                    subTwoIsList = true;
                    moreTableStruct[0].subTwoIsList = true;
                    listTwo = list = (List)field[i].get(entity);
                    if (!ObjectUtils.isNotEmpty(list)) continue;
                    list_T_classTwo = list.get(0).getClass();
                }
                catch (IllegalAccessException e) {
                    Logger.warn(e.getMessage());
                }
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                columns.append(",");
            }
            columns.append(tableName);
            columns.append(".");
            mailField = NameTranslateHandle.toColumnName(field[i].getName(), entity.getClass());
            columns.append(mailField);
            mainFieldSet.add(mailField);
        }
        if (subEntityFieldNum > 2) {
            throw new JoinTableException("One entity only supports two JoinTable at most! " + entityFullName + " has " + subEntityFieldNum + " JoinTable now !");
        }
        JoinTable[] joinTable = new JoinTable[2];
        String[] subTableName = new String[2];
        if (subField[0] != null) {
            joinTable[0] = subField[0].getAnnotation(JoinTable.class);
            String errorMsg = HoneyUtil.checkJoinTable(joinTable[0]);
            if (!"".equals(errorMsg)) {
                throw new JoinTableParameterException("Error: mainField and subField can not just use only one." + errorMsg);
            }
            if (subOneIsList && joinTable[0].joinType() == JoinType.RIGHT_JOIN) {
                throw new JoinTableException("The List type subTable donot support JoinType.RIGHT_JOIN, you can adjust with JoinType.LEFT_JOIN.");
            }
            if (subOneIsList && list_T_classOne == null) {
                Class c = joinTable[0].subClazz();
                if (!c.equals(Object.class)) {
                    list_T_classOne = c;
                } else {
                    String subClassStr = joinTable[0].subClass();
                    list_T_classOne = HoneyUtil.createClass(subClassStr, entityFullName);
                }
            }
        }
        boolean oneHasOne = false;
        StringBuffer[] subColumnStringBuffer = new StringBuffer[2];
        if (subEntityFieldNum == 1 && !subOneIsList) {
            t_subAlias = joinTable[0].subAlias();
            if (StringUtils.isNotBlank(t_subAlias)) {
                useSubTableName = t_subAlias;
            } else {
                subTableName[0] = HoneyUtil._toTableNameByEntityName(subField[0].getType().getName());
                useSubTableName = subTableName[0];
            }
            boolean checkOneHasOne = !entity.getClass().equals(subField[0].getType());
            subColumnStringBuffer[0] = HoneyUtil._getBeanFullField_0(subField[0].getType(), useSubTableName, entityFullName, mainFieldSet, dulMap, checkOneHasOne);
        } else if (subEntityFieldNum == 1 && subOneIsList) {
            t_subAlias = joinTable[0].subAlias();
            if (StringUtils.isNotBlank(t_subAlias)) {
                useSubTableName = t_subAlias;
            } else {
                subTableName[0] = HoneyUtil._toTableNameByEntityName(list_T_classOne.getName());
                useSubTableName = subTableName[0];
            }
            subColumnStringBuffer[0] = HoneyUtil._getBeanFullField_0(list_T_classOne, useSubTableName, entityFullName, mainFieldSet, dulMap, true);
        }
        if (subEntityFieldNum == 1) {
            subField[1] = (Field)OneTimeParameter.getAttribute("_SYS_Bee_subEntityFirstAnnotationField");
            if (subField[1] != null) {
                subEntityFieldNum = 2;
                oneHasOne = true;
                moreTableStruct[0].oneHasOne = true;
            }
        }
        if (subField[1] != null) {
            String errorMsg;
            joinTable[1] = subField[1].getAnnotation(JoinTable.class);
            if (oneHasOne && List.class.isAssignableFrom(subField[1].getType())) {
                subTwoIsList = true;
            }
            if (!"".equals(errorMsg = HoneyUtil.checkJoinTable(joinTable[1]))) {
                throw new JoinTableParameterException("Annotation JoinTable, error: mainField and subField can not just use only one." + errorMsg);
            }
            if (subTwoIsList && joinTable[1].joinType() == JoinType.RIGHT_JOIN) {
                throw new JoinTableException("The List type subTable donot support JoinType.RIGHT_JOIN, you can adjust with JoinType.LEFT_JOIN.");
            }
        }
        moreTableStruct[0].tableName = tableName;
        moreTableStruct[0].joinTableNum = subEntityFieldNum;
        for (int j = 0; j < 2; ++j) {
            String useSubTableName2;
            if (subField[j] == null) continue;
            if (j == 1) {
                if (oneHasOne && subTwoIsList) {
                    try {
                        subField[1].setAccessible(true);
                        moreTableStruct[0].subTwoIsList = true;
                        List list = null;
                        if (moreTableStruct[1].subObject != null) {
                            list = (List)subField[1].get(moreTableStruct[1].subObject);
                        }
                        if (ObjectUtils.isNotEmpty(list)) {
                            listTwo = list;
                            list_T_classTwo = list.get(0).getClass();
                        }
                    }
                    catch (IllegalAccessException e) {
                        Logger.warn(e.getMessage());
                    }
                }
                if (subTwoIsList && list_T_classTwo == null) {
                    Class<?> c = joinTable[1].subClazz();
                    if (!c.equals(Object.class)) {
                        list_T_classTwo = c;
                    } else {
                        String subClassStr = joinTable[1].subClass();
                        list_T_classTwo = HoneyUtil.createClass(subClassStr, entityFullName);
                    }
                }
            }
            String mainColumn = HoneyUtil._toColumnName(joinTable[j].mainField());
            String subColumn = HoneyUtil._toColumnName(joinTable[j].subField());
            subTableName[j] = j == 0 && subOneIsList ? HoneyUtil._toTableNameByEntityName(list_T_classOne.getName()) : (j == 1 && subTwoIsList ? HoneyUtil._toTableNameByEntityName(list_T_classTwo.getName()) : HoneyUtil._toTableNameByEntityName(subField[j].getType().getName()));
            moreTableStruct[1 + j] = new MoreTableStruct();
            moreTableStruct[1 + j].subEntityField = subField[j];
            moreTableStruct[1 + j].tableName = subTableName[j];
            moreTableStruct[1 + j].mainField = joinTable[j].mainField();
            moreTableStruct[1 + j].subField = joinTable[j].subField();
            moreTableStruct[1 + j].joinType = joinTable[j].joinType();
            String t_subAlias2 = joinTable[j].subAlias();
            if (t_subAlias2 != null && !"".equals(t_subAlias2)) {
                moreTableStruct[1 + j].subAlias = t_subAlias2;
                useSubTableName2 = t_subAlias2;
                moreTableStruct[1 + j].hasSubAlias = true;
            } else {
                useSubTableName2 = subTableName[j];
            }
            if (!"".equals(mainColumn) && !"".equals(subColumn)) {
                String[] subColumnArray;
                String[] mainColumnArray = mainColumn.split(",");
                if (mainColumnArray.length != (subColumnArray = subColumn.split(",")).length) {
                    throw new JoinTableException("The number of field in mainField & subField is different , mainField is: " + mainColumnArray.length + " ,subField is : " + subColumnArray.length);
                }
                moreTableStruct[1 + j].joinExpression = "";
                String firstTableName = "";
                for (int i = 0; i < mainColumnArray.length; ++i) {
                    if (i != 0) {
                        moreTableStruct[1 + j].joinExpression = moreTableStruct[1 + j].joinExpression + K.space + K.and + K.space;
                    }
                    firstTableName = oneHasOne && j == 1 ? moreTableStruct[1].useSubTableName : tableName;
                    moreTableStruct[1 + j].joinExpression = moreTableStruct[1 + j].joinExpression + firstTableName + "." + mainColumnArray[i] + "=" + useSubTableName2 + "." + subColumnArray[i];
                }
            }
            moreTableStruct[1 + j].useSubTableName = useSubTableName2;
            try {
                subField[j].setAccessible(true);
                if (j == 0 && subOneIsList) {
                    if (ObjectUtils.isNotEmpty(listOne)) {
                        moreTableStruct[1 + j].subObject = listOne.get(0);
                    }
                } else if (j == 1 && subTwoIsList) {
                    if (ObjectUtils.isNotEmpty(listTwo)) {
                        moreTableStruct[1 + j].subObject = listTwo.get(0);
                    }
                } else {
                    moreTableStruct[1 + j].subObject = j == 1 && oneHasOne ? (moreTableStruct[1].subObject == null ? null : subField[j].get(moreTableStruct[1].subObject)) : subField[j].get(entity);
                }
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
            if (subEntityFieldNum != 1) {
                if (j == 0 && subOneIsList && !oneHasOne) {
                    subColumnStringBuffer[0] = HoneyUtil._getBeanFullField_0(list_T_classOne, useSubTableName2, entityFullName, mainFieldSet, dulMap, true);
                } else if (j == 1 && subTwoIsList) {
                    subColumnStringBuffer[1] = HoneyUtil._getBeanFullField_0(list_T_classTwo, useSubTableName2, entityFullName, mainFieldSet, dulMap, true);
                } else if (!oneHasOne || j == 1) {
                    subColumnStringBuffer[j] = HoneyUtil._getBeanFullField_0(subField[j].getType(), useSubTableName2, entityFullName, mainFieldSet, dulMap);
                }
            }
            moreTableStruct[1 + j].columnsFull = subColumnStringBuffer[j].toString();
            columns.append(",");
            columns.append(subColumnStringBuffer[j]);
        }
        if (subOneIsList) {
            moreTableStruct[1].subClass = list_T_classOne;
        }
        if (subTwoIsList) {
            moreTableStruct[2].subClass = list_T_classTwo;
        }
        moreTableStruct[0].columnsFull = columns.toString();
        moreTableStruct[0].subDulFieldMap = dulMap;
        return moreTableStruct;
    }

    private static Class createClass(String subClassStr, String packageAndClassName) {
        Class<?> newClazz = null;
        boolean isOk = false;
        if (StringUtils.isNotBlank(subClassStr)) {
            try {
                newClazz = Class.forName(subClassStr);
                isOk = true;
            }
            catch (ClassNotFoundException e) {
                try {
                    int index1 = subClassStr.indexOf(46);
                    int index2 = packageAndClassName.lastIndexOf(46);
                    if (index1 == -1 && index2 > 0) {
                        String newStr = packageAndClassName.substring(0, index2 + 1) + subClassStr;
                        newClazz = Class.forName(newStr);
                        isOk = true;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (isOk) {
            return newClazz;
        }
        throw new BeeException("MoreTable select, if use List type subEntity field , the object must have element or config the subClass with JoinTable Annotation!");
    }

    static StringBuffer _getBeanFullField_0(Class entityClass, String tableName, String entityFullName, Set<String> mainFieldSet, Map<String, String> dulMap) {
        return HoneyUtil._getBeanFullField_0(entityClass, tableName, entityFullName, mainFieldSet, dulMap, false);
    }

    static StringBuffer _getBeanFullField_0(Class entityClass, String tableName, String entityFullName, Set<String> mainFieldSet, Map<String, String> dulMap, boolean checkOneHasOne) {
        int i;
        Field[] field = entityClass.getDeclaredFields();
        String entityFieldFullName = entityClass.getName();
        StringBuffer columns = new StringBuffer();
        int len = field.length;
        boolean isFirst = true;
        String subColumnName = "";
        int currentSubNum = 0;
        Field subEntityFirstAnnotationField = null;
        ArrayList<String> WarnMsglist = new ArrayList<String>();
        for (i = 0; i < len; ++i) {
            if (HoneyUtil.isSkipFieldForMoreTable(field[i])) continue;
            if (field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) {
                if (checkOneHasOne && ++currentSubNum == 1) {
                    subEntityFirstAnnotationField = field[i];
                }
                if (checkOneHasOne) {
                    WarnMsglist.add("Annotation JoinTable field: " + entityFieldFullName + "(in " + entityFullName + ") still include JoinTable field:" + field[i].getName() + "(will be ignored)!");
                    continue;
                }
                if (entityClass.equals(field[i].getType())) continue;
                Logger.warn("Annotation JoinTable field: " + entityFieldFullName + "(in " + entityFullName + ") still include JoinTable field:" + field[i].getName() + "(will be ignored)!");
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                columns.append(",");
            }
            subColumnName = NameTranslateHandle.toColumnName(field[i].getName(), entityClass);
            if (field[i].isAnnotationPresent(JustFetch.class)) {
                columns.append(HoneyUtil.getJustFetchDefineName(field[i]));
            } else {
                columns.append(tableName);
                columns.append(".");
                columns.append(subColumnName);
            }
            if (mainFieldSet.add(subColumnName) || !HoneyUtil.isConfuseDuplicateFieldDB()) continue;
            if (HoneyUtil.isSQLite()) {
                dulMap.put(tableName + "." + subColumnName, tableName + "." + subColumnName);
            } else {
                dulMap.put(tableName + "." + subColumnName, tableName + "_" + subColumnName + "_$");
            }
            if (HoneyUtil.isSQLite()) {
                columns.append(" " + K.as + " '" + tableName + "." + subColumnName + "'");
                continue;
            }
            columns.append(" " + tableName + "_" + subColumnName + "_$");
        }
        if (checkOneHasOne && currentSubNum > 1) {
            subEntityFirstAnnotationField = null;
            for (i = 0; i < currentSubNum; ++i) {
                Logger.warn((String)WarnMsglist.get(i));
            }
        }
        if (checkOneHasOne && currentSubNum > 2) {
            throw new JoinTableException("One entity only supports two JoinTable at most! " + entityFieldFullName + " has " + currentSubNum + " JoinTable now !");
        }
        OneTimeParameter.setAttribute("_SYS_Bee_subEntityFirstAnnotationField", subEntityFirstAnnotationField);
        return columns;
    }

    public static String getFieldType(String jdbcType) {
        String javaType = jdbcTypeMap.get(jdbcType);
        if (javaType != null) {
            return javaType;
        }
        if (null == jdbcTypeMap.get(jdbcType)) {
            int i;
            String tempType = jdbcType.trim();
            if (tempType.endsWith(" UNSIGNED") && (javaType = jdbcTypeMap.get(tempType.substring(0, i = tempType.indexOf(" ")))) != null) {
                return javaType;
            }
            if (javaType == null) {
                javaType = jdbcTypeMap.get(jdbcType.toLowerCase());
                if (javaType != null) {
                    return javaType;
                }
                if (javaType == null && (javaType = jdbcTypeMap.get(jdbcType.toUpperCase())) != null) {
                    return javaType;
                }
            }
            javaType = "[UNKNOWN TYPE]" + jdbcType;
        }
        return javaType;
    }

    private static void initJdbcTypeMap() {
        jdbcTypeMap.put("CHAR", STRING);
        jdbcTypeMap.put("VARCHAR", STRING);
        jdbcTypeMap.put("LONGVARCHAR", STRING);
        jdbcTypeMap.put("NVARCHAR", STRING);
        jdbcTypeMap.put("NCHAR", STRING);
        jdbcTypeMap.put("NUMERIC", "BigDecimal");
        jdbcTypeMap.put("DECIMAL", "BigDecimal");
        jdbcTypeMap.put("BIT", "Boolean");
        jdbcTypeMap.put("TINYINT", "Byte");
        jdbcTypeMap.put("SMALLINT", "Short");
        jdbcTypeMap.put("INT", "Integer");
        jdbcTypeMap.put("INTEGER", "Integer");
        jdbcTypeMap.put("BIGINT", "Long");
        jdbcTypeMap.put("REAL", "Float");
        jdbcTypeMap.put("FLOAT", "Float");
        jdbcTypeMap.put("DOUBLE", "Double");
        jdbcTypeMap.put("BINARY", "byte[]");
        jdbcTypeMap.put("VARBINARY", "byte[]");
        jdbcTypeMap.put("LONGVARBINARY", "byte[]");
        jdbcTypeMap.put("image", "byte[]");
        jdbcTypeMap.put("DATE", "Date");
        jdbcTypeMap.put("TIME", "Time");
        jdbcTypeMap.put("TIMESTAMP", "Timestamp");
        jdbcTypeMap.put("CLOB", "Clob");
        jdbcTypeMap.put("BLOB", "Blob");
        jdbcTypeMap.put("ARRAY", "Array");
        jdbcTypeMap.put("NCLOB", "java.sql.NClob");
        jdbcTypeMap.put("ROWID", "java.sql.RowId");
        jdbcTypeMap.put("SQLXML", "java.sql.SQLXML");
        jdbcTypeMap.put("TIMESTAMP_WITH_TIMEZONE", "Timestamp");
        jdbcTypeMap.put("TIMESTAMP WITH TIME ZONE", "Timestamp");
        jdbcTypeMap.put("TIMESTAMP WITH LOCAL TIME ZONE", "Timestamp");
        jdbcTypeMap.put("JSON", STRING);
        jdbcTypeMap.put("TEXT", STRING);
        jdbcTypeMap.put("LONGTEXT", STRING);
        jdbcTypeMap.put("TINYTEXT", STRING);
        jdbcTypeMap.put("MEDIUMTEXT", STRING);
        String dbName = HoneyConfig.getHoneyConfig().getDbName();
        if ("MySQL".equalsIgnoreCase(dbName) || "MariaDB".equalsIgnoreCase(dbName)) {
            jdbcTypeMap.put("MEDIUMINT", "Integer");
            jdbcTypeMap.put("DATETIME", "Timestamp");
            jdbcTypeMap.put("TINYBLOB", "Blob");
            jdbcTypeMap.put("MEDIUMBLOB", "Blob");
            jdbcTypeMap.put("LONGBLOB", "Blob");
            jdbcTypeMap.put("YEAR", "Integer");
            jdbcTypeMap.put("TINYINT", "Byte");
            jdbcTypeMap.put("SMALLINT", "Short");
            jdbcTypeMap.put("TINYINT UNSIGNED", "Short");
            jdbcTypeMap.put("SMALLINT UNSIGNED", "Integer");
            jdbcTypeMap.put("INT UNSIGNED", "Long");
            jdbcTypeMap.put("BIGINT UNSIGNED", "BigInteger");
        } else if ("Oracle".equalsIgnoreCase(dbName)) {
            jdbcTypeMap.put("LONG", STRING);
            jdbcTypeMap.put("VARCHAR2", STRING);
            jdbcTypeMap.put("NVARCHAR2", STRING);
            jdbcTypeMap.put("NUMBER", "BigDecimal");
            jdbcTypeMap.put("RAW", "byte[]");
            jdbcTypeMap.put("INTERVALYM", STRING);
            jdbcTypeMap.put("INTERVALDS", STRING);
            jdbcTypeMap.put("INTERVAL YEAR TO MONTH", STRING);
            jdbcTypeMap.put("INTERVAL DAY TO SECOND", STRING);
        } else if ("Microsoft SQL Server".equalsIgnoreCase(dbName)) {
            jdbcTypeMap.put("TINYINT", "Short");
            jdbcTypeMap.put("DATETIMEOFFSET", "microsoft.sql.DateTimeOffset");
            jdbcTypeMap.put("microsoft.sql.Types.DATETIMEOFFSET", "microsoft.sql.DateTimeOffset");
            jdbcTypeMap.put("datetime", "Timestamp");
            jdbcTypeMap.put("money", "BigDecimal");
            jdbcTypeMap.put("smallmoney", "BigDecimal");
            jdbcTypeMap.put("ntext", STRING);
            jdbcTypeMap.put("text", STRING);
            jdbcTypeMap.put("xml", STRING);
            jdbcTypeMap.put("smalldatetime", "Timestamp");
            jdbcTypeMap.put("uniqueidentifier", STRING);
            jdbcTypeMap.put("hierarchyid", "byte[]");
            jdbcTypeMap.put("image", "byte[]");
        } else if ("PostgreSQL".equalsIgnoreCase(dbName)) {
            jdbcTypeMap.put("bigint", "Long");
            jdbcTypeMap.put("int8", "Long");
            jdbcTypeMap.put("bigserial", "Long");
            jdbcTypeMap.put("serial8", "Long");
            jdbcTypeMap.put("integer", "Integer");
            jdbcTypeMap.put("int", "Integer");
            jdbcTypeMap.put("int4", "Integer");
            jdbcTypeMap.put("serial", "Integer");
            jdbcTypeMap.put("serial4", "Integer");
            jdbcTypeMap.put("smallint", "Short");
            jdbcTypeMap.put("int2", "Short");
            jdbcTypeMap.put("smallserial", "Short");
            jdbcTypeMap.put("serial2", "Short");
            jdbcTypeMap.put("money", "BigDecimal");
            jdbcTypeMap.put("numeric", "BigDecimal");
            jdbcTypeMap.put("decimal", "BigDecimal");
            jdbcTypeMap.put("bit", STRING);
            jdbcTypeMap.put("bit varying", STRING);
            jdbcTypeMap.put("varbit", STRING);
            jdbcTypeMap.put("character", STRING);
            jdbcTypeMap.put("char", STRING);
            jdbcTypeMap.put("character varying", STRING);
            jdbcTypeMap.put("varchar", STRING);
            jdbcTypeMap.put("text", STRING);
            jdbcTypeMap.put("bpchar", STRING);
            jdbcTypeMap.put("boolean", "Boolean");
            jdbcTypeMap.put("bool", "Boolean");
            jdbcTypeMap.put("double precision", "Double");
            jdbcTypeMap.put("float8", "Double");
            jdbcTypeMap.put("real", "Float");
            jdbcTypeMap.put("float4", "Float");
            jdbcTypeMap.put("json", STRING);
            jdbcTypeMap.put("bytea", "byte[]");
            jdbcTypeMap.put("date", "Date");
            jdbcTypeMap.put("time", "Time");
            jdbcTypeMap.put("timestamp", "Timestamp");
            jdbcTypeMap.put("time without time zone", "Time");
            jdbcTypeMap.put("timetz", "Time");
            jdbcTypeMap.put("timestamp without time zone", "Timestamp");
            jdbcTypeMap.put("timestamptz", "Timestamp");
        } else if ("H2".equalsIgnoreCase(dbName) || "SQLite".equalsIgnoreCase(dbName)) {
            jdbcTypeMap.put("MEDIUMINT", "Integer");
            jdbcTypeMap.put("INT4", "Integer");
            jdbcTypeMap.put("INT2", "Short");
            jdbcTypeMap.put("INT8", "Long");
            jdbcTypeMap.put("NUMBER", "BigDecimal");
            jdbcTypeMap.put("NUMERIC", "BigDecimal");
            jdbcTypeMap.put("BOOLEAN", "Boolean");
            jdbcTypeMap.put("BOOL", "Boolean");
            jdbcTypeMap.put("BIT", "Boolean");
            jdbcTypeMap.put("FLOAT8", "Double");
            jdbcTypeMap.put("FLOAT4 ", "Float");
            jdbcTypeMap.put("CHARACTER", STRING);
            jdbcTypeMap.put("VARCHAR2", STRING);
            jdbcTypeMap.put("NVARCHAR2", STRING);
            jdbcTypeMap.put("VARCHAR_IGNORECASE", STRING);
        }
        if ("H2".equalsIgnoreCase(dbName)) {
            jdbcTypeMap.put("SIGNED", "Integer");
            jdbcTypeMap.put("DEC", "BigDecimal");
            jdbcTypeMap.put("YEAR", "Byte");
            jdbcTypeMap.put("BINARY VARYING", "byte[]");
            jdbcTypeMap.put("WITHOUT TIME ZONE", "Time");
            jdbcTypeMap.put("BINARY LARGE OBJECT", "Blob");
            jdbcTypeMap.put("CHARACTER LARGE OBJECT", "Clob");
            jdbcTypeMap.put("CHARACTER VARYING", STRING);
            jdbcTypeMap.put("VARCHAR_CASESENSITIVE", STRING);
            jdbcTypeMap.put("VARCHAR_IGNORECASE", STRING);
        } else if ("SQLite".equalsIgnoreCase(dbName)) {
            jdbcTypeMap.put("VARYING CHARACTER", STRING);
            jdbcTypeMap.put("NATIVE CHARACTER", STRING);
            jdbcTypeMap.put("TEXT", STRING);
            jdbcTypeMap.put("DOUBLE PRECISION", "Double");
            jdbcTypeMap.put("DATETIME", STRING);
            jdbcTypeMap.put("INTEGER", "Long");
            jdbcTypeMap.put("UNSIGNED BIG INT", "Long");
            jdbcTypeMap.put("VARYING", STRING);
        }
        if ("Cassandra".equalsIgnoreCase(dbName)) {
            jdbcTypeMap.put("ascii", STRING);
            jdbcTypeMap.put("inet", STRING);
            jdbcTypeMap.put("timeuuid", "java.util.UUID");
            jdbcTypeMap.put("uuid", "java.util.UUID");
            jdbcTypeMap.put("boolean", "Boolean");
            jdbcTypeMap.put("varint", "Integer");
            jdbcTypeMap.put("list", "List");
            jdbcTypeMap.put("set", "Set");
            jdbcTypeMap.put("map", "Map");
        }
    }

    private static void appendJdbcTypeCustomProp() {
        for (String s : jdbcTypeCustomProp.getKeys()) {
            jdbcTypeMap.put(s, jdbcTypeCustomProp.getValue(s));
        }
    }

    private static void appendJdbcTypeCustomProp_specificalDB() {
        for (String s : jdbcTypeCustomProp_specificalDB.getKeys()) {
            jdbcTypeMap.put(s, jdbcTypeCustomProp_specificalDB.getValue(s));
        }
    }

    private static void initJavaTypeMap() {
        javaTypeMap.put("java.lang.String", 1);
        javaTypeMap.put("java.lang.Integer", 2);
        javaTypeMap.put("java.lang.Long", 3);
        javaTypeMap.put("java.lang.Double", 4);
        javaTypeMap.put("java.lang.Float", 5);
        javaTypeMap.put("java.lang.Short", 6);
        javaTypeMap.put("java.lang.Byte", 7);
        javaTypeMap.put("[B", 8);
        javaTypeMap.put("java.lang.Boolean", 9);
        javaTypeMap.put("int", 2);
        javaTypeMap.put("long", 3);
        javaTypeMap.put("double", 4);
        javaTypeMap.put("float", 5);
        javaTypeMap.put("short", 6);
        javaTypeMap.put("byte", 7);
        javaTypeMap.put("boolean", 9);
        javaTypeMap.put("java.math.BigDecimal", 10);
        javaTypeMap.put("java.sql.Date", 11);
        javaTypeMap.put("java.sql.Time", 12);
        javaTypeMap.put("java.sql.Timestamp", 13);
        if (HoneyUtil.isSQLite()) {
            TypeHandlerRegistry.register(Timestamp.class, new TimestampTypeHandler(), "SQLite");
        }
        javaTypeMap.put("java.sql.Blob", 14);
        javaTypeMap.put("java.sql.Clob", 15);
        javaTypeMap.put("java.sql.NClob", 16);
        javaTypeMap.put("java.sql.RowId", 17);
        javaTypeMap.put("java.sql.SQLXML", 18);
        javaTypeMap.put("java.math.BigInteger", 19);
        javaTypeMap.put("char", 20);
        javaTypeMap.put("java.util.Date", 21);
        javaTypeMap.put("java.sql.Array", 22);
        javaTypeMap.put("java.io.InputStream", 23);
        javaTypeMap.put("java.io.Reader", 24);
        javaTypeMap.put("java.sql.Ref", 25);
        javaTypeMap.put("java.net.URL", 27);
    }

    public static int getJavaTypeIndex(String javaType) {
        return javaTypeMap.get(javaType) == null ? -1 : javaTypeMap.get(javaType);
    }

    public static String firstLetterToUpperCase(String str) {
        return NameUtil.firstLetterToUpperCase(str);
    }

    static boolean isContinue(int includeType, Object object, Field field) {
        if (field != null) {
            if (HoneyUtil.isSkipField(field)) {
                return true;
            }
            if (HoneyUtil.isSkipFieldJustFetch(field)) {
                return true;
            }
        }
        if (-3 == includeType && StringUtils.isBlank((String)object)) {
            return true;
        }
        return (includeType == -1 || includeType == 1) && object == null || (includeType == -1 || includeType == 0) && "".equals(object);
    }

    public static boolean isSkipField(Field field) {
        if (field != null) {
            if ("serialVersionUID".equals(field.getName())) {
                return true;
            }
            if (field.isAnnotationPresent(Ignore.class)) {
                return true;
            }
            if (field.isAnnotationPresent(JoinTable.class)) {
                return true;
            }
            if (field.isSynthetic()) {
                return true;
            }
        }
        return false;
    }

    static boolean isSkipFieldForMoreTable(Field field) {
        if (field != null) {
            if ("serialVersionUID".equals(field.getName())) {
                return true;
            }
            if (field.isAnnotationPresent(Ignore.class)) {
                return true;
            }
            if (field.isSynthetic()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSkipFieldJustFetch(Field field) {
        return field != null && field.isAnnotationPresent(JustFetch.class);
    }

    static void setPreparedValues(PreparedStatement pst, int objTypeIndex, int i, Object value) throws SQLException {
        if (null == value) {
            HoneyUtil.setPreparedNull(pst, objTypeIndex, i);
            return;
        }
        switch (objTypeIndex) {
            case 1: {
                pst.setString(i + 1, (String)value);
                break;
            }
            case 2: {
                pst.setInt(i + 1, (Integer)value);
                break;
            }
            case 3: {
                pst.setLong(i + 1, (Long)value);
                break;
            }
            case 4: {
                pst.setDouble(i + 1, (Double)value);
                break;
            }
            case 5: {
                pst.setFloat(i + 1, ((Float)value).floatValue());
                break;
            }
            case 6: {
                pst.setShort(i + 1, (Short)value);
                break;
            }
            case 7: {
                pst.setByte(i + 1, (Byte)value);
                break;
            }
            case 8: {
                pst.setBytes(i + 1, (byte[])value);
                break;
            }
            case 9: {
                pst.setBoolean(i + 1, (Boolean)value);
                break;
            }
            case 10: {
                pst.setBigDecimal(i + 1, (BigDecimal)value);
                break;
            }
            case 12: {
                pst.setTime(i + 1, (Time)value);
                break;
            }
            case 13: {
                pst.setTimestamp(i + 1, (Timestamp)value);
                break;
            }
            case 17: {
                pst.setRowId(i + 1, (RowId)value);
                break;
            }
            case 18: {
                pst.setSQLXML(i + 1, (SQLXML)value);
                break;
            }
            case 20: {
                pst.setString(i + 1, value.toString());
                break;
            }
            case 22: {
                pst.setArray(i + 1, (Array)value);
                break;
            }
            case 25: {
                pst.setRef(i + 1, (Ref)value);
                break;
            }
            case 26: {
                SetParaTypeConvert<Json> converter = SetParaTypeConverterRegistry.getConverter(Json.class);
                if (converter != null) {
                    pst.setString(i + 1, (String)converter.convert(value));
                    break;
                }
            }
            case 27: {
                pst.setURL(i + 1, (URL)value);
                break;
            }
            default: {
                SetParaTypeConvert<?> converter = SetParaTypeConverterRegistry.getConverter(value.getClass());
                if (converter != null) {
                    value = converter.convert(value);
                    pst.setObject(i + 1, value);
                    break;
                }
                if (objTypeIndex == 11) {
                    pst.setDate(i + 1, (Date)value);
                    break;
                }
                if (objTypeIndex == 14) {
                    pst.setBlob(i + 1, (Blob)value);
                    break;
                }
                if (objTypeIndex == 15) {
                    pst.setClob(i + 1, (Clob)value);
                    break;
                }
                if (objTypeIndex == 16) {
                    pst.setNClob(i + 1, (NClob)value);
                    break;
                }
                if (objTypeIndex == 23) {
                    pst.setBinaryStream(i + 1, (InputStream)value);
                    break;
                }
                if (objTypeIndex == 24) {
                    pst.setCharacterStream(i + 1, (Reader)value);
                    break;
                }
                pst.setObject(i + 1, value);
            }
        }
    }

    static Object getResultObject(ResultSet rs, String typeName, String columnName) throws SQLException {
        int k = HoneyUtil.getJavaTypeIndex(typeName);
        if (HoneyUtil.isSQLite() && "java.sql.Timestamp".equals(typeName)) {
            k = 1;
        }
        switch (k) {
            case 1: {
                return rs.getString(columnName);
            }
            case 2: {
                return rs.getInt(columnName);
            }
            case 3: {
                return rs.getLong(columnName);
            }
            case 4: {
                return rs.getDouble(columnName);
            }
            case 5: {
                return Float.valueOf(rs.getFloat(columnName));
            }
            case 6: {
                return rs.getShort(columnName);
            }
            case 7: {
                return rs.getByte(columnName);
            }
            case 8: {
                return rs.getBytes(columnName);
            }
            case 9: {
                return rs.getBoolean(columnName);
            }
            case 10: {
                return rs.getBigDecimal(columnName);
            }
            case 11: {
                return rs.getDate(columnName);
            }
            case 12: {
                return rs.getTime(columnName);
            }
            case 13: {
                return rs.getTimestamp(columnName);
            }
            case 14: {
                return rs.getBlob(columnName);
            }
            case 15: {
                return rs.getClob(columnName);
            }
            case 16: {
                return rs.getNClob(columnName);
            }
            case 17: {
                return rs.getRowId(columnName);
            }
            case 18: {
                return rs.getSQLXML(columnName);
            }
            case 21: {
                return rs.getTimestamp(columnName);
            }
            case 22: {
                return rs.getArray(columnName);
            }
            case 23: {
                return rs.getBinaryStream(columnName);
            }
            case 24: {
                return rs.getCharacterStream(columnName);
            }
            case 25: {
                return rs.getRef(columnName);
            }
            case 27: {
                return rs.getURL(columnName);
            }
        }
        return rs.getObject(columnName);
    }

    static Object getResultObjectByIndex(ResultSet rs, String typeName, int index) throws SQLException {
        int k = HoneyUtil.getJavaTypeIndex(typeName);
        if (HoneyUtil.isSQLite() && "java.sql.Timestamp".equals(typeName)) {
            k = 1;
        }
        switch (k) {
            case 1: {
                return rs.getString(index);
            }
            case 2: {
                return rs.getInt(index);
            }
            case 3: {
                return rs.getLong(index);
            }
            case 4: {
                return rs.getDouble(index);
            }
            case 5: {
                return Float.valueOf(rs.getFloat(index));
            }
            case 6: {
                return rs.getShort(index);
            }
            case 7: {
                return rs.getByte(index);
            }
            case 8: {
                return rs.getBytes(index);
            }
            case 9: {
                return rs.getBoolean(index);
            }
            case 10: {
                return rs.getBigDecimal(index);
            }
            case 11: {
                return rs.getDate(index);
            }
            case 12: {
                return rs.getTime(index);
            }
            case 13: {
                return rs.getTimestamp(index);
            }
            case 14: {
                return rs.getBlob(index);
            }
            case 15: {
                return rs.getClob(index);
            }
            case 16: {
                return rs.getNClob(index);
            }
            case 17: {
                return rs.getRowId(index);
            }
            case 18: {
                return rs.getSQLXML(index);
            }
            case 21: {
                return rs.getTimestamp(index);
            }
            case 22: {
                return rs.getArray(index);
            }
            case 23: {
                return rs.getBinaryStream(index);
            }
            case 24: {
                return rs.getCharacterStream(index);
            }
            case 25: {
                return rs.getRef(index);
            }
            case 27: {
                return rs.getURL(index);
            }
        }
        return rs.getObject(index);
    }

    public static void setPreparedNull(PreparedStatement pst, int objTypeIndex, int i) throws SQLException {
        pst.setNull(i + 1, 0);
    }

    public static String genSerializableNum() {
        String s = Math.random() + "";
        int end = s.length() > 12 ? 12 : s.length();
        return "159" + s.substring(2, end) + "L";
    }

    public static String deleteLastSemicolon(String sql) {
        String new_sql = sql.trim();
        if (new_sql.endsWith(";")) {
            return new_sql.substring(0, new_sql.length() - 1);
        }
        return sql;
    }

    public static <T> void checkPackage(T entity) {
        if (entity == null) {
            return;
        }
        String classFullName = entity.getClass().getName();
        if (classFullName.startsWith("java.") || classFullName.startsWith("javax.")) {
            throw new BeeIllegalEntityException("BeeIllegalEntityException: Illegal Entity, " + entity.getClass().getName());
        }
    }

    public static <T> Map<String, Object> getColumnMapByEntity(T entity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        try {
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (fields[i].get(entity) == null || HoneyUtil.isSkipField(fields[i])) continue;
                map.put(NameTranslateHandle.toColumnName(fields[i].getName(), entity.getClass()), fields[i].get(entity));
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return map;
    }

    public static String list2Value(List<PreparedValue> list, boolean needType) {
        StringBuffer b = new StringBuffer();
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return "";
        }
        String type = "";
        int size = list.size();
        Object value = null;
        for (int j = 0; j < size; ++j) {
            SetParaTypeConvert<Json> converter;
            value = list.get(j).getValue();
            Field f = list.get(j).getField();
            if (f != null && (converter = SetParaTypeConverterRegistry.getConverter(Json.class)) != null) {
                value = converter.convert(value);
            }
            b.append(value);
            type = list.get(j).getType();
            if (needType && type != null) {
                b.append("(");
                if (type.startsWith("java.lang.")) {
                    b.append(type.substring(10));
                } else {
                    b.append(type);
                }
                b.append(")");
            }
            if (j == size - 1) continue;
            b.append(",");
        }
        return b.toString();
    }

    public static String getExecutableSql(String sql, List<PreparedValue> list) {
        if (list == null || list.size() == 0) {
            return sql;
        }
        int size = list.size();
        Object value = null;
        for (int j = 0; j < size; ++j) {
            SetParaTypeConvert<Json> converter;
            value = list.get(j).getValue();
            Field f = list.get(j).getField();
            if (f != null && (converter = SetParaTypeConverterRegistry.getConverter(Json.class)) != null) {
                value = converter.convert(value);
            }
            sql = value != null && value instanceof CharSequence ? sql.replaceFirst("\\?", "'" + String.valueOf(value).replace("$", "\\$") + "'") : sql.replaceFirst("\\?", String.valueOf(value));
        }
        return sql;
    }

    static <T> String checkAndProcessSelectField(T entity, String ... fieldList) {
        if (fieldList == null) {
            return null;
        }
        String packageAndClassName = entity.getClass().getName();
        String columnsdNames = HoneyContext.getBeanField(packageAndClassName);
        if (columnsdNames == null) {
            Field[] fields = entity.getClass().getDeclaredFields();
            columnsdNames = HoneyUtil.getBeanField(fields, entity.getClass());
            HoneyContext.addBeanField(packageAndClassName, columnsdNames);
        }
        return HoneyUtil.checkAndProcessSelectFieldViaString(columnsdNames, null, fieldList);
    }

    static String checkAndProcessSelectFieldViaString(String columnsdNames, Map<String, String> subDulFieldMap, String ... fields) {
        if (fields == null) {
            return null;
        }
        columnsdNames = columnsdNames.toLowerCase();
        String errorField = "";
        boolean isFirstError = true;
        String[] selectFields = fields.length == 1 ? fields[0].split(",") : fields;
        String newSelectFields = "";
        boolean isFisrt = true;
        for (String s : selectFields) {
            String newField;
            String colName = HoneyUtil._toColumnName(s);
            String checkColName = colName.toLowerCase();
            if (!(columnsdNames.contains("," + checkColName + ",") || columnsdNames.startsWith(checkColName + ",") || columnsdNames.endsWith("," + checkColName) || columnsdNames.equals(checkColName) || columnsdNames.contains("." + checkColName + ",") || columnsdNames.endsWith("." + checkColName) || columnsdNames.contains("," + checkColName + " ") || columnsdNames.startsWith(checkColName + " ") || columnsdNames.contains("." + checkColName + " "))) {
                if (isFirstError) {
                    errorField = errorField + s;
                    isFirstError = false;
                } else {
                    errorField = errorField + "," + s;
                }
            }
            if ((newField = subDulFieldMap == null ? null : subDulFieldMap.get(colName)) != null) {
                colName = HoneyUtil.isSQLite() ? colName + "  " + K.as + " '" + newField + "'" : colName + " " + newField;
            }
            if (isFisrt) {
                newSelectFields = newSelectFields + colName;
                isFisrt = false;
                continue;
            }
            newSelectFields = newSelectFields + ", " + colName;
        }
        if (!"".equals(errorField)) {
            throw new BeeErrorFieldException("ErrorField: " + errorField);
        }
        if ("".equals(newSelectFields.trim())) {
            return null;
        }
        return newSelectFields;
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toTableNameByEntityName(String entityName) {
        return NameTranslateHandle.toTableName(entityName);
    }

    private static String checkJoinTable(JoinTable joinTable) {
        String mainField = joinTable.mainField();
        String subField = joinTable.subField();
        String subAlias = joinTable.subAlias();
        String subClass = joinTable.subClass();
        if (NameCheckUtil.isIllegal(mainField)) {
            throw new JoinTableParameterException(SET_WRONG_VALUE_IN + "mainField:" + mainField);
        }
        if (NameCheckUtil.isIllegal(subField)) {
            throw new JoinTableParameterException(SET_WRONG_VALUE_IN + "subField:" + subField);
        }
        if (NameCheckUtil.isIllegal(subAlias)) {
            throw new JoinTableParameterException(SET_WRONG_VALUE_IN + "subAlias:" + subAlias);
        }
        if (NameCheckUtil.isIllegal(subClass)) {
            throw new JoinTableParameterException(SET_WRONG_VALUE_IN + "subClass:" + subClass);
        }
        String errorMsg = "";
        int errorCount = 0;
        if (mainField == null) {
            errorMsg = "mainField is null! ";
            ++errorCount;
        } else if ("".equals(mainField.trim())) {
            errorMsg = errorMsg + "mainField is empty! ";
            ++errorCount;
        }
        if (subField == null) {
            errorMsg = errorMsg + "subField is null! ";
            ++errorCount;
        } else if ("".equals(subField.trim())) {
            errorMsg = errorMsg + "subField is empty! ";
            ++errorCount;
        }
        if (errorCount == 1) {
            return errorMsg;
        }
        return "";
    }

    public static boolean isMysql() {
        return "MySQL".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName()) || "MariaDB".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isConfuseDuplicateFieldDB() {
        return "Oracle".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName()) || "SQLite".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isSQLite() {
        return "SQLite".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isSqlServer() {
        return "Microsoft SQL Server".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isOracle() {
        return "Oracle".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isCassandra() {
        return "Cassandra".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isHbase() {
        return "Hbase".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isMongoDB() {
        return "MongoDB".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static void setPageNum(List<PreparedValue> list) {
        int[] array = (int[])OneTimeParameter.getAttribute("_SYS_Bee_Paing_NumArray");
        for (int i = 0; array != null && i < array.length; ++i) {
            PreparedValue p = new PreparedValue();
            p.setType("java.lang.Integer");
            p.setValue(array[i]);
            if (HoneyUtil.isSqlServer()) {
                list.add(0, p);
                continue;
            }
            list.add(p);
        }
    }

    public static boolean isRegPagePlaceholder() {
        return OneTimeParameter.isTrue("_SYS_Bee_Paing_Placeholder");
    }

    public static void regPagePlaceholder() {
        if (HoneyUtil.isSqlServer()) {
            return;
        }
        OneTimeParameter.setTrueForKey("_SYS_Bee_Paing_Placeholder");
    }

    public static void regPageNumArray(int[] array) {
        OneTimeParameter.setAttribute("_SYS_Bee_Paing_NumArray", array);
    }

    public static boolean isSqlKeyWordUpper() {
        String kwCase = HoneyConfig.getHoneyConfig().sqlKeyWordCase;
        return "upper".equalsIgnoreCase(kwCase);
    }

    public static <T> Object getIdValue(T entity) {
        Object obj;
        Field field;
        block11: {
            field = null;
            obj = null;
            try {
                field = entity.getClass().getDeclaredField("id");
            }
            catch (NoSuchFieldException e) {
                String pkName = HoneyUtil.getPkFieldName(entity);
                boolean hasException = false;
                if ("".equals(pkName)) {
                    hasException = true;
                } else if (pkName != null && !pkName.contains(",")) {
                    try {
                        field = entity.getClass().getDeclaredField(pkName);
                    }
                    catch (NoSuchFieldException e2) {
                        hasException = true;
                    }
                } else {
                    Logger.warn("Don't support return id value when the primary key more than one field!");
                }
                if (!hasException) break block11;
                throw new ObjSQLException("Miss id field: the entity no id field!");
            }
        }
        try {
            if (field != null) {
                field.setAccessible(true);
                obj = field.get(entity);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return obj;
    }

    public static <T> void revertId(T entity) {
        Field field = null;
        if (OneTimeParameter.isTrue("_SYS_Bee_OLD_ID_FOR_AUTO_ID_EXIST")) {
            try {
                Object obj = OneTimeParameter.getAttribute("_SYS_Bee_OLD_ID_FOR_AUTO_ID");
                String pkName = (String)OneTimeParameter.getAttribute("_SYS_Bee_PK_NAME");
                field = entity.getClass().getDeclaredField(pkName);
                field.setAccessible(true);
                field.set(entity, obj);
            }
            catch (NoSuchFieldException e) {
                throw new ObjSQLException("Miss id field: the entity no id field!");
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
        }
    }

    public static <T> void revertId(T[] entity) {
        Field field = null;
        String pkName = (String)OneTimeParameter.getAttribute("_SYS_Bee_PK_NAME");
        for (int i = 0; i < entity.length; ++i) {
            if (!OneTimeParameter.isTrue("_SYS_Bee_OLD_ID_FOR_AUTO_ID_EXIST" + i)) continue;
            try {
                Object obj = OneTimeParameter.getAttribute("_SYS_Bee_OLD_ID_FOR_AUTO_ID" + i);
                field = entity[i].getClass().getDeclaredField(pkName);
                field.setAccessible(true);
                field.set(entity[i], obj);
                continue;
            }
            catch (NoSuchFieldException e) {
                throw new ObjSQLException("entity[] miss id field: the element in entity[] no id field!");
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
        }
    }

    static <T> String getPkFieldName(T entity) {
        if (entity == null) {
            return null;
        }
        return HoneyUtil.getPkFieldNameByClass(entity.getClass());
    }

    static String getPkFieldNameByClass(Class c) {
        if (c == null) {
            return null;
        }
        String classFullName = c.getName();
        String pkey = HoneyContext.getBeanCustomPKey(classFullName);
        if (pkey != null) {
            return pkey;
        }
        Field[] field = c.getDeclaredFields();
        int len = field.length;
        boolean isFirst = true;
        pkey = "";
        for (int i = 0; i < len; ++i) {
            if (HoneyUtil.isSkipField(field[i]) || !field[i].isAnnotationPresent(PrimaryKey.class)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                pkey = pkey + ",";
            }
            pkey = pkey + field[i].getName();
        }
        HoneyContext.addBeanCustomPKey(classFullName, pkey);
        return pkey;
    }

    public static String getPlaceholderValue(int size) {
        StringBuffer placeholderValue = new StringBuffer(" (");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                placeholderValue.append(",");
            }
            placeholderValue.append("?");
        }
        if (size <= 0) {
            placeholderValue.append("''");
        }
        placeholderValue.append(")");
        return placeholderValue.toString();
    }

    static {
        HoneyUtil.initTypeMapConfig();
    }
}

