/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.MapSql;
import org.teasoft.bee.osql.MapSuid;
import org.teasoft.bee.osql.NameTranslate;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.interccept.InterceptorChain;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MapSqlProcessor;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.util.ObjectUtils;

public class MapSuidImpl
implements MapSuid {
    private BeeSql beeSql;
    private InterceptorChain interceptorChain;
    private String dsName;
    private NameTranslate nameTranslate;

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public InterceptorChain getInterceptorChain() {
        if (this.interceptorChain == null) {
            this.interceptorChain = BeeFactory.getHoneyFactory().getInterceptorChain();
        }
        return this.interceptorChain;
    }

    public void setInterceptorChain(InterceptorChain interceptorChain) {
        this.interceptorChain = interceptorChain;
    }

    public void setDataSourceName(String dsName) {
        this.dsName = dsName;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setNameTranslate(NameTranslate nameTranslate) {
        this.nameTranslate = nameTranslate;
    }

    public List<String[]> selectString(MapSql mapSql) {
        this.doBeforePasreEntity(SuidType.SELECT);
        String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("In MapSuid, select List<String[]> SQL: ", sql);
        List list = this.getBeeSql().select(sql);
        this.doBeforeReturn();
        return list;
    }

    public String selectJson(MapSql mapSql) {
        this.doBeforePasreEntity(SuidType.SELECT);
        String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("In MapSuid, selectJson SQL: ", sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public List<Map<String, Object>> select(MapSql mapSql) {
        this.doBeforePasreEntity(SuidType.SELECT);
        String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("In MapSuid, select List<Map> SQL: ", sql);
        List list = this.getBeeSql().selectMapList(sql);
        this.doBeforeReturn();
        return list;
    }

    public int count(MapSql mapSql) {
        this.doBeforePasreEntity(SuidType.SELECT);
        String sql = MapSqlProcessor.toCountSqlByMap(mapSql);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("In MapSuid, count SQL: ", sql);
        String total = this.getBeeSql().selectFun(sql);
        this.doBeforeReturn();
        return total == null ? 0 : Integer.parseInt(total);
    }

    public Map<String, Object> selectOne(MapSql mapSql) {
        this.doBeforePasreEntity(SuidType.SELECT);
        String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("In MapSuid, selectOne Map SQL: ", sql);
        List list = this.getBeeSql().selectMapList(sql);
        this.doBeforeReturn();
        if (ObjectUtils.isNotEmpty(list)) {
            return (Map)list.get(0);
        }
        return Collections.emptyMap();
    }

    public int insert(MapSql mapSql) {
        if (mapSql == null) {
            return -1;
        }
        this.doBeforePasreEntity(SuidType.INSERT);
        String sql = MapSqlProcessor.toInsertSqlByMap(mapSql);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("In MapSuid, insert SQL: ", sql);
        int insertNum = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return insertNum;
    }

    public long insertAndReturnId(MapSql mapSql) {
        long newId;
        if (mapSql == null) {
            return -1L;
        }
        this.doBeforePasreEntity(SuidType.INSERT);
        String sql = MapSqlProcessor.toInsertSqlByMap(mapSql, true);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("In MapSuid, insertAndReturnId SQL: ", sql);
        Object obj = OneTimeParameter.getAttribute("_SYS_Bee_MapSuid_Insert_Has_ID");
        if (obj != null) {
            newId = Long.parseLong(obj.toString());
            if (newId > 1L) {
                OneTimeParameter.getAttribute("_SYS_Bee_PK_Name_For_InsertAndReturnId");
                int insertNum = this.getBeeSql().modify(sql);
                if (insertNum == 1) {
                    return newId;
                }
                return insertNum;
            }
            if (HoneyUtil.isOracle()) {
                Logger.debug("Need create Sequence and Trigger for auto increment id. By the way,maybe use distribute id is better!");
            }
        }
        newId = this.getBeeSql().insertAndReturnId(sql);
        this.doBeforeReturn();
        return newId;
    }

    public int delete(MapSql mapSql) {
        this.doBeforePasreEntity(SuidType.DELETE);
        String sql = MapSqlProcessor.toDeleteSqlByMap(mapSql);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("In MapSuid, delete SQL: ", sql);
        int a = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return a;
    }

    public int update(MapSql mapSql) {
        this.doBeforePasreEntity(SuidType.UPDATE);
        String sql = MapSqlProcessor.toUpdateSqlByMap(mapSql);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("In MapSuid, update SQL: ", sql);
        int a = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return a;
    }

    private void doBeforePasreEntity(SuidType suidType) {
        if (this.dsName != null) {
            HoneyContext.setTempDS(this.dsName);
        }
        if (this.nameTranslate != null) {
            HoneyContext.setCurrentNameTranslate(this.nameTranslate);
        }
        this.getInterceptorChain().beforePasreEntity(null, suidType);
    }

    private String doAfterCompleteSql(String sql) {
        sql = this.getInterceptorChain().afterCompleteSql(sql);
        return sql;
    }

    private void doBeforeReturn() {
        if (this.dsName != null) {
            HoneyContext.removeTempDS();
        }
        if (this.nameTranslate != null) {
            HoneyContext.removeCurrentNameTranslate();
        }
        this.getInterceptorChain().beforeReturn();
    }
}

