/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.MoreObjToSQL;
import org.teasoft.bee.osql.MoreTable;
import org.teasoft.bee.osql.NameTranslate;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.bee.osql.interccept.InterceptorChain;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OneTimeParameter;

public class MoreObjSQL
implements MoreTable {
    private BeeSql beeSql;
    private MoreObjToSQL moreObjToSQL;
    private InterceptorChain interceptorChain;
    private String dsName;
    private NameTranslate nameTranslate;
    private static final String SELECT_SQL = "select SQL: ";

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public MoreObjToSQL getMoreObjToSQL() {
        if (this.moreObjToSQL == null) {
            return BeeFactory.getHoneyFactory().getMoreObjToSQL();
        }
        return this.moreObjToSQL;
    }

    public void setMoreObjToSQL(MoreObjToSQL moreObjToSQL) {
        this.moreObjToSQL = moreObjToSQL;
    }

    public void setNameTranslate(NameTranslate nameTranslate) {
        this.nameTranslate = nameTranslate;
    }

    public InterceptorChain getInterceptorChain() {
        if (this.interceptorChain == null) {
            this.interceptorChain = BeeFactory.getHoneyFactory().getInterceptorChain();
        }
        return this.interceptorChain;
    }

    public void setInterceptorChain(InterceptorChain interceptorChain) {
        this.interceptorChain = interceptorChain;
    }

    public void setDataSourceName(String dsName) {
        this.dsName = dsName;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public <T> List<T> select(T entity) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity);
        String sql = this.getMoreObjToSQL().toSelectSQL(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().moreTableSelect(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        this.doBeforePasreEntity(entity);
        String sql = this.getMoreObjToSQL().toSelectSQL(entity, start, size);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().moreTableSelect(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity);
        String sql = this.getMoreObjToSQL().toSelectSQL(entity, condition);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().moreTableSelect(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public MoreObjSQL setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    private void doBeforePasreEntity(Object entity) {
        if (this.dsName != null) {
            HoneyContext.setTempDS(this.dsName);
        }
        if (this.nameTranslate != null) {
            HoneyContext.setCurrentNameTranslate(this.nameTranslate);
        }
        this.getInterceptorChain().beforePasreEntity(entity, SuidType.SELECT);
        OneTimeParameter.setAttribute("_SYS_Bee_InterceptorChainForMoreTable", this.getInterceptorChain());
    }

    private String doAfterCompleteSql(String sql) {
        sql = this.getInterceptorChain().afterCompleteSql(sql);
        return sql;
    }

    private void doBeforeReturn(List list) {
        if (this.dsName != null) {
            HoneyContext.removeTempDS();
        }
        if (this.nameTranslate != null) {
            HoneyContext.removeCurrentNameTranslate();
        }
        this.getInterceptorChain().beforeReturn(list);
    }
}

