/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.NameTranslate;
import org.teasoft.bee.osql.ObjToSQL;
import org.teasoft.bee.osql.Suid;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.exception.NotSupportedException;
import org.teasoft.bee.osql.interccept.InterceptorChain;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OneTimeParameter;

public class ObjSQL
implements Suid {
    private BeeSql beeSql;
    private ObjToSQL objToSQL;
    private InterceptorChain interceptorChain;
    private String dsName;
    private NameTranslate nameTranslate;

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public ObjToSQL getObjToSQL() {
        if (this.objToSQL == null) {
            this.objToSQL = BeeFactory.getHoneyFactory().getObjToSQL();
        }
        return this.objToSQL;
    }

    public void setObjToSQL(ObjToSQL objToSQL) {
        this.objToSQL = objToSQL;
    }

    public InterceptorChain getInterceptorChain() {
        if (this.interceptorChain == null) {
            this.interceptorChain = BeeFactory.getHoneyFactory().getInterceptorChain();
        }
        return this.interceptorChain;
    }

    public void setInterceptorChain(InterceptorChain interceptorChain) {
        this.interceptorChain = interceptorChain;
    }

    public void setNameTranslate(NameTranslate nameTranslate) {
        this.nameTranslate = nameTranslate;
    }

    public void setDataSourceName(String dsName) {
        this.dsName = dsName;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public <T> List<T> select(T entity) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQL().toSelectSQL(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("select SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> int update(T entity) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        String sql = "";
        int updateNum = -1;
        sql = this.getObjToSQL().toUpdateSQL(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("update SQL: ", sql);
        this._regEntityClass(entity);
        updateNum = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return updateNum;
    }

    public <T> int insert(T entity) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        String sql = this.getObjToSQL().toInsertSQL(entity);
        sql = this.doAfterCompleteSql(sql);
        int insertNum = -1;
        Logger.logSQL("insert SQL: ", sql);
        this._regEntityClass(entity);
        HoneyUtil.revertId(entity);
        insertNum = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return insertNum;
    }

    public <T> long insertAndReturnId(T entity) {
        if (entity == null) {
            return -1L;
        }
        if (!(HoneyContext.isNeedGenId(entity.getClass()) || HoneyUtil.isMysql() || HoneyUtil.isOracle() || HoneyUtil.isSQLite())) {
            throw new NotSupportedException("The current database don't support return the id after insert.\nYou can use the distribute id via set config information,eg: bee.distribution.genid.forAllTableLongId=true");
        }
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        String sql = this.getObjToSQL().toInsertSQL(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("insert SQL: ", sql);
        return this._insertAndReturnId(entity, sql);
    }

    <T> long _insertAndReturnId(T entity, String sql) {
        String pkName;
        this._regEntityClass(entity);
        Object obj = HoneyUtil.getIdValue(entity);
        HoneyUtil.revertId(entity);
        long returnId = -1L;
        if (obj != null) {
            returnId = Long.parseLong(obj.toString());
            if (returnId > 1L) {
                int insertNum = this.getBeeSql().modify(sql);
                if (insertNum == 1) {
                    return returnId;
                }
                return insertNum;
            }
            if (HoneyUtil.isOracle()) {
                Logger.debug("Need create Sequence and Trigger for auto increment id. By the way,maybe use distribute id is better!");
            }
        }
        if ("".equals(pkName = HoneyUtil.getPkFieldName(entity)) || pkName.contains(",")) {
            pkName = "id";
        }
        OneTimeParameter.setAttribute("_SYS_Bee_PK_Name_For_InsertAndReturnId", pkName);
        returnId = this.getBeeSql().insertAndReturnId(sql);
        this.doBeforeReturn();
        return returnId;
    }

    public int delete(Object entity) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.DELETE);
        String sql = this.getObjToSQL().toDeleteSQL(entity);
        sql = this.doAfterCompleteSql(sql);
        int deleteNum = -1;
        Logger.logSQL("delete SQL: ", sql);
        this._regEntityClass(entity);
        deleteNum = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return deleteNum;
    }

    public <T> List<T> select(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQL().toSelectSQL(entity, condition);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("select SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> int delete(T entity, Condition condition) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.DELETE);
        String sql = this.getObjToSQL().toDeleteSQL(entity, condition);
        sql = this.doAfterCompleteSql(sql);
        int deleteNum = -1;
        if (!"".equals(sql)) {
            Logger.logSQL("delete SQL: ", sql);
        }
        this._regEntityClass(entity);
        deleteNum = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return deleteNum;
    }

    public Suid setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    private <T> void _regEntityClass(T entity) {
        HoneyContext.regEntityClass(entity.getClass());
    }

    public void beginSameConnection() {
        OneTimeParameter.setTrueForKey("_SYS_Bee_SAME_CONN_BEGIN");
        if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_EXCEPTION")) {
            Logger.warn("Last SameConnection do not have endSameConnection() or do not run endSameConnection() after having exception.");
        }
    }

    public void endSameConnection() {
        HoneyContext.endSameConnection();
    }

    void doBeforePasreEntity(Object entity, SuidType SuidType2) {
        if (this.dsName != null) {
            HoneyContext.setTempDS(this.dsName);
        }
        if (this.nameTranslate != null) {
            HoneyContext.setCurrentNameTranslate(this.nameTranslate);
        }
        this.getInterceptorChain().beforePasreEntity(entity, SuidType2);
    }

    String doAfterCompleteSql(String sql) {
        sql = this.getInterceptorChain().afterCompleteSql(sql);
        return sql;
    }

    void doBeforeReturn(List list) {
        if (this.dsName != null) {
            HoneyContext.removeTempDS();
        }
        if (this.nameTranslate != null) {
            HoneyContext.removeCurrentNameTranslate();
        }
        this.getInterceptorChain().beforeReturn(list);
    }

    void doBeforeReturn() {
        if (this.dsName != null) {
            HoneyContext.removeTempDS();
        }
        if (this.nameTranslate != null) {
            HoneyContext.removeCurrentNameTranslate();
        }
        this.getInterceptorChain().beforeReturn();
    }
}

