/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.interccept;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.interccept.Interceptor;
import org.teasoft.bee.osql.interccept.InterceptorChain;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.StringUtils;

public class CommInterceptorChain
implements InterceptorChain {
    private final List<Interceptor> chain = new ArrayList<Interceptor>();
    private final Set<Class<?>> set = new HashSet();

    public void addInterceptor(Interceptor interceptor) {
        if (!this.set.add(interceptor.getClass())) {
            Logger.warn("The InterceptorChain already contain the Interceptor, type: " + interceptor.getClass().getName());
        }
        this.chain.add(interceptor);
    }

    public Object beforePasreEntity(Object entity, SuidType suidType) {
        for (int i = 0; entity != null && i < this.chain.size(); ++i) {
            this.chain.get(i).beforePasreEntity(entity, suidType);
        }
        this.doResetDataSourceOneTime();
        return entity;
    }

    public Object[] beforePasreEntity(Object[] entityArray, SuidType suidType) {
        for (int i = 0; entityArray != null && i < this.chain.size(); ++i) {
            this.chain.get(i).beforePasreEntity(entityArray, suidType);
        }
        this.doResetDataSourceOneTime();
        return entityArray;
    }

    public void setDataSourceOneTime(String ds) {
    }

    public String getOneTimeDataSource() {
        return null;
    }

    private void doResetDataSourceOneTime() {
        int count = 0;
        int countTab = 0;
        int countTabSuffix = 0;
        for (int i = 0; i < this.chain.size(); ++i) {
            String ds = this.chain.get(i).getOneTimeDataSource();
            String tabName = this.chain.get(i).getOneTimeTabName();
            String tabSuffix = this.chain.get(i).getOneTimeTabSuffix();
            if (StringUtils.isNotBlank(ds)) {
                ++count;
                HoneyContext.setAppointDS(ds);
                Logger.info("[Bee] Reset the DataSource OneTime, ds name:" + ds);
            }
            if (StringUtils.isNotBlank(tabName)) {
                ++countTab;
                HoneyContext.setAppointTab(tabName);
                Logger.info("[Bee] Reset the tabName OneTime, tabName:" + tabName);
            }
            if (!StringUtils.isNotBlank(tabSuffix)) continue;
            ++countTabSuffix;
            HoneyContext.setTabSuffix(tabSuffix);
            Logger.info("[Bee] Reset the tabName OneTime, tabSuffix:" + tabSuffix);
        }
        if (count > 1) {
            Logger.warn("[Bee] Just the last DataSource is effective,if set the OneTime DataSource more than one!");
        }
        if (countTab > 1) {
            Logger.warn("[Bee] Just the last tabName is effective,if set the OneTime tabName more than one!");
        }
        if (countTabSuffix > 1) {
            Logger.warn("[Bee] Just the last TabSuffix is effective,if set the OneTime TabSuffix more than one!");
        }
    }

    public String afterCompleteSql(String sql) {
        for (int i = 0; i < this.chain.size(); ++i) {
            sql = this.chain.get(i).afterCompleteSql(sql);
        }
        return sql;
    }

    public void beforeReturn(List list) {
        for (int i = 0; i < this.chain.size(); ++i) {
            this.chain.get(i).beforeReturn(list);
        }
        HoneyContext.removeAppointDS();
        HoneyContext.removeCurrentRoute();
    }

    public void beforeReturn() {
        for (int i = 0; i < this.chain.size(); ++i) {
            this.chain.get(i).beforeReturn();
        }
        HoneyContext.removeAppointDS();
        HoneyContext.removeCurrentRoute();
    }

    public void setTabNameOneTime(String tabName) {
    }

    public void setTabSuffixOneTime(String tabSuffix) {
    }

    public String getOneTimeTabName() {
        return null;
    }

    public String getOneTimeTabSuffix() {
        return null;
    }
}

