/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.type;

import java.util.HashMap;
import java.util.Map;
import org.teasoft.bee.osql.Registry;
import org.teasoft.bee.osql.type.TypeHandler;
import org.teasoft.honey.osql.core.HoneyConfig;

public final class TypeHandlerRegistry
implements Registry {
    private static final String PRIORITY = "1";
    private static final Map<Class<?>, TypeHandler<?>> handlersMap = new HashMap();
    private static final Map<Class<?>, String> priorityMap = new HashMap();
    private static final Map<String, Map<Class<?>, TypeHandler<?>>> handlersMapForSpecialDB = new HashMap();

    public static <T> void register(Class<T> fieldType, TypeHandler<? extends T> handler) {
        handlersMap.put(fieldType, handler);
    }

    public static <T> void register(Class<T> fieldType, TypeHandler<? extends T> handler, String database) {
        Map<Class<?>, TypeHandler<?>> map = handlersMapForSpecialDB.get(database);
        if (map == null) {
            map = new HashMap();
        }
        map.put(fieldType, handler);
        handlersMapForSpecialDB.put(database, map);
    }

    public static <T> void register(Class<T> fieldType, TypeHandler<? extends T> handler, boolean isPriority) {
        handlersMap.put(fieldType, handler);
        if (isPriority) {
            priorityMap.put(fieldType, PRIORITY);
        }
    }

    public static <T> boolean isPriorityType(Class<T> fieldType) {
        return priorityMap.get(fieldType) != null;
    }

    public static <T> TypeHandler<T> getHandler(Class<T> fieldType) {
        TypeHandler<?> handler = null;
        Map<Class<?>, TypeHandler<?>> map = handlersMapForSpecialDB.get(HoneyConfig.getHoneyConfig().getDbName());
        if (map != null) {
            handler = map.get(fieldType);
        }
        if (handler == null) {
            handler = handlersMap.get(fieldType);
        }
        return handler;
    }

    public static <T> T handlerProcess(Class<T> fieldType, Object result) {
        TypeHandler<T> handler = TypeHandlerRegistry.getHandler(fieldType);
        if (handler != null) {
            handler.process(fieldType, result);
        }
        return (T)result;
    }
}

