/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;

public final class EntityUtil {
    private EntityUtil() {
    }

    public static String getFieldNames(Object entity) {
        return EntityUtil.getFieldNames(entity, false);
    }

    public static String getFieldNames(Object entity, boolean isTransform) {
        if (entity == null) {
            return "";
        }
        Field[] fields = entity.getClass().getDeclaredFields();
        if (fields == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        int len = fields.length;
        boolean isFirst = true;
        for (int i = 0; i < len; ++i) {
            if (HoneyUtil.isSkipField(fields[i]) || HoneyUtil.isSkipFieldJustFetch(fields[i])) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                s.append(",");
            }
            if (isTransform) {
                s.append(NameTranslateHandle.toColumnName(fields[i].getName()));
                continue;
            }
            s.append(fields[i].getName());
        }
        return s.toString();
    }

    public static boolean isList(Field field) {
        return List.class.isAssignableFrom(field.getType());
    }

    public static boolean isSet(Field field) {
        return Set.class.isAssignableFrom(field.getType());
    }

    public static boolean isMap(Field field) {
        return Map.class.isAssignableFrom(field.getType());
    }

    public static Class<?> getGenericType(Field field) {
        Type gType = field.getGenericType();
        if (gType instanceof ParameterizedType) {
            ParameterizedType paraType = (ParameterizedType)gType;
            Class elementType = (Class)paraType.getActualTypeArguments()[0];
            return elementType;
        }
        return null;
    }

    public static Class<?>[] getGenericTypeArray(Field field) {
        Type gType = field.getGenericType();
        return EntityUtil.getGenericTypeArray(gType);
    }

    public static Class<?>[] getGenericTypeArray(Type gType) {
        if (gType instanceof ParameterizedType) {
            ParameterizedType paraType = (ParameterizedType)gType;
            Type[] types = paraType.getActualTypeArguments();
            Class[] elementTypes = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                if (types[i] instanceof ParameterizedType) {
                    Logger.warn("Do not support the Map element is Map," + types[i].toString());
                    continue;
                }
                elementTypes[i] = (Class)types[i];
            }
            return elementTypes;
        }
        return null;
    }

    public static boolean isCustomBean(Field field) {
        String typeName = field.getType().getName();
        return !field.getType().isPrimitive() && !typeName.startsWith("java.") && !typeName.startsWith("javax.") && !typeName.startsWith("org.teasoft.bee.") && !typeName.startsWith("org.teasoft.hoeny.") && !typeName.startsWith("org.teasoft.beex.") && !typeName.startsWith("org.teasoft.spring.") && !typeName.startsWith("org.w3c.") && !typeName.startsWith("org.xml.") && !typeName.startsWith("android.") && !typeName.startsWith("org.omg.") && !typeName.startsWith("sun.");
    }

    public static boolean isCustomBean(String typeName) {
        return !typeName.startsWith("java.") && !typeName.startsWith("javax.") && !typeName.startsWith("org.teasoft.bee.") && !typeName.startsWith("org.teasoft.hoeny.") && !typeName.startsWith("org.teasoft.beex.") && !typeName.startsWith("org.teasoft.spring.") && !typeName.startsWith("org.w3c.") && !typeName.startsWith("org.xml.") && !typeName.startsWith("android.") && !typeName.startsWith("org.omg.") && !typeName.startsWith("sun.");
    }

    public static String arrayToString(String[] array) {
        if (array == null) {
            return null;
        }
        String str = "";
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                str = str + ",";
            }
            str = str + array[i];
        }
        return str;
    }
}

