/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.autogen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.teasoft.bee.osql.BeeException;
import org.teasoft.bee.osql.exception.BeeIllegalSQLException;
import org.teasoft.honey.osql.autogen.GenConfig;
import org.teasoft.honey.osql.autogen.Table;
import org.teasoft.honey.osql.core.Check;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.SessionFactory;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.osql.util.DateUtil;
import org.teasoft.honey.osql.util.NameCheckUtil;
import org.teasoft.honey.util.StringUtils;

public class GenBean {
    private GenConfig config;
    private String LINE_SEPARATOR = System.getProperty("line.separator");
    private boolean isNeedKeyColumn = false;
    private static boolean printOverrideSetTip = true;

    public GenBean() {
        this.config = new GenConfig();
    }

    public GenBean(GenConfig config) {
        this.config = config;
    }

    private boolean genBeanFile(Table table) {
        File entityFile;
        String entitySaveDir;
        File folder;
        String basePath;
        String tableName = table.getTableName();
        List<String> columnNames = table.getColumnNames();
        List<String> columnTypes = table.getColumnTypes();
        Map<String, String> commentMap = table.getCommentMap();
        String entityName = "";
        entityName = NameTranslateHandle.toEntityName(tableName);
        entityName = NameUtil.firstLetterToUpperCase(entityName);
        if (this.config.getEntityNamePre() != null) {
            entityName = this.config.getEntityNamePre() + entityName;
        }
        String tableComment = "";
        if (this.config.isGenComment() && commentMap != null) {
            tableComment = commentMap.get(table.getTableName());
        }
        String authorComment = "/**" + this.LINE_SEPARATOR;
        if (this.config.isGenComment() && StringUtils.isNotBlank(tableComment)) {
            authorComment = authorComment + " * " + tableComment + this.LINE_SEPARATOR;
        }
        authorComment = authorComment + " * @author Honey" + this.LINE_SEPARATOR;
        authorComment = authorComment + " * Create on " + DateUtil.currentDate() + this.LINE_SEPARATOR;
        authorComment = authorComment + " */";
        String packageStr = "package " + this.config.getPackagePath() + ";" + this.LINE_SEPARATOR;
        String importStr = "";
        String propertyName = "";
        String propertiesStr = "";
        String getsetStr = "";
        String getsetProNameStr = "";
        String javaType = "";
        boolean bigIntegerFlag = true;
        boolean bigDecimalFlag = true;
        boolean dateFlag = true;
        boolean timeFlag = true;
        boolean timestampFlag = true;
        boolean blobFlag = true;
        boolean clobFlag = true;
        boolean arrayFlag = true;
        boolean listFlag = true;
        boolean setFlag = true;
        boolean mapFlag = true;
        boolean nClobFlag = true;
        boolean rowIdFlag = true;
        boolean sqlxmlFlag = true;
        TreeSet<String> importSet = new TreeSet<String>();
        StringBuilder tostr = new StringBuilder();
        if (this.config.isGenSerializable()) {
            importSet.add("import java.io.Serializable;");
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            String columnType = columnTypes.get(i);
            String comment = "";
            String getOrIs = "get";
            String unknownTypeTip = "";
            propertyName = NameTranslateHandle.toFieldName(columnName);
            getsetProNameStr = HoneyUtil.firstLetterToUpperCase(propertyName);
            javaType = HoneyUtil.getFieldType(columnType);
            if ("id".equalsIgnoreCase(propertyName) && "BigDecimal".equalsIgnoreCase(javaType)) {
                javaType = "Long";
            }
            if ("BigDecimal".equals(javaType) && bigDecimalFlag) {
                importSet.add("import java.math.BigDecimal;");
                bigDecimalFlag = false;
            } else if ("BigInteger".equals(javaType) && bigIntegerFlag) {
                importSet.add("import java.math.BigInteger;");
                bigIntegerFlag = false;
            } else if ("Date".equals(javaType) && dateFlag) {
                importSet.add("import java.sql.Date;");
                dateFlag = false;
            } else if ("Time".equals(javaType) && timeFlag) {
                importSet.add("import java.sql.Time;");
                timeFlag = false;
            } else if ("Timestamp".equals(javaType) && timestampFlag) {
                importSet.add("import java.sql.Timestamp;");
                timestampFlag = false;
            } else if ("Blob".equals(javaType) && blobFlag) {
                importSet.add("import java.sql.Blob;");
                blobFlag = false;
            } else if ("Clob".equals(javaType) && clobFlag) {
                importSet.add("import java.sql.Clob;");
                clobFlag = false;
            } else if ("Array".equals(javaType) && arrayFlag) {
                importSet.add("import java.sql.Array;");
                arrayFlag = false;
            } else if ("List".equals(javaType) && listFlag) {
                importSet.add("import java.util.List;");
                listFlag = false;
            } else if ("Set".equals(javaType) && setFlag) {
                importSet.add("import java.util.Set;");
                setFlag = false;
            } else if ("Map".equals(javaType) && mapFlag) {
                importSet.add("import java.util.Map;");
                mapFlag = false;
            } else if ("NCLOB".equals(javaType) && nClobFlag) {
                importSet.add("import java.sql.NClob;");
                nClobFlag = false;
            } else if ("ROWID".equals(javaType) && rowIdFlag) {
                importSet.add("import java.sql.RowId;");
                rowIdFlag = false;
            } else if ("SQLXML".equals(javaType) && sqlxmlFlag) {
                importSet.add("import java.sql.SQLXML;");
                sqlxmlFlag = false;
            } else if (javaType.startsWith("[UNKNOWN TYPE]")) {
                unknownTypeTip = " //set the type mapping in the jdbcTypeToFieldType.properties";
            } else if ("boolean".equals(javaType)) {
                getOrIs = "is";
            }
            if (this.config.isGenComment() && commentMap != null) {
                comment = commentMap.get(columnName);
                if (this.config.getCommentPlace() == 2) {
                    if (StringUtils.isNotBlank(comment)) {
                        propertiesStr = propertiesStr + "\t// " + comment + this.LINE_SEPARATOR;
                    }
                    propertiesStr = propertiesStr + "\tprivate " + javaType + " " + propertyName + ";" + unknownTypeTip + this.LINE_SEPARATOR;
                } else {
                    propertiesStr = propertiesStr + "\tprivate " + javaType + " " + propertyName + ";" + unknownTypeTip;
                    if (StringUtils.isNotBlank(comment)) {
                        propertiesStr = propertiesStr + "//" + comment;
                    }
                    propertiesStr = propertiesStr + this.LINE_SEPARATOR;
                }
            } else {
                propertiesStr = propertiesStr + "\tprivate " + javaType + " " + propertyName + ";" + unknownTypeTip + this.LINE_SEPARATOR;
            }
            getsetStr = getsetStr + "\tpublic " + javaType + " " + getOrIs + getsetProNameStr + "() {" + this.LINE_SEPARATOR + "\t\treturn " + propertyName + ";" + this.LINE_SEPARATOR + "\t}" + this.LINE_SEPARATOR + this.LINE_SEPARATOR + "\tpublic void set" + getsetProNameStr + "(" + javaType + " " + propertyName + ") {" + this.LINE_SEPARATOR + "\t\tthis." + propertyName + " = " + propertyName + ";" + this.LINE_SEPARATOR + "\t}" + this.LINE_SEPARATOR + this.LINE_SEPARATOR;
            if (!this.config.isGenToString()) continue;
            tostr.append("\t\t str.append(\",").append(propertyName).append("=\").append(").append(propertyName).append(");");
            tostr.append("\t\t " + this.LINE_SEPARATOR);
        }
        if (this.config.isLombokSetter()) {
            importSet.add("import lombok.Setter;");
        }
        if (this.config.isLombokGetter()) {
            importSet.add("import lombok.Getter;");
        }
        if (this.config.isLombokData()) {
            importSet.add("import lombok.Data;");
        }
        if (this.config.isLombokSetter() || this.config.isLombokGetter() || this.config.isLombokData()) {
            this.config.setGenGetSet(false);
        }
        for (String s : importSet) {
            importStr = importStr + s + this.LINE_SEPARATOR;
        }
        if (HoneyUtil.isCassandra()) {
            importStr = importStr + this.LINE_SEPARATOR + "//import org.teasoft.bee.osql.annotation.Table;" + this.LINE_SEPARATOR;
        }
        if (!(basePath = this.config.getBaseDir()).endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        if (!(folder = new File(entitySaveDir = basePath + this.config.getPackagePath().replace(".", File.separator) + File.separator)).exists()) {
            folder.mkdirs();
        }
        if ((entityFile = new File(entitySaveDir + entityName + ".java")).isFile()) {
            if (this.config.isOverride()) {
                Logger.debug("Override file:  " + entityFile.getAbsolutePath());
            } else {
                this.printOvrrideTip(entityFile.getAbsolutePath());
                return false;
            }
        }
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(entityFile)));){
            bw.write(packageStr + this.LINE_SEPARATOR);
            if (!"".equals(importStr)) {
                bw.write(importStr + this.LINE_SEPARATOR);
            }
            bw.write(authorComment + this.LINE_SEPARATOR);
            if (HoneyUtil.isCassandra()) {
                bw.write("//@Table(\"" + table.getSchema() + "." + tableName + "\")" + this.LINE_SEPARATOR);
            }
            if (this.config.isLombokSetter()) {
                bw.write("@Setter" + this.LINE_SEPARATOR);
            }
            if (this.config.isLombokGetter()) {
                bw.write("@Getter" + this.LINE_SEPARATOR);
            }
            if (this.config.isLombokData()) {
                bw.write("@Data" + this.LINE_SEPARATOR);
            }
            bw.write("public class " + entityName);
            if (this.config.isGenSerializable()) {
                bw.write(" implements Serializable");
            }
            bw.write(" {" + this.LINE_SEPARATOR + this.LINE_SEPARATOR);
            if (this.config.isGenSerializable()) {
                bw.write("\tprivate static final long serialVersionUID = " + HoneyUtil.genSerializableNum() + ";" + this.LINE_SEPARATOR);
                bw.write(this.LINE_SEPARATOR);
            }
            bw.write(propertiesStr);
            bw.write(this.LINE_SEPARATOR);
            if (this.config.isGenGetSet()) {
                bw.write(getsetStr);
            }
            if (this.config.isGenToString()) {
                tostr.deleteCharAt(tostr.indexOf(","));
                tostr.insert(0, "\t\t" + this.LINE_SEPARATOR);
                tostr.append("\t\t str.append(\"]\");\t");
                tostr.append("\t\t " + this.LINE_SEPARATOR);
                tostr.append("\t\t return str.toString();\t");
                tostr.append("\t\t " + this.LINE_SEPARATOR);
                tostr.append("\t }");
                tostr.append("\t\t " + this.LINE_SEPARATOR);
                tostr.insert(0, "\t\t str.append(\"" + entityName + "[\");\t");
                tostr.insert(0, "\t" + this.LINE_SEPARATOR);
                tostr.insert(0, "\t\t StringBuilder str=new StringBuilder();");
                tostr.insert(0, "\t" + this.LINE_SEPARATOR);
                tostr.insert(0, "\t public String toString(){");
                bw.write(tostr.toString());
            }
            bw.write("}");
            bw.flush();
            Logger.info("The Honey gen the JavaBean: " + this.config.getPackagePath() + "." + entityName);
        }
        catch (Exception e) {
            throw ExceptionHelper.convert(e);
        }
        return true;
    }

    private void printOvrrideTip(String path) {
        Logger.warn("The file is exist!   " + path);
        if (printOverrideSetTip) {
            Logger.warn("You can config the override type as : config.setOverride(true);");
            printOverrideSetTip = false;
        }
    }

    private void genFieldFile(Table table) {
        File fieldFile;
        File folder;
        String tableName = table.getTableName();
        List<String> columnNames = table.getColumnNames();
        Map<String, String> commentMap = table.getCommentMap();
        String entityName = "";
        entityName = NameTranslateHandle.toEntityName(tableName);
        entityName = NameUtil.firstLetterToUpperCase(entityName);
        if (this.config.getEntityNamePre() != null) {
            entityName = this.config.getEntityNamePre() + entityName;
        }
        String fieldFileName = this.config.getFieldFilePrefix() + entityName + this.config.getFieldFileSuffix();
        String fieldFilePackagePath = this.config.getPackagePath();
        if (StringUtils.isNotBlank(this.config.getFieldFileRelativeFolder())) {
            fieldFilePackagePath = fieldFilePackagePath + "." + this.config.getFieldFileRelativeFolder();
        }
        String tableComment = "";
        if (this.config.isGenComment() && commentMap != null) {
            tableComment = commentMap.get(table.getTableName());
        }
        String authorComment = "/**" + this.LINE_SEPARATOR;
        authorComment = this.config.isGenComment() && !"".equals(tableComment) ? authorComment + " * " + tableComment + " (relative field name for Javabean " + entityName + ")" + this.LINE_SEPARATOR : authorComment + " * Relative field name for Javabean " + entityName + this.LINE_SEPARATOR;
        authorComment = authorComment + " * @author Honey" + this.LINE_SEPARATOR;
        authorComment = authorComment + " * Create on " + DateUtil.currentDate() + this.LINE_SEPARATOR;
        authorComment = authorComment + " */";
        String packageStr = "package " + fieldFilePackagePath + ";" + this.LINE_SEPARATOR;
        String basePath = this.config.getBaseDir();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        String fieldFileSaveDir = basePath + this.config.getPackagePath().replace(".", File.separator) + File.separator;
        if (StringUtils.isNotBlank(this.config.getFieldFileRelativeFolder())) {
            fieldFileSaveDir = fieldFileSaveDir + this.config.getFieldFileRelativeFolder() + File.separator;
        }
        if (!(folder = new File(fieldFileSaveDir)).exists()) {
            folder.mkdirs();
        }
        if ((fieldFile = new File(fieldFileSaveDir + fieldFileName + ".java")).isFile()) {
            if (this.config.isOverride()) {
                Logger.debug("Override file:  " + fieldFile.getAbsolutePath());
            } else {
                this.printOvrrideTip(fieldFile.getAbsolutePath());
                return;
            }
        }
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fieldFile)));){
            bw.write(packageStr + this.LINE_SEPARATOR);
            bw.write(authorComment + this.LINE_SEPARATOR);
            bw.write("public class " + fieldFileName);
            bw.write(" {" + this.LINE_SEPARATOR + this.LINE_SEPARATOR);
            bw.write("\tprivate FieldFileName() {}".replace("FieldFileName", fieldFileName));
            bw.write(this.LINE_SEPARATOR + this.LINE_SEPARATOR);
            String st = "";
            String comment = "";
            String fieldName = "";
            String columnName = "";
            String allFieldName = "";
            boolean genFieldAll = this.config.isGenFieldAll();
            boolean genSelfName = this.config.isGenSelfName();
            for (int i = 0; i < columnNames.size(); ++i) {
                columnName = columnNames.get(i);
                fieldName = NameTranslateHandle.toFieldName(columnName);
                st = "\tpublic static final String {fieldName} = \"{fieldName}\";".replace("{fieldName}", fieldName);
                if (this.config.isGenComment() && commentMap != null) {
                    comment = commentMap.get(columnName);
                    if (this.config.getCommentPlace() == 2) {
                        if (!"".equals(comment)) {
                            st = "\t// " + comment + this.LINE_SEPARATOR + st;
                        }
                    } else {
                        if (!"".equals(comment)) {
                            st = st + "//" + comment;
                        }
                        st = st + this.LINE_SEPARATOR;
                    }
                }
                bw.write(st);
                bw.write(this.LINE_SEPARATOR);
                if (!genFieldAll) continue;
                if (i != 0) {
                    allFieldName = allFieldName + ",";
                }
                allFieldName = allFieldName + fieldName;
            }
            if (genSelfName) {
                bw.write("\tpublic static final String ENTITY_NAME = \"" + entityName + "\";");
                bw.write(this.LINE_SEPARATOR);
                bw.write("\tpublic static final String TABLE_NAME = \"" + tableName + "\";");
                bw.write(this.LINE_SEPARATOR);
            }
            if (genFieldAll) {
                bw.write("\tpublic static final String ALL_NAMES = \"" + allFieldName + "\";");
                bw.write(this.LINE_SEPARATOR);
            }
            bw.write("}");
            bw.flush();
            Logger.info("The Honey gen the FieldFile for JavaBean: " + fieldFilePackagePath + "." + fieldFileName);
        }
        catch (Exception e) {
            throw ExceptionHelper.convert(e);
        }
    }

    public void genAllBeanFile() {
        List<Table> tableList = this.getAllTables();
        this._genBeanFiles(tableList);
    }

    private void _genBeanFiles(List<Table> tables) {
        Logger.info("Generating...");
        Table table = null;
        boolean some = false;
        boolean all = true;
        for (int i = 0; i < tables.size(); ++i) {
            table = tables.get(i);
            boolean f1 = this.genBeanFile(table);
            if (this.config.isGenFieldFile()) {
                this.genFieldFile(table);
            }
            some = some || f1;
            all = all && f1;
        }
        if (all) {
            Logger.info("Generate Success!");
        } else if (some) {
            Logger.info("Generate some file Success!");
        }
        this.printCheck(all || some);
    }

    private void printCheck(boolean isNeed) {
        if (isNeed) {
            Logger.info("Please check folder: " + this.config.getBaseDir() + this.config.getPackagePath().replace(".", "\\"));
        }
    }

    public void genSomeBeanFile(String tableNameList) {
        String[] tableNames = tableNameList.split(",");
        Connection con = null;
        ArrayList<Table> tablesList = new ArrayList<Table>();
        try {
            con = SessionFactory.getConnection();
            Table table = null;
            for (int i = 0; i < tableNames.length; ++i) {
                table = this.getTable(tableNames[i], con);
                tablesList.add(table);
            }
        }
        catch (Exception e) {
            Logger.warn(e.getMessage(), e);
            if (e.getMessage().contains("You have an error in your SQL syntax;") && e.getMessage().contains("where 1<>1")) {
                Logger.info("Maybe the table name is the database key work. Please rename the tableName and test again." + e.getMessage());
            }
            throw ExceptionHelper.convert(e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        this._genBeanFiles(tablesList);
    }

    private List<Table> getAllTables() {
        boolean isCommDb = true;
        String showTablesSql = "";
        if (!"".equals(this.config.getQueryTableSql().trim())) {
            showTablesSql = this.config.getQueryTableSql();
        } else if (this.config.getDbName().equalsIgnoreCase("MySQL")) {
            showTablesSql = "show tables";
        } else if (this.config.getDbName().equalsIgnoreCase("Oracle")) {
            showTablesSql = "select table_name from user_tables";
        } else if (this.config.getDbName().equalsIgnoreCase("Microsoft SQL Server")) {
            showTablesSql = "select table_name from edp.information_schema.tables where table_type='base table'";
        } else {
            isCommDb = false;
        }
        if (isCommDb) {
            return this._mainDbTables(showTablesSql);
        }
        return this._otherDbTables();
    }

    private List<Table> _mainDbTables(String showTablesSql) {
        ArrayList<Table> tables = new ArrayList<Table>();
        try (Connection conn = SessionFactory.getConnection();
             PreparedStatement ps = conn.prepareStatement(showTablesSql);
             ResultSet rs = ps.executeQuery();){
            ArrayList<String> tabList = new ArrayList<String>();
            while (rs.next()) {
                if (rs.getString(1) == null) continue;
                tabList.add(rs.getString(1).trim());
            }
            for (String tab : tabList) {
                tables.add(this.getTable(tab, conn));
            }
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
        return tables;
    }

    private List<Table> _otherDbTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        Connection conn = SessionFactory.getConnection();
        boolean has = false;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            String schemaPattern = null;
            String[] types = null;
            if (this.config.getDbName().equalsIgnoreCase("H2")) {
                schemaPattern = "PUBLIC";
            }
            if (this.config.getDbName().equalsIgnoreCase("PostgreSQL")) {
                schemaPattern = "public";
                types = new String[]{"TABLE"};
            }
            ResultSet rs = dbmd.getTables(null, schemaPattern, "%", types);
            ArrayList<String> tabList = new ArrayList<String>();
            while (rs.next()) {
                if (rs.getString(3) == null) continue;
                tabList.add(rs.getString(3).trim());
                has = true;
            }
            for (String tab : tabList) {
                tables.add(this.getTable(tab, conn));
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            has = false;
        }
        if (!has) {
            throw new BeeException("There are not default sql, please check the bee.db.dbName in bee.properties is right or not, or define queryTableSql in GenConfig!");
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table getTable(String tableName, Connection con) throws SQLException {
        NameCheckUtil.checkName(tableName);
        PreparedStatement ps = null;
        ResultSet rs = null;
        Table table = new Table();
        try {
            StringBuilder sql = new StringBuilder();
            if (HoneyUtil.isCassandra()) {
                sql.append("select * from ").append(tableName).append(" limit 1");
            } else {
                sql.append("select * from ").append(tableName).append(" where 1<>1");
            }
            ps = con.prepareStatement(sql.toString());
            rs = ps.executeQuery();
            ResultSetMetaData rmeta = rs.getMetaData();
            if (HoneyUtil.isCassandra()) {
                int index = tableName.indexOf(".");
                if (index > -1) {
                    table.setTableName(tableName.substring(index + 1));
                } else {
                    table.setTableName(tableName);
                }
            } else {
                table.setTableName(tableName);
            }
            table.setSchema(rmeta.getCatalogName(1));
            int columCount = rmeta.getColumnCount();
            for (int i = 1; i <= columCount; ++i) {
                table.getColumnNames().add(rmeta.getColumnName(i).trim());
                table.getColumnTypes().add(rmeta.getColumnTypeName(i).trim());
                if (rmeta.isNullable(i) == 1) {
                    table.getYnNulls().add(true);
                    continue;
                }
                table.getYnNulls().add(false);
            }
        }
        catch (Throwable throwable) {
            HoneyContext.checkClose(rs, ps, null);
            throw throwable;
        }
        HoneyContext.checkClose(rs, ps, null);
        if (this.config == null || this.config.isGenComment()) {
            this.initComment(table, con);
        }
        if (this.isNeedKeyColumn) {
            this.initKeyColumn(table, con);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKeyColumn(Table table, Connection con) throws SQLException {
        DatabaseMetaData dbmd = con.getMetaData();
        ResultSet rs = null;
        HashMap<String, String> primaryKeyNames = new HashMap<String, String>();
        try {
            rs = dbmd.getPrimaryKeys(null, null, table.getTableName());
            while (rs.next()) {
                String keyName = rs.getString(4);
                primaryKeyNames.put(keyName, keyName);
            }
        }
        catch (Throwable throwable) {
            HoneyContext.checkClose(rs, null, null);
            throw throwable;
        }
        HoneyContext.checkClose(rs, null, null);
        table.setPrimaryKeyNames(primaryKeyNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initComment(Table table, Connection con) throws SQLException {
        String sql = "";
        String t_sql = null;
        String dbName = "";
        if (this.config != null) {
            t_sql = this.config.getQueryColumnCommnetSql();
            dbName = this.config.getDbName();
        } else {
            dbName = HoneyConfig.getHoneyConfig().getDbName();
        }
        if (t_sql != null) {
            sql = t_sql;
            if (Check.isNotValidExpression(sql)) {
                throw new BeeIllegalSQLException("The sql: '" + sql + "' is invalid!");
            }
        } else if ("MySQL".equalsIgnoreCase(dbName) || "MariaDB".equalsIgnoreCase(dbName)) {
            sql = "select column_name,column_comment from information_schema.COLUMNS where TABLE_SCHEMA='" + table.getSchema() + "' and TABLE_NAME=?";
        } else if ("Oracle".equalsIgnoreCase(dbName)) {
            sql = "select column_name,comments from user_col_comments where table_name=?";
        } else {
            Logger.warn("There are not default sql, please check the bee.db.dbName in bee.properties is right or not, or define queryColumnCommnetSql in GenConfig!");
            return;
        }
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        try {
            ps = con.prepareStatement(sql);
            ps.setString(1, table.getTableName());
            Map<String, String> map = this.getCommentMap(ps);
            String sql2 = "";
            String t_sql2 = null;
            if (this.config != null) {
                t_sql2 = this.config.getQueryTableCommnetSql();
            }
            if (t_sql2 != null) {
                sql2 = t_sql2;
                if (Check.isNotValidExpression(sql2)) {
                    throw new BeeIllegalSQLException("The sql: '" + sql2 + "' is invalid!");
                }
            } else if ("MySQL".equalsIgnoreCase(dbName) || "MariaDB".equalsIgnoreCase(dbName)) {
                sql2 = "select TABLE_NAME,TABLE_COMMENT from information_schema.TABLES where TABLE_SCHEMA='" + table.getSchema() + "' and TABLE_NAME=?";
            } else if ("Oracle".equalsIgnoreCase(dbName)) {
                sql2 = "select table_name,comments from user_tab_comments where table_name=?";
            } else {
                throw new BeeException("There are not default sql, please check the bee.db.dbName in bee.properties is right or not, or define queryTableCommnetSql in GenConfig!");
            }
            ps2 = con.prepareStatement(sql2);
            ps2.setString(1, table.getTableName());
            Map<String, String> map2 = this.getCommentMap(ps2);
            map2.putAll(map);
            table.setCommentMap(map2);
        }
        catch (Throwable throwable) {
            HoneyContext.checkClose(ps, null);
            HoneyContext.checkClose(ps2, null);
            throw throwable;
        }
        HoneyContext.checkClose(ps, null);
        HoneyContext.checkClose(ps2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getCommentMap(PreparedStatement ps) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            while (rs.next()) {
                String comment = rs.getString(2);
                if (comment == null) {
                    comment = "";
                }
                map.put(rs.getString(1), comment);
            }
        }
        finally {
            HoneyContext.checkClose(rs, ps, null);
        }
        return map;
    }

    private Table getTalbe(String tableName) {
        Connection con = null;
        Table table = null;
        try {
            con = SessionFactory.getConnection();
            table = this.getTable(tableName, con);
        }
        catch (Exception e) {
            Logger.info(e.getMessage());
            if (e.getMessage().contains("You have an error in your SQL syntax;") && e.getMessage().contains("where 1<>1")) {
                Logger.info("Maybe the table name is the database key work. Please rename the tableName and test again." + e.getMessage());
            }
            throw ExceptionHelper.convert(e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return table;
    }

    public Table getTableInfo(String tableName) {
        this.isNeedKeyColumn = true;
        Table table = this.getTalbe(tableName);
        this.isNeedKeyColumn = false;
        return table;
    }

    public List<String> getColumnNames(String tableName) {
        Table table = this.getTalbe(tableName);
        if (table != null) {
            return table.getColumnNames();
        }
        return Collections.emptyList();
    }

    public List<String> getFieldNames(String tableName) {
        List<String> columnNames = this.getColumnNames(tableName);
        if (columnNames == null) {
            return Collections.emptyList();
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < columnNames.size(); ++i) {
            fieldNames.add(NameTranslateHandle.toFieldName(columnNames.get(i)));
        }
        return fieldNames;
    }
}

