/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;

public class DateUtil {
    private DateUtil() {
    }

    private static SimpleDateFormat getSimpleDateFormat() {
        SimpleDateFormat defaultFormat = null;
        String dateFormatStr = HoneyConfig.getHoneyConfig().dateFormat;
        if (dateFormatStr != null && !"".equals(dateFormatStr.trim())) {
            try {
                defaultFormat = new SimpleDateFormat(dateFormatStr);
            }
            catch (Exception e) {
                Logger.warn("In DateUtil: it is error date format String :" + dateFormatStr);
                defaultFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
        } else {
            defaultFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return defaultFormat;
    }

    public static String currentDate() {
        return DateUtil.getSimpleDateFormat().format(new Date());
    }

    public static String currentDate(String formatStr) {
        SimpleDateFormat format = null;
        format = formatStr == null || "".trim().equals(formatStr) ? DateUtil.getSimpleDateFormat() : new SimpleDateFormat(formatStr);
        return format.format(new Date());
    }

    public static java.sql.Date currentSqlDate() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static Timestamp toTimestamp(String dateString) {
        try {
            Date date = DateUtil.getSimpleDateFormat().parse(dateString);
            return new Timestamp(date.getTime());
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
            return null;
        }
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp jumpDaysExact(int days) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, days);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp jumpDays(int days) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, days);
        cal.set(10, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp jumpDays(Timestamp base, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(base);
        cal.add(5, days);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static boolean isNowEffect(Timestamp expirationDate) {
        Calendar now = Calendar.getInstance();
        return now.getTime().before(expirationDate);
    }
}

