/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util;

import java.util.HashMap;
import java.util.Map;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.ObjectCreator;

public class ObjectCreatorFactory {
    private static Map<String, Class> classMap = null;

    private ObjectCreatorFactory() {
    }

    public static Object create(String s, Class c) {
        if (c == null) {
            return null;
        }
        if (s == null) {
            return null;
        }
        if (c.equals(String.class)) {
            return ObjectCreator.createString(s);
        }
        s = s.trim();
        if (c.equals(Integer.TYPE) || c.equals(Integer.class)) {
            return ObjectCreator.createInt(s);
        }
        if (c.equals(Short.TYPE) || c.equals(Short.class)) {
            return ObjectCreator.createShort(s);
        }
        if (c.equals(Byte.TYPE) || c.equals(Byte.class)) {
            return ObjectCreator.createByte(s);
        }
        if (c.equals(Double.TYPE) || c.equals(Double.class)) {
            return ObjectCreator.createDouble(s);
        }
        if (c.equals(Long.TYPE) || c.equals(Long.class)) {
            return ObjectCreator.createLong(s);
        }
        if (c.equals(Boolean.TYPE) || c.equals(Boolean.class)) {
            return ObjectCreator.createBoolean(s);
        }
        if (c.equals(Float.TYPE) || c.equals(Float.class)) {
            return ObjectCreator.createFloat(s);
        }
        Logger.warn("when create Object, do not support this type :" + c.getName());
        return null;
    }

    public static Object createByString(String s, String className) {
        return ObjectCreatorFactory.create(className, classMap.get(className));
    }

    static {
        classMap = new HashMap<String, Class>();
        classMap.put("int", Integer.TYPE);
        classMap.put("short", Short.TYPE);
        classMap.put("byte", Byte.TYPE);
        classMap.put("double", Double.TYPE);
        classMap.put("float", Float.TYPE);
        classMap.put("long", Long.TYPE);
        classMap.put("boolean", Boolean.TYPE);
        classMap.put("java.lang.Integer", Integer.class);
        classMap.put("java.lang.Short", Short.class);
        classMap.put("java.lang.Byte", Byte.class);
        classMap.put("java.lang.Double", Double.class);
        classMap.put("java.lang.Float", Float.class);
        classMap.put("java.lang.Long", Long.class);
        classMap.put("java.lang.Boolean", Boolean.class);
        classMap.put("java.lang.String", String.class);
    }
}

