/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.Logger;

public class StreamUtil {
    private static final String UTF_8 = "UTF-8";

    private StreamUtil() {
    }

    public static String stream2String(InputStream in) {
        return StreamUtil.stream2String(in, UTF_8);
    }

    public static String stream2String(InputStream in, String charsetName) {
        return StreamUtil.stream2String(in, null, UTF_8);
    }

    public static String stream2String(InputStream in, Map<String, String> map) {
        return StreamUtil.stream2String(in, map, UTF_8);
    }

    public static String stream2String(InputStream in, Map<String, String> map, String charsetName) {
        if (in == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try (BufferedReader bfReader = new BufferedReader(new InputStreamReader(in, charsetName));){
            String line = bfReader.readLine();
            while (line != null) {
                if (map != null) {
                    line = StreamUtil.replace(line, map);
                }
                sb.append(line);
                line = bfReader.readLine();
                if (line == null) continue;
                sb.append("\n");
            }
        }
        catch (Exception e) {
            throw ExceptionHelper.convert(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                Logger.debug(e2.getMessage(), e2);
            }
        }
        return sb.toString();
    }

    private static String replace(String line, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            line = line.replace(entry.getKey(), entry.getValue());
        }
        return line;
    }
}

