/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util;

import java.util.regex.Pattern;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isBlank(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean isNotBlank(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isEmpty(String[] strings) {
        return strings == null || strings.length == 0;
    }

    public static boolean isNotEmpty(String[] strings) {
        return !StringUtils.isEmpty(strings);
    }

    public static boolean isContainUpperCase(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        StringBuffer buf = new StringBuffer(str);
        for (int i = 0; i < buf.length(); ++i) {
            if (!Character.isUpperCase(buf.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainLetter(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        StringBuffer buf = new StringBuffer(str);
        for (int i = 0; i < buf.length(); ++i) {
            if (!Character.isLetter(buf.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String toCommasString(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return "";
        }
        if (stringArray.length == 1) {
            return stringArray[1];
        }
        String idsStr = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                idsStr = idsStr + ",";
            }
            idsStr = idsStr + stringArray[i];
        }
        return idsStr;
    }

    public static String toCommasString(Number[] numArray) {
        if (numArray == null) {
            return null;
        }
        if (numArray.length == 0) {
            return "";
        }
        if (numArray.length == 1) {
            if (numArray[1] == null) {
                return null;
            }
            return numArray[1] + "";
        }
        String idsStr = "";
        for (int i = 0; i < numArray.length; ++i) {
            idsStr = idsStr + numArray[i];
            if (i == numArray.length - 1) continue;
            idsStr = idsStr + ",";
        }
        return idsStr;
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]+$");
        return pattern.matcher(str).matches();
    }

    public static boolean isNumber(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[0-9]+(\\\\.[0-9]+)?$");
        return pattern.matcher(str).matches();
    }

    public static boolean justLikeChar(String name) {
        if (name == null) {
            return false;
        }
        String p = "^[%_]+$";
        Pattern pattern = Pattern.compile(p);
        return pattern.matcher(name).find();
    }

    public static String escapeLike(String value) {
        if (value == null) {
            return value;
        }
        StringBuffer buf = new StringBuffer(value);
        for (int i = 0; i < buf.length(); ++i) {
            char temp = buf.charAt(i);
            if (temp == '\\') {
                ++i;
                continue;
            }
            if (temp != '%' && temp != '_') continue;
            buf.insert(i++, '\\');
        }
        return buf.toString();
    }

    public static String getUnicode(String str) {
        String strTemp = "";
        if (str != null) {
            for (char c : str.toCharArray()) {
                strTemp = c > '\u00ff' ? strTemp + "\\u" + Integer.toHexString(c) : strTemp + "\\u00" + Integer.toHexString(c);
            }
        }
        return strTemp;
    }

    public static void trim(String[] str) {
        if (str == null || str.length == 0) {
            return;
        }
        for (int i = 0; i < str.length; ++i) {
            str[i] = str[i].trim();
        }
    }
}

