/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.distribution;

import org.teasoft.bee.distribution.GenId;
import org.teasoft.bee.distribution.Worker;
import org.teasoft.honey.distribution.DefaultWorker;
import org.teasoft.honey.distribution.Start;
import org.teasoft.honey.osql.core.Logger;

public class OneTimeSnowflakeId
implements GenId {
    private Worker worker;
    private long timestamp;
    private long time;
    private long segment = 0L;
    private long workerId = this.getWorker().getWorkerId();
    private long sequence = 0L;
    private static final long segmentBits = 9L;
    private static final long workerIdBits = 10L;
    private static final long sequenceBits = 13L;
    private static final long timestampShift = 32L;
    private static final long segmentShift = 23L;
    private static final long workerIdShift = 13L;
    private static final long maxSegment = 511L;
    private static final long maxSequence = 8192L;
    private long startSecond = Start.getStartSecond();
    private long _counter = 0L;

    public OneTimeSnowflakeId() {
        this.timestamp = this._curSecond();
        this.time = this.timestamp - this.startSecond;
    }

    public Worker getWorker() {
        if (this.worker == null) {
            return new DefaultWorker();
        }
        return this.worker;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public synchronized long get() {
        long id = this.getNextId();
        this.testSpeedLimit();
        return id;
    }

    public synchronized long[] getRangeId(int sizeOfIds) {
        if ((long)sizeOfIds > 8192L) {
            Logger.warn("parameter sizeOfIds(" + sizeOfIds + ") greate maxSequence(" + 8192L + ") will cause range Id do not continue!");
            return null;
        }
        long[] r = new long[2];
        r[0] = this.getNextId();
        this.sequence = this.sequence + (long)sizeOfIds - 1L - 1L;
        this._counter = this._counter + (long)sizeOfIds - 1L - 1L;
        if (this.sequence + 1L >> 13 > 0L) {
            if (this.segment >= 511L) {
                ++this.time;
                this.segment = 0L;
            } else {
                ++this.segment;
            }
            this.sequence = 0L;
            return this.getRangeId(sizeOfIds);
        }
        r[1] = this.getNextId();
        this.testSpeedLimit();
        return r;
    }

    private synchronized long getNextId() {
        ++this.sequence;
        ++this._counter;
        if (this.sequence >> 13 > 0L) {
            if (this.segment >= 511L) {
                ++this.time;
                this.segment = 0L;
            } else {
                ++this.segment;
            }
            this.sequence = 0L;
        }
        return this.time << 32 | this.segment << 23 | this.workerId << 13 | this.sequence;
    }

    private long _curSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    private synchronized void testSpeedLimit() {
        long spentTime = this._curSecond() - this.timestamp + 1L;
        if (spentTime > 0L && spentTime << 22 > this._counter) {
            return;
        }
        try {
            this.wait(10L);
            this.testSpeedLimit();
        }
        catch (Exception e) {
            Logger.warn(e.getMessage());
        }
    }
}

