/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.distribution;

import java.util.Random;
import org.teasoft.bee.distribution.GenId;
import org.teasoft.bee.distribution.Worker;
import org.teasoft.honey.distribution.DefaultWorker;
import org.teasoft.honey.distribution.Start;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;

public class PearFlowerId
implements GenId {
    private Random random = new Random();
    private boolean isBatch = false;
    private Worker worker;
    private long timestamp;
    private long segment = 0L;
    private long workerId = this.getWorker().getWorkerId();
    private long sequence = 0L;
    private static final long segmentBits = 9L;
    private static final long workerIdBits = 10L;
    private static final long sequenceBits = 13L;
    private static final long timestampShift = 32L;
    private static final long segmentShift = 23L;
    private static final long workerIdShift = 13L;
    private static final long maxSegment = 511L;
    private static final long maxSequence = 8192L;
    private static final long halfWorkid = 512L;
    private static final long fullWorkid = 1024L;
    private long startSecond = Start.getStartSecond();
    private long lastTimestamp = -1L;
    private static volatile boolean useHalfWorkId;
    private static long tolerateSecond;
    private static long switchWorkIdTimeThreshold;
    private static int randomNumBound;

    public PearFlowerId() {
        int t_randomNumBound;
        boolean t_useHalfWorkId = HoneyConfig.getHoneyConfig().pearFlowerId_useHalfWorkId;
        long t_tolerateSecond = HoneyConfig.getHoneyConfig().pearFlowerId_tolerateSecond;
        long t_switchWorkIdTimeThreshold = HoneyConfig.getHoneyConfig().pearFlowerId_switchWorkIdTimeThreshold;
        useHalfWorkId = t_useHalfWorkId;
        if (t_tolerateSecond > 0L) {
            tolerateSecond = t_tolerateSecond;
        }
        if (t_switchWorkIdTimeThreshold > 0L) {
            switchWorkIdTimeThreshold = t_switchWorkIdTimeThreshold;
        }
        randomNumBound = (t_randomNumBound = HoneyConfig.getHoneyConfig().pearFlowerId_randomNumBound) < 1 || t_randomNumBound > 512 ? 2 : t_randomNumBound;
    }

    public Worker getWorker() {
        if (this.worker == null) {
            return new DefaultWorker();
        }
        return this.worker;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public synchronized long get() {
        return this.getNextId();
    }

    public synchronized long[] getRangeId(int sizeOfIds) {
        if ((long)sizeOfIds > 8192L) {
            Logger.warn("parameter sizeOfIds(" + sizeOfIds + ") greate maxSequence(" + 8192L + ") will cause range Id do not continue!");
            return null;
        }
        long[] r = new long[2];
        r[0] = this.getNextId();
        this.sequence = this.sequence + (long)sizeOfIds - 1L - 1L;
        if (this.sequence + 1L >> 13 > 0L) {
            if (this.segment >= 511L) {
                ++this.lastTimestamp;
                this.segment = 0L;
            } else {
                ++this.segment;
            }
            this.sequence = 0L;
            return this.getRangeId(sizeOfIds);
        }
        this.isBatch = true;
        r[1] = this.getNextId();
        return r;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized long getNextId() {
        block16: {
            this.timestamp = this.currentSecond();
            if (this.timestamp < this.lastTimestamp) {
                long offset;
                if (tolerateSecond <= 0L) {
                    tolerateSecond = 1L;
                }
                if ((offset = this.lastTimestamp - this.timestamp) <= tolerateSecond) {
                    try {
                        this.wait(400L * tolerateSecond);
                        this.timestamp = this.currentSecond();
                        if (this.timestamp < this.lastTimestamp) {
                            this.wait(600L * tolerateSecond + 10L);
                            this.timestamp = this.currentSecond();
                            if (this.timestamp < this.lastTimestamp) {
                                return -1L;
                            }
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        Logger.warn(e.getMessage());
                        return -2L;
                    }
                }
                if (offset > switchWorkIdTimeThreshold) {
                    if (!useHalfWorkId) return -1L;
                    this.switchWorkerId();
                    this.lastTimestamp = -1L;
                } else {
                    try {
                        this.wait(tolerateSecond * 500L);
                        this.timestamp = this.currentSecond();
                        if (this.timestamp < this.lastTimestamp) {
                            return -3L;
                        }
                    }
                    catch (Exception e) {
                        Logger.warn(e.getMessage());
                        return -2L;
                    }
                }
            }
        }
        if (this.timestamp != this.lastTimestamp) {
            if (this.timestamp <= this.lastTimestamp) return this.timestamp - this.startSecond << 32 | this.segment << 23 | this.workerId << 13 | this.sequence;
            this.segment = 0L;
            this.setStartSequence();
            this.lastTimestamp = this.timestamp;
            return this.timestamp - this.startSecond << 32 | this.segment << 23 | this.workerId << 13 | this.sequence;
        }
        ++this.sequence;
        if (this.sequence >> 13 <= 0L) return this.timestamp - this.startSecond << 32 | this.segment << 23 | this.workerId << 13 | this.sequence;
        if (this.segment < 511L) {
            this.setStartSequence();
            ++this.segment;
            return this.timestamp - this.startSecond << 32 | this.segment << 23 | this.workerId << 13 | this.sequence;
        }
        try {
            this.wait(100L);
            return this.getNextId();
        }
        catch (Exception e) {
            Logger.warn(e.getMessage());
            return -2L;
        }
    }

    private void setStartSequence() {
        if (this.isBatch) {
            this.isBatch = false;
            this.sequence = 0L;
        } else {
            this.sequence = randomNumBound == 1 ? 0L : (long)this.random.nextInt(randomNumBound);
        }
    }

    private long currentSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    private void switchWorkerId() {
        this.workerId = (this.workerId + 512L) % 1024L;
    }

    static {
        tolerateSecond = 10L;
        switchWorkIdTimeThreshold = 120L;
    }
}

