/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeErrorNameException;
import org.teasoft.honey.osql.core.Expression;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.util.NameCheckUtil;
import org.teasoft.honey.util.StringUtils;

public class ConditionImpl
implements Condition {
    private SuidType suidType;
    private List<Expression> list = new ArrayList<Expression>();
    private Set<String> whereField = new HashSet<String>();
    private IncludeType includeType;
    private String[] selectField;
    private Boolean isForUpdate;
    private List<Expression> updateSetList = new ArrayList<Expression>();
    private Set<String> updatefields = new HashSet<String>();
    private List<FunExpress> funExpList = new ArrayList<FunExpress>();
    private List<Expression> onExpList = new ArrayList<Expression>();
    private Map<String, String> orderByMap = new LinkedHashMap<String, String>();
    private boolean isStartGroupBy = true;
    private boolean isStartHaving = true;
    private boolean isStartOrderBy = true;
    private static final String COMMA = ",";
    private static final String ORDER_BY = "orderBy";
    private Integer start;
    private Integer size;
    private static final String setAdd = "setAdd";
    private static final String setMultiply = "setMultiply";
    private static final String setAddField = "setAddField";
    private static final String setMultiplyField = "setMultiplyField";
    private static final String setWithField = "setWithField";

    public Condition start(Integer start) {
        this.start = start;
        return this;
    }

    public Condition size(Integer size) {
        this.size = size;
        return this;
    }

    public IncludeType getIncludeType() {
        return this.includeType;
    }

    public Condition setIncludeType(IncludeType includeType) {
        this.includeType = includeType;
        return this;
    }

    public Condition op(String field, Op op, Object value) {
        this.checkField(field);
        this.list.add(new Expression(field, op, value));
        this.whereField.add(field);
        return this;
    }

    public Condition opOn(String field, Op op, String value) {
        this.checkField(field);
        this.onExpList.add(new Expression(field, op, value));
        return this;
    }

    public Condition opOn(String field, Op op, Number value) {
        this.checkField(field);
        this.onExpList.add(new Expression(field, op, value));
        return this;
    }

    public Condition opWithField(String field1, Op op, String field2) {
        this.checkField(field1);
        this.checkField(field2);
        Expression exp = new Expression(field1, op, field2);
        exp.setOpNum(-3);
        this.list.add(exp);
        this.whereField.add(field1);
        return this;
    }

    public Set<String> getWhereFields() {
        return this.whereField;
    }

    public Condition and() {
        Expression exp = new Expression();
        exp.setOpNum(1);
        exp.value = K.and;
        this.list.add(exp);
        return this;
    }

    public Condition or() {
        Expression exp = new Expression();
        exp.setOpNum(1);
        exp.value = K.or;
        this.list.add(exp);
        return this;
    }

    public Condition lParentheses() {
        Expression exp = new Expression();
        exp.setOpNum(-2);
        exp.value = "(";
        this.list.add(exp);
        return this;
    }

    public Condition rParentheses() {
        Expression exp = new Expression();
        exp.setOpNum(-1);
        exp.value = ")";
        this.list.add(exp);
        return this;
    }

    public Condition groupBy(String field) {
        this.checkField(field);
        Expression exp = new Expression();
        exp.fieldName = field;
        exp.opType = "groupBy";
        if (this.isStartGroupBy) {
            this.isStartGroupBy = false;
            exp.value = " " + K.groupBy + " ";
        } else {
            exp.value = COMMA;
        }
        this.list.add(exp);
        return this;
    }

    public Condition having(FunctionType functionType, String field, Op op, Number value) {
        this.checkFieldOrExpression(field);
        Expression exp = new Expression();
        exp.opType = "having";
        exp.fieldName = field;
        exp.value2 = value;
        exp.value3 = functionType.getName();
        exp.opNum = 5;
        exp.value4 = op.getOperator();
        if (this.isStartHaving) {
            if (this.isStartGroupBy) {
                throw new BeeErrorGrammarException("The 'having' must be after 'group by' !");
            }
            this.isStartHaving = false;
            exp.value = " " + K.having + " ";
        } else {
            exp.value = " " + K.and + " ";
        }
        this.list.add(exp);
        return this;
    }

    public Condition orderBy(String field) {
        this.checkFieldOrExpression(field);
        this.orderByMap.put(field, "asc");
        Expression exp = new Expression();
        exp.opType = ORDER_BY;
        exp.fieldName = field;
        exp.opNum = 2;
        if (this.isStartOrderBy) {
            this.isStartOrderBy = false;
            exp.value = " " + K.orderBy + " ";
        } else {
            exp.value = COMMA;
        }
        this.list.add(exp);
        return this;
    }

    public Condition orderBy(String field, OrderType orderType) {
        this.checkField(field);
        this.orderByMap.put(field, orderType.getName());
        Expression exp = new Expression();
        exp.opType = ORDER_BY;
        exp.fieldName = field;
        exp.value2 = orderType.getName();
        exp.opNum = 3;
        if (this.isStartOrderBy) {
            this.isStartOrderBy = false;
            exp.value = " " + K.orderBy + " ";
        } else {
            exp.value = COMMA;
        }
        this.list.add(exp);
        return this;
    }

    public Condition orderBy(FunctionType functionType, String field, OrderType orderType) {
        this.checkField(field);
        this.orderByMap.put(functionType.getName() + "(" + field + ")", orderType.getName());
        Expression exp = new Expression();
        exp.opType = ORDER_BY;
        exp.fieldName = field;
        exp.value2 = orderType.getName();
        exp.value3 = functionType.getName();
        exp.opNum = 4;
        if (this.isStartOrderBy) {
            this.isStartOrderBy = false;
            exp.value = " " + K.orderBy + " ";
        } else {
            exp.value = COMMA;
        }
        this.list.add(exp);
        return this;
    }

    private void setForBetween(String field, Object low, Object high, String type) {
        this.checkField(field);
        Expression exp = new Expression();
        exp.fieldName = field;
        exp.opType = type;
        exp.value = low;
        exp.value2 = high;
        exp.opNum = 3;
        this.whereField.add(field);
        this.list.add(exp);
    }

    public Condition between(String field, Number low, Number high) {
        this.setForBetween(field, low, high, " " + K.between + " ");
        return this;
    }

    public Condition notBetween(String field, Number low, Number high) {
        this.setForBetween(field, low, high, " " + K.notBetween + " ");
        return this;
    }

    public Condition between(String field, String low, String high) {
        this.setForBetween(field, low, high, " " + K.between + " ");
        return this;
    }

    public Condition notBetween(String field, String low, String high) {
        this.setForBetween(field, low, high, " " + K.notBetween + " ");
        return this;
    }

    public void setSuidType(SuidType suidType) {
        this.suidType = suidType;
    }

    public SuidType getSuidType() {
        return this.suidType;
    }

    public List<Expression> getExpList() {
        return this.list;
    }

    public List<Expression> getOnExpList() {
        return this.onExpList;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getSize() {
        return this.size;
    }

    public Condition setAdd(String field, Number num) {
        return this.forUpdateSet(field, num, setAdd);
    }

    public Condition setMultiply(String field, Number num) {
        return this.forUpdateSet(field, num, setMultiply);
    }

    public Condition setAdd(String field, String otherFieldName) {
        return this.forUpdateSet(field, otherFieldName, setAddField);
    }

    public Condition setMultiply(String field, String otherFieldName) {
        return this.forUpdateSet(field, otherFieldName, setMultiplyField);
    }

    public Condition setWithField(String field1, String field2) {
        return this.forUpdateSet(field1, field2, setWithField);
    }

    public Condition set(String fieldNmae, Number num) {
        return this._forUpdateSet2(fieldNmae, num);
    }

    public Condition set(String fieldNmae, String value) {
        return this._forUpdateSet2(fieldNmae, value);
    }

    public Condition selectField(String ... fieldList) {
        if (fieldList != null && fieldList.length == 1) {
            this.checkField(fieldList[0]);
        } else {
            this.checkField(StringUtils.toCommasString(fieldList));
        }
        this.selectField = fieldList;
        return this;
    }

    public Condition selectDistinctField(String fieldName) {
        this.funExpList.add(new FunExpress("distinct", fieldName, null));
        return this;
    }

    public Condition selectDistinctField(String fieldName, String alias) {
        this.checkField(alias);
        alias = this._toColumnName(alias);
        this.funExpList.add(new FunExpress("distinct", fieldName, alias));
        return this;
    }

    public String[] getSelectField() {
        return this.selectField;
    }

    public List<Expression> getUpdateExpList() {
        return this.updateSetList;
    }

    public List<FunExpress> getFunExpList() {
        return this.funExpList;
    }

    private Condition forUpdateSet(String field, String otherFieldName, String opType) {
        this.checkField(otherFieldName);
        return this._forUpdateSet(field, otherFieldName, opType);
    }

    private Condition forUpdateSet(String field, Number num, String opType) {
        return this._forUpdateSet(field, num, opType);
    }

    private Condition _forUpdateSet(String field, Object ojb, String opType) {
        this.checkField(field);
        Expression exp = new Expression();
        exp.fieldName = field;
        exp.opType = opType;
        exp.value = ojb;
        exp.opNum = 1;
        this.updatefields.add(field);
        this.updateSetList.add(exp);
        return this;
    }

    private Condition _forUpdateSet2(String field, Object ojb) {
        this.checkField(field);
        Expression exp = new Expression();
        exp.fieldName = field;
        exp.value = ojb;
        exp.opNum = 1;
        this.updatefields.add(field);
        this.updateSetList.add(exp);
        return this;
    }

    public Set<String> getUpdatefields() {
        return this.updatefields;
    }

    public Condition forUpdate() {
        this.isForUpdate = true;
        return this;
    }

    public Boolean getForUpdate() {
        return this.isForUpdate;
    }

    public Condition selectFun(FunctionType functionType, String fieldForFun) {
        this.funExpList.add(new FunExpress(functionType, fieldForFun, null));
        return this;
    }

    public Condition selectFun(FunctionType functionType, String fieldForFun, String alias) {
        this.checkField(alias);
        alias = this._toColumnName(alias);
        this.funExpList.add(new FunExpress(functionType, fieldForFun, alias));
        return this;
    }

    private void checkField(String fields) {
        NameCheckUtil.checkName(fields);
    }

    private void checkFieldOrExpression(String field) {
        if (NameCheckUtil.isIllegal(field)) {
            throw new BeeErrorNameException("The field: '" + field + "' is illegal!");
        }
    }

    public Map<String, String> getOrderByMap() {
        return this.orderByMap;
    }

    private String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    final class FunExpress {
        private String functionType;
        private String field;
        private String alias;

        public FunExpress(FunctionType functionType, String field, String alias) {
            ConditionImpl.this.checkField(field);
            this.functionType = functionType.getName();
            this.field = field;
            this.alias = alias;
        }

        public FunExpress(String functionType, String field, String alias) {
            ConditionImpl.this.checkField(field);
            this.functionType = functionType;
            this.field = field;
            this.alias = alias;
        }

        FunExpress() {
        }

        public String getFunctionType() {
            return this.functionType;
        }

        public void setFunctionType(String functionType) {
            this.functionType = functionType;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }
    }
}

