/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.logging.Log;
import org.teasoft.honey.logging.LoggerFactory;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import sun.reflect.Reflection;

public class Logger {
    private static Log log = null;

    private Logger() {
    }

    private static boolean isShowSQL() {
        return HoneyConfig.getHoneyConfig().showSQL;
    }

    private static boolean isShowSQLShowType() {
        return HoneyConfig.getHoneyConfig().showSql_showType;
    }

    private static boolean isShowExecutableSql() {
        return HoneyConfig.getHoneyConfig().showSql_showExecutableSql;
    }

    private static String getSqlLoggerLevel() {
        return HoneyConfig.getHoneyConfig().sqlLoggerLevel;
    }

    static void logSQL(String hardStr, String sql) {
        if (!Logger.isShowSQL()) {
            return;
        }
        if (LoggerFactory.isNoArgInConstructor()) {
            Logger.resetLog();
        } else {
            String callerClass = "";
            try {
                callerClass = Reflection.getCallerClass().getName();
            }
            catch (Error e) {
                try {
                    callerClass = Reflection.getCallerClass((int)2).getName();
                }
                catch (Throwable t) {
                    try {
                        callerClass = new Throwable().getStackTrace()[1].getClassName();
                    }
                    catch (Exception e2) {
                        callerClass = Logger.class.getName();
                    }
                }
            }
            Logger.resetLog(callerClass);
        }
        if (Logger.isShowSQL()) {
            List<PreparedValue> list = null;
            String insertIndex = (String)OneTimeParameter.getAttribute("_SYS_Bee_BatchInsert");
            list = HoneyUtil.isMysql() && insertIndex != null ? HoneyContext.getAndClearPreparedValue(sql) : HoneyContext.justGetPreparedValue(sql);
            String value = HoneyUtil.list2Value(list, Logger.isShowSQLShowType());
            if (value == null) {
                Logger._print("[Bee] " + hardStr, sql);
            } else {
                if (insertIndex != null) {
                    Logger.print("[Bee] --> index:" + insertIndex + " ,  [values]: " + value);
                } else {
                    Logger._print("[Bee] " + hardStr, sql + "   [values]: " + value);
                }
                if (Logger.isShowExecutableSql()) {
                    String executableSql = HoneyUtil.getExecutableSql(sql, list);
                    if (insertIndex != null) {
                        int endIndex = executableSql.indexOf("]_End ");
                        Logger._println("[Bee] " + hardStr + " ( ExecutableSql " + executableSql.substring(4, endIndex + 1) + " )", executableSql.substring(endIndex + 6) + " ;");
                    } else {
                        Logger._println("[Bee] " + hardStr + " ( ExecutableSql )", executableSql);
                    }
                }
            }
        }
    }

    private static void print(String s) {
        if (Logger.getSqlLoggerLevel() == null) {
            log.info(s);
        } else if ("warn".equalsIgnoreCase(Logger.getSqlLoggerLevel())) {
            log.warn(s);
        } else if ("error".equalsIgnoreCase(Logger.getSqlLoggerLevel())) {
            log.error(s);
        } else {
            log.info(s);
        }
    }

    private static void _print(String s1, String s2) {
        if (Logger.getSqlLoggerLevel() == null) {
            log.info(s1 + s2);
        } else if ("warn".equalsIgnoreCase(Logger.getSqlLoggerLevel())) {
            log.warn(s1 + s2);
        } else if ("error".equalsIgnoreCase(Logger.getSqlLoggerLevel())) {
            log.error(s1 + s2);
        } else {
            log.info(s1 + s2);
        }
    }

    private static void _println(String s1, String s2) {
        if (Logger.getSqlLoggerLevel() == null) {
            log.info(s1 + "\n" + s2);
        } else if ("warn".equalsIgnoreCase(Logger.getSqlLoggerLevel())) {
            log.warn(s1 + "\n" + s2);
        } else if ("error".equalsIgnoreCase(Logger.getSqlLoggerLevel())) {
            log.error(s1 + "\n" + s2);
        } else {
            log.info(s1 + "\n" + s2);
        }
    }

    public static void debug(String msg) {
        if (LoggerFactory.isNoArgInConstructor()) {
            Logger.resetLog();
        } else {
            String callerClass = "";
            try {
                callerClass = Reflection.getCallerClass().getName();
            }
            catch (Error e) {
                try {
                    callerClass = Reflection.getCallerClass((int)2).getName();
                }
                catch (Throwable t) {
                    try {
                        callerClass = new Throwable().getStackTrace()[1].getClassName();
                    }
                    catch (Exception e2) {
                        callerClass = Logger.class.getName();
                    }
                }
            }
            Logger.resetLog(callerClass);
        }
        log.debug(msg);
    }

    public static void debug(String msg, Throwable t) {
        if (LoggerFactory.isNoArgInConstructor()) {
            Logger.resetLog();
        } else {
            String callerClass = "";
            try {
                callerClass = Reflection.getCallerClass().getName();
            }
            catch (Error e) {
                try {
                    callerClass = Reflection.getCallerClass((int)2).getName();
                }
                catch (Throwable t2) {
                    try {
                        callerClass = new Throwable().getStackTrace()[1].getClassName();
                    }
                    catch (Exception e2) {
                        callerClass = Logger.class.getName();
                    }
                }
            }
            Logger.resetLog(callerClass);
        }
        log.debug(msg, t);
    }

    public static void info(String msg) {
        if (LoggerFactory.isNoArgInConstructor()) {
            Logger.resetLog();
        } else {
            String callerClass = "";
            try {
                callerClass = Reflection.getCallerClass().getName();
            }
            catch (Error e) {
                try {
                    callerClass = Reflection.getCallerClass((int)2).getName();
                }
                catch (Throwable t) {
                    try {
                        callerClass = new Throwable().getStackTrace()[1].getClassName();
                    }
                    catch (Exception e2) {
                        callerClass = Logger.class.getName();
                    }
                }
            }
            Logger.resetLog(callerClass);
        }
        log.info(msg);
    }

    public static void info(Number msg) {
        if (LoggerFactory.isNoArgInConstructor()) {
            Logger.resetLog();
        } else {
            String callerClass = "";
            try {
                callerClass = Reflection.getCallerClass().getName();
            }
            catch (Error e) {
                try {
                    callerClass = Reflection.getCallerClass((int)2).getName();
                }
                catch (Throwable t) {
                    try {
                        callerClass = new Throwable().getStackTrace()[1].getClassName();
                    }
                    catch (Exception e2) {
                        callerClass = Logger.class.getName();
                    }
                }
            }
            Logger.resetLog(callerClass);
        }
        log.info(msg + "");
    }

    public static void warn(String msg) {
        if (LoggerFactory.isNoArgInConstructor()) {
            Logger.resetLog();
        } else {
            String callerClass = "";
            try {
                callerClass = Reflection.getCallerClass().getName();
            }
            catch (Error e) {
                try {
                    callerClass = Reflection.getCallerClass((int)2).getName();
                }
                catch (Throwable t) {
                    try {
                        callerClass = new Throwable().getStackTrace()[1].getClassName();
                    }
                    catch (Exception e2) {
                        callerClass = Logger.class.getName();
                    }
                }
            }
            Logger.resetLog(callerClass);
        }
        log.warn(msg);
    }

    public static void warn(String msg, Throwable t) {
        if (LoggerFactory.isNoArgInConstructor()) {
            Logger.resetLog();
        } else {
            String callerClass = "";
            try {
                callerClass = Reflection.getCallerClass().getName();
            }
            catch (Error e) {
                try {
                    callerClass = Reflection.getCallerClass((int)2).getName();
                }
                catch (Throwable t2) {
                    try {
                        callerClass = new Throwable().getStackTrace()[1].getClassName();
                    }
                    catch (Exception e2) {
                        callerClass = Logger.class.getName();
                    }
                }
            }
            Logger.resetLog(callerClass);
        }
        log.warn(msg, t);
    }

    public static void warn(Number msg) {
        if (LoggerFactory.isNoArgInConstructor()) {
            Logger.resetLog();
        } else {
            String callerClass = "";
            try {
                callerClass = Reflection.getCallerClass().getName();
            }
            catch (Error e) {
                try {
                    callerClass = Reflection.getCallerClass((int)2).getName();
                }
                catch (Throwable t) {
                    try {
                        callerClass = new Throwable().getStackTrace()[1].getClassName();
                    }
                    catch (Exception e2) {
                        callerClass = Logger.class.getName();
                    }
                }
            }
            Logger.resetLog(callerClass);
        }
        log.warn(msg + "");
    }

    public static void error(String msg) {
        if (LoggerFactory.isNoArgInConstructor()) {
            Logger.resetLog();
        } else {
            String callerClass = "";
            try {
                callerClass = Reflection.getCallerClass().getName();
            }
            catch (Error e) {
                try {
                    callerClass = Reflection.getCallerClass((int)2).getName();
                }
                catch (Throwable t) {
                    try {
                        callerClass = new Throwable().getStackTrace()[1].getClassName();
                    }
                    catch (Exception e2) {
                        callerClass = Logger.class.getName();
                    }
                }
            }
            Logger.resetLog(callerClass);
        }
        log.error(msg);
    }

    public static void error(String msg, Throwable t) {
        if (LoggerFactory.isNoArgInConstructor()) {
            Logger.resetLog();
        } else {
            String callerClass = "";
            try {
                callerClass = Reflection.getCallerClass().getName();
            }
            catch (Error e) {
                try {
                    callerClass = Reflection.getCallerClass((int)2).getName();
                }
                catch (Throwable t2) {
                    try {
                        callerClass = new Throwable().getStackTrace()[1].getClassName();
                    }
                    catch (Exception e2) {
                        callerClass = Logger.class.getName();
                    }
                }
            }
            Logger.resetLog(callerClass);
        }
        log.error(msg, t);
    }

    public static void error(Number msg) {
        if (LoggerFactory.isNoArgInConstructor()) {
            Logger.resetLog();
        } else {
            String callerClass = "";
            try {
                callerClass = Reflection.getCallerClass().getName();
            }
            catch (Error e) {
                try {
                    callerClass = Reflection.getCallerClass((int)2).getName();
                }
                catch (Throwable t) {
                    try {
                        callerClass = new Throwable().getStackTrace()[1].getClassName();
                    }
                    catch (Exception e2) {
                        callerClass = Logger.class.getName();
                    }
                }
            }
            Logger.resetLog(callerClass);
        }
        log.error(msg + "");
    }

    private static void resetLog() {
        if (LoggerFactory.isNoArgInConstructor()) {
            log = Logger._getLog();
        }
    }

    private static void resetLog(String callerClass) {
        if (LoggerFactory.isNoArgInConstructor()) {
            log = Logger._getLog();
        } else {
            try {
                log = Logger._getLog(callerClass);
            }
            catch (Exception e) {
                log = Logger._getLog(Logger.class.getName());
            }
        }
    }

    private static Log _getLog() {
        return LoggerFactory.getLog();
    }

    private static Log _getLog(String className) {
        return LoggerFactory.getLog(className);
    }
}

