/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.search.Operator;
import org.teasoft.bee.osql.search.Search;
import org.teasoft.honey.osql.core.BeeFactoryHelper;
import org.teasoft.honey.util.StringUtils;

public class SearchProcessor {
    private SearchProcessor() {
    }

    public static Condition parseSearch(Search[] search) {
        Condition condition = BeeFactoryHelper.getCondition();
        block22: for (int i = 0; i < search.length; ++i) {
            String field = search[i].getField();
            Operator operator = search[i].getOp();
            String value = search[i].getValue1();
            String value2 = search[i].getValue2();
            String op2 = search[i].getOp2();
            if ("or".equalsIgnoreCase(op2 = SearchProcessor.trim(op2))) {
                condition.or();
            } else if ("(".equals(op2)) {
                condition.lParentheses();
            } else if (")".equals(op2)) {
                condition.rParentheses();
            } else if ("or (".equalsIgnoreCase(op2)) {
                condition.or().lParentheses();
            } else if (") or".equalsIgnoreCase(op2)) {
                condition.rParentheses().or();
            } else if ("and (".equalsIgnoreCase(op2)) {
                condition.and().lParentheses();
            } else if (") and".equalsIgnoreCase(op2)) {
                condition.rParentheses().and();
            }
            if (operator == null) continue;
            switch (operator) {
                case like: {
                    if ("Left".equalsIgnoreCase(value2)) {
                        condition.op(field, Op.likeLeft, (Object)value);
                        continue block22;
                    }
                    if ("Right".equalsIgnoreCase(value2)) {
                        condition.op(field, Op.likeRight, (Object)value);
                        continue block22;
                    }
                    if ("LeftRight".equalsIgnoreCase(value2)) {
                        condition.op(field, Op.likeLeftRight, (Object)value);
                        continue block22;
                    }
                    condition.op(field, Op.like, (Object)value);
                    continue block22;
                }
                case notLike: {
                    value = SearchProcessor.adjustValueForLike(value, value2);
                    condition.op(field, Op.notLike, (Object)value);
                    continue block22;
                }
                case between: {
                    SearchProcessor.checkForBetween(value, value2);
                    SearchProcessor.setBetweenValue(field, value, value2, condition);
                    continue block22;
                }
                case notBetween: {
                    SearchProcessor.checkForBetween(value, value2);
                    SearchProcessor.setNotBetweenValue(field, value, value2, condition);
                    continue block22;
                }
                case in: {
                    condition.op(field, Op.in, (Object)value);
                    continue block22;
                }
                case notIn: {
                    condition.op(field, Op.notIn, (Object)value);
                    continue block22;
                }
                case max: {
                    if (StringUtils.isNotBlank(value)) {
                        condition.selectFun(FunctionType.MAX, field, value);
                        continue block22;
                    }
                    condition.selectFun(FunctionType.MAX, field);
                    continue block22;
                }
                case min: {
                    if (StringUtils.isNotBlank(value)) {
                        condition.selectFun(FunctionType.MIN, field, value);
                        continue block22;
                    }
                    condition.selectFun(FunctionType.MIN, field);
                    continue block22;
                }
                case sum: {
                    if (StringUtils.isNotBlank(value)) {
                        condition.selectFun(FunctionType.SUM, field, value);
                        continue block22;
                    }
                    condition.selectFun(FunctionType.SUM, field);
                    continue block22;
                }
                case avg: {
                    if (StringUtils.isNotBlank(value)) {
                        condition.selectFun(FunctionType.AVG, field, value);
                        continue block22;
                    }
                    condition.selectFun(FunctionType.AVG, field);
                    continue block22;
                }
                case count: {
                    if (StringUtils.isNotBlank(value)) {
                        condition.selectFun(FunctionType.COUNT, field, value);
                        continue block22;
                    }
                    condition.selectFun(FunctionType.COUNT, field);
                    continue block22;
                }
                case distinct: {
                    if (StringUtils.isNotBlank(value)) {
                        condition.selectDistinctField(field, value);
                        continue block22;
                    }
                    condition.selectDistinctField(field);
                    continue block22;
                }
                case groupBy: {
                    condition.groupBy(field);
                    continue block22;
                }
                case orderBy: {
                    if (StringUtils.isNotBlank(value)) {
                        if ("asc".equalsIgnoreCase(value)) {
                            condition.orderBy(field, OrderType.ASC);
                            continue block22;
                        }
                        if ("desc".equalsIgnoreCase(value)) {
                            condition.orderBy(field, OrderType.DESC);
                            continue block22;
                        }
                        throw new BeeErrorGrammarException("OrderType just support ASC or DESC !");
                    }
                    condition.orderBy(field);
                    continue block22;
                }
                case eq: {
                    condition.op(field, Op.eq, (Object)value);
                    continue block22;
                }
                case nq: {
                    condition.op(field, Op.nq, (Object)value);
                    continue block22;
                }
                case ge: {
                    condition.op(field, Op.ge, (Object)value);
                    continue block22;
                }
                case le: {
                    condition.op(field, Op.le, (Object)value);
                    continue block22;
                }
                case gt: {
                    condition.op(field, Op.gt, (Object)value);
                    continue block22;
                }
                case lt: {
                    condition.op(field, Op.lt, (Object)value);
                    continue block22;
                }
            }
        }
        return condition;
    }

    private static String adjustValueForLike(String value, String value2) {
        if (StringUtils.isNotBlank(value2)) {
            if ("Left".equalsIgnoreCase(value2)) {
                value = "%" + value;
            } else if ("Right".equalsIgnoreCase(value2)) {
                value = value + "%";
            } else if ("LeftRight".equalsIgnoreCase(value2)) {
                value = "%" + value + "%";
            }
        }
        return value;
    }

    private static void checkForBetween(String value, String value2) {
        if (StringUtils.isBlank(value)) {
            throw new BeeErrorGrammarException("the min value of Between invalid!");
        }
        if (StringUtils.isBlank(value2)) {
            throw new BeeErrorGrammarException("the max value of Between invalid!");
        }
    }

    private static String trim(String str) {
        if (str != null) {
            str = str.trim();
        }
        return str;
    }

    private static void setBetweenValue(String field, String value, String value2, Condition condition) {
        try {
            if (StringUtils.isInteger(value) && StringUtils.isInteger(value2)) {
                condition.between(field, (Number)Long.parseLong(value), (Number)Long.parseLong(value2));
            } else if (StringUtils.isNumber(value) && StringUtils.isNumber(value2)) {
                condition.between(field, (Number)Double.parseDouble(value), (Number)Double.parseDouble(value2));
            } else {
                condition.between(field, value, value2);
            }
        }
        catch (Exception e) {
            condition.between(field, value, value2);
        }
    }

    private static void setNotBetweenValue(String field, String value, String value2, Condition condition) {
        try {
            if (StringUtils.isInteger(value) && StringUtils.isInteger(value2)) {
                condition.notBetween(field, (Number)Long.parseLong(value), (Number)Long.parseLong(value2));
            } else if (StringUtils.isNumber(value) && StringUtils.isNumber(value2)) {
                condition.notBetween(field, (Number)Double.parseDouble(value), (Number)Double.parseDouble(value2));
            } else {
                condition.notBetween(field, value, value2);
            }
        }
        catch (Exception e) {
            condition.notBetween(field, value, value2);
        }
    }
}

