/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.teasoft.bee.osql.exception.NoConfigException;
import org.teasoft.bee.osql.transaction.Transaction;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.BootApplicationProp;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.JndiDataSource;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.transaction.JdbcTransaction;
import org.teasoft.honey.util.StringUtils;

public final class SessionFactory {
    private static BeeFactory beeFactory = null;
    private static boolean isFirst = true;
    private static boolean isFirstWithOriginal = true;

    public static BeeFactory getBeeFactory() {
        if (beeFactory == null) {
            beeFactory = BeeFactory.getInstance();
        }
        return beeFactory;
    }

    public void setBeeFactory(BeeFactory beeFactory) {
        SessionFactory._setBeeFactory(beeFactory);
    }

    private static void _setBeeFactory(BeeFactory beeFactory) {
        SessionFactory.beeFactory = beeFactory;
    }

    public static Connection getConnection() {
        Connection conn = null;
        try {
            boolean isJndiType;
            DataSource ds = SessionFactory.getBeeFactory().getDataSource();
            if (ds == null && (isJndiType = HoneyConfig.getHoneyConfig().jndiType) && (ds = new JndiDataSource().getDataSource()) != null) {
                SessionFactory.getBeeFactory().setDataSource(ds);
            }
            if (ds != null) {
                conn = ds.getConnection();
            } else {
                conn = SessionFactory.getOriginalConn();
                if (isFirstWithOriginal || HoneyConfig.getHoneyConfig().multiDS_enable) {
                    isFirstWithOriginal = false;
                    Logger.debug("Use OriginalConn!");
                }
            }
        }
        catch (SQLException e) {
            Logger.debug(e.getMessage());
            throw ExceptionHelper.convert(e);
        }
        catch (ClassNotFoundException e) {
            Logger.error("Can not find the Database driver!  " + e.getMessage());
            throw new NoConfigException("Can not find the Database driver(maybe miss the jar file).");
        }
        catch (Exception e) {
            throw ExceptionHelper.convert(e);
        }
        return conn;
    }

    public static Transaction getTransaction() {
        Transaction tran = null;
        if (SessionFactory.getBeeFactory().getTransaction() == null) {
            boolean isAndroid = HoneyConfig.getHoneyConfig().isAndroid;
            boolean isHarmony = HoneyConfig.getHoneyConfig().isHarmony;
            if (isAndroid || isHarmony) {
                String c = "";
                if (isAndroid) {
                    c = "org.teasoft.beex.android.SQLiteTransaction";
                } else if (isHarmony) {
                    c = "org.teasoft.beex.harmony.SQLiteTransaction";
                }
                try {
                    return (Transaction)Class.forName(c).newInstance();
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), e);
                }
            }
            tran = new JdbcTransaction();
        } else {
            tran = SessionFactory.getBeeFactory().getTransaction();
        }
        return tran;
    }

    private static Connection getOriginalConn() throws ClassNotFoundException, SQLException, Exception {
        String driverName = HoneyConfig.getHoneyConfig().getDriverName();
        String url = HoneyConfig.getHoneyConfig().getUrl();
        String username = HoneyConfig.getHoneyConfig().getUsername();
        String p = HoneyConfig.getHoneyConfig().getPassword();
        if (StringUtils.isBlank(url)) {
            BootApplicationProp prop = new BootApplicationProp();
            url = prop.getPropText("bee.db.url");
            if (StringUtils.isBlank(url)) {
                url = prop.getPropText("spring.datasource.url");
                username = prop.getPropText("spring.datasource.username");
                p = prop.getPropText("spring.datasource.password");
                String driverClass1 = prop.getPropText("spring.datasource.driverClassName");
                String driverClass2 = prop.getPropText("spring.datasource.driver-class-name");
                driverName = driverClass1 != null ? driverClass1 : driverClass2;
            } else {
                username = prop.getPropText("bee.db.username");
                p = prop.getPropText("bee.db.password");
                driverName = prop.getPropText("bee.db.driverName");
            }
        }
        String nullInfo = "";
        String DO_NOT_CONFIG = " do not config; ";
        if (driverName == null) {
            nullInfo = nullInfo + "bee.db.driverName do not config; ";
        }
        if (url == null) {
            nullInfo = nullInfo + "bee.db.url do not config; ";
        }
        if (url == null) {
            throw new Exception("The url can not be null when get the Connection directly from DriverManager!  (" + nullInfo + ")");
        }
        if (username == null) {
            nullInfo = nullInfo + "bee.db.username do not config; ";
        }
        if (p == null) {
            nullInfo = nullInfo + "bee.db.password do not config; ";
        }
        if (!"".equals(nullInfo) && isFirst) {
            Logger.warn("Do not set the database info: " + nullInfo);
            isFirst = false;
        }
        Connection conn = null;
        if (StringUtils.isNotBlank(driverName)) {
            Class.forName(driverName);
        }
        conn = StringUtils.isNotBlank(username) && p != null ? DriverManager.getConnection(url, username, p) : DriverManager.getConnection(url);
        return conn;
    }
}

